/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Insets2D;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.FigureUtil;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.RotateEllipseFigure;
import org.openmicroscopy.shoola.util.ui.drawingtools.texttools.TransformedDrawingTextTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipseTextFigure
extends RotateEllipseFigure
implements TextHolderFigure {
    private boolean fromTransformUpdate;
    private boolean editable;
    private transient TextLayout textLayout;
    private Rectangle2D.Double textBounds;

    private TextLayout getTextLayout() {
        if (this.textLayout == null) {
            this.textLayout = FigureUtil.createLayout(this.getText(), this.getFontRenderContext(), this.getFont(), (Boolean)AttributeKeys.FONT_UNDERLINE.get((Figure)this));
        }
        return this.textLayout;
    }

    public EllipseTextFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0);
    }

    public EllipseTextFigure(String t, double x, double y, double w, double h) {
        super(x, y, w, h);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, true);
        this.setAttributeEnabled(MeasurementAttributes.HEIGHT, true);
        this.setAttributeEnabled(MeasurementAttributes.WIDTH, true);
        this.setAttribute(MeasurementAttributes.WIDTH, w);
        this.setAttribute(MeasurementAttributes.HEIGHT, h);
        this.setAttribute(AttributeKeys.TEXT, t);
        this.textLayout = null;
        this.textBounds = null;
        this.editable = true;
        this.fromTransformUpdate = false;
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        super.setAttribute(key, newValue);
        if (!this.fromTransformUpdate) {
            if (key.getKey().equals(MeasurementAttributes.HEIGHT.getKey())) {
                double newHeight = (Double)MeasurementAttributes.HEIGHT.get((Figure)this);
                this.setHeight(newHeight);
            }
            if (key.getKey().equals(MeasurementAttributes.WIDTH.getKey())) {
                double newWidth = (Double)MeasurementAttributes.WIDTH.get((Figure)this);
                this.setWidth(newWidth);
            }
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        super.transform(tx);
        this.fromTransformUpdate = true;
        MeasurementAttributes.HEIGHT.set((Figure)this, (Object)this.getTransformedEllipse().getBounds2D().getHeight());
        MeasurementAttributes.WIDTH.set((Figure)this, (Object)this.getTransformedEllipse().getBounds2D().getWidth());
        this.fromTransformUpdate = false;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        super.setBounds(anchor, lead);
        this.fromTransformUpdate = true;
        MeasurementAttributes.HEIGHT.set((Figure)this, (Object)this.getTransformedEllipse().getBounds2D().getHeight());
        MeasurementAttributes.WIDTH.set((Figure)this, (Object)this.getTransformedEllipse().getBounds2D().getWidth());
        this.fromTransformUpdate = false;
    }

    public LinkedList<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            TransformHandleKit.addTransformHandles((Figure)this, handles);
        }
        return handles;
    }

    protected Rectangle2D.Double getTextBounds() {
        if (this.textBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return this.textBounds;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            this.invalidate();
            return new TransformedDrawingTextTool(this, this.getTransformedShape());
        }
        return null;
    }

    @Override
    protected void drawFill(Graphics2D g) {
        super.drawFill(g);
        this.drawText(g);
    }

    protected void drawText(Graphics2D g) {
        if (!((Boolean)MeasurementAttributes.SHOWTEXT.get((Figure)this)).booleanValue()) {
            return;
        }
        String text = this.getText();
        if (text != null || this.isEditable()) {
            if (text != null) {
                text = text.trim();
            }
            TextLayout layout = this.getTextLayout();
            FontMetrics fm = g.getFontMetrics((Font)AttributeKeys.FONT_FACE.get((Figure)this));
            double textWidth = fm.stringWidth(text);
            double textHeight = fm.getAscent();
            double x = this.getTransformedShape().getBounds().getCenterX() - textWidth / 2.0;
            double y = this.getTransformedShape().getBounds().getCenterY();
            Font font = (Font)AttributeKeys.FONT_FACE.get((Figure)this);
            Font viewFont = font.deriveFont(((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).intValue());
            g.setFont(viewFont);
            g.setColor((Color)AttributeKeys.TEXT_COLOR.get((Figure)this));
            this.textBounds = new Rectangle2D.Double(x, y, textWidth, textHeight);
            layout.draw(g, (float)this.textBounds.x, (float)this.textBounds.y);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = super.getDrawingArea();
        r.add(this.getTextBounds());
        return r;
    }

    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    public void setText(String newText) {
        this.setAttribute(DrawingAttributes.SHOWTEXT, true);
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    public int getTextColumns() {
        String t = this.getText();
        int n = 4;
        return t == null ? n : Math.max(t.length(), n);
    }

    public int getTabSize() {
        return 8;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)AttributeKeys.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)AttributeKeys.FILL_COLOR.get((Figure)this);
    }

    public float getFontSize() {
        return ((Double)AttributeKeys.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFontSize(float size) {
    }

    public boolean isTextOverflow() {
        return false;
    }

    @Override
    public EllipseTextFigure clone() {
        EllipseTextFigure that = (EllipseTextFigure)super.clone();
        that.setText(this.getText());
        return that;
    }
}

