/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.creationtools;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JToolBar;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingToolBarButtonFactory {
    private static final String BASE_NAME = "org.jhotdraw.draw.Labels";

    private static Collection<Action> createDrawingActions(DrawingEditor edit) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add((Action)new SelectAllAction());
        a.add((Action)new SelectSameAction(edit));
        a.add((Action)new DeleteAction());
        return a;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor edit) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add((Action)new DuplicateAction());
        a.add(null);
        a.add((Action)new MoveToFrontAction(edit));
        a.add((Action)new MoveToBackAction(edit));
        return a;
    }

    public static void addSelectionToolTo(JToolBar tb, DrawingEditor editor) {
        ButtonFactory.addSelectionToolTo((JToolBar)tb, (DrawingEditor)editor, DrawingToolBarButtonFactory.createDrawingActions(editor), DrawingToolBarButtonFactory.createSelectionActions(editor));
    }

    public static void addToolTo(JToolBar tb, DrawingEditor editor, Tool tool, String labelKey) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle((String)BASE_NAME);
        ButtonFactory.addToolTo((JToolBar)tb, (DrawingEditor)editor, (Tool)tool, (String)labelKey, (ResourceBundleUtil)labels);
    }

    public static JToolBar createDefaultBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.putClientProperty("toolButtonGroup", new ButtonGroup());
        return toolBar;
    }
}

