/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.attributes;

import java.util.HashMap;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.roi.io.IOConstants;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureProperties
extends AttributeKeys {
    private static HashMap<AttributeKey, Object> defaultProperties = new HashMap();
    protected HashMap<AttributeKey, Object> propertyMap = new HashMap();

    public FigureProperties(AttributeSet initialSet) {
        switch (initialSet) {
            case EMPTY: {
                break;
            }
            case DEFAULT: {
                this.propertyMap.putAll(defaultProperties);
            }
        }
    }

    public FigureProperties(HashMap<AttributeKey, Object> initialSet) {
        this.addAttribute(initialSet);
    }

    public void setAttributes(Figure fig) {
        for (AttributeKey key : this.propertyMap.keySet()) {
            key.set(fig, this.propertyMap.get(key));
        }
    }

    public void addAttribute(HashMap<AttributeKey, Object> attributeSet) {
        for (AttributeKey key : attributeSet.keySet()) {
            this.addAttribute(key, attributeSet.get(key));
        }
    }

    public void addAttribute(AttributeKey key, Object defaultValue) {
        this.propertyMap.put(key, defaultValue);
    }

    public void setPropertyValue(AttributeKey key, Object value) {
        this.propertyMap.put(key, value);
    }

    public Object getPropertyValue(AttributeKey key) {
        return this.propertyMap.get(key);
    }

    public boolean hasProperty(AttributeKey key) {
        return this.propertyMap.containsKey(key);
    }

    public void removeAttributes(AttributeKey key) {
        if (this.hasProperty(key)) {
            this.propertyMap.remove(key);
        }
    }

    public HashMap<AttributeKey, Object> getProperties() {
        return this.propertyMap;
    }

    static {
        defaultProperties.put(DrawingAttributes.FILL_COLOR, IOConstants.DEFAULT_FILL_COLOUR);
        defaultProperties.put(DrawingAttributes.STROKE_COLOR, IOConstants.DEFAULT_STROKE_COLOUR);
        defaultProperties.put(DrawingAttributes.STROKE_WIDTH, 1.0);
        defaultProperties.put(DrawingAttributes.TEXT, "Text");
        defaultProperties.put(DrawingAttributes.TEXT_COLOR, IOConstants.DEFAULT_TEXT_COLOUR);
        defaultProperties.put(DrawingAttributes.FONT_SIZE, 12.0);
        defaultProperties.put(DrawingAttributes.SHOWTEXT, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeSet {
        EMPTY,
        DEFAULT;

    }
}

