/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.clsf;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckModel;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckRenderer;

public class TreeCheck
extends JTree {
    public static final String NODE_SELECTED_PROPERTY = "nodeSelected";
    private boolean singleSelectionInParent;

    private void fireNodeSelection() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Enumeration<TreeNode> nodes = root.breadthFirstEnumeration();
        int index = 0;
        while (nodes.hasMoreElements()) {
            TreeCheckNode node = (TreeCheckNode)nodes.nextElement();
            if (!node.isSelected()) continue;
            ++index;
        }
        this.firePropertyChange(NODE_SELECTED_PROPERTY, new Integer(-1), new Integer(index));
    }

    private void handleSingleSelection(TreeCheckNode node) {
        TreeCheckNode parent = node.getParentDisplay();
        if (parent == null) {
            return;
        }
        if (node.isSelected()) {
            return;
        }
        Set nodes = parent.getChildrenDisplay();
        for (TreeCheckNode child : nodes) {
            child.setSelected(child.equals(node));
        }
        this.fireNodeSelection();
    }

    private void initialize(TreeCheckNode root, boolean leafOnly) {
        this.setCellRenderer(new TreeCheckRenderer(leafOnly));
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        super.setModel(new TreeCheckModel(root));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                int row = TreeCheck.this.getRowForLocation(me.getX(), me.getY());
                TreePath path = TreeCheck.this.getPathForRow(row);
                if (path == null) {
                    return;
                }
                Object o = path.getLastPathComponent();
                if (!(o instanceof TreeCheckNode)) {
                    return;
                }
                TreeCheckNode node = (TreeCheckNode)o;
                if (TreeCheck.this.singleSelectionInParent) {
                    TreeCheck.this.handleSingleSelection(node);
                } else {
                    node.setSelected(!node.isSelected());
                    TreeCheck.this.fireNodeSelection();
                }
                ((DefaultTreeModel)TreeCheck.this.getModel()).nodeChanged(node);
                if (row == 0) {
                    TreeCheck.this.revalidate();
                    TreeCheck.this.repaint();
                }
            }
        });
    }

    public TreeCheck(Object rootObject, Icon rootIcon) {
        this.initialize(new TreeCheckNode(rootObject, rootIcon), true);
    }

    public TreeCheck(TreeCheckNode root) {
        this.initialize(root, true);
    }

    public TreeCheck(Object rootObject, Icon rootIcon, boolean leafOnly) {
        this.initialize(new TreeCheckNode(rootObject, rootIcon), leafOnly);
    }

    public void setSingleSelectionInParent(boolean b) {
        this.singleSelectionInParent = b;
        TreeCheckRenderer rnd = (TreeCheckRenderer)this.getCellRenderer();
        if (this.singleSelectionInParent) {
            rnd.initToggleButton(JRadioButton.class);
        } else {
            rnd.initToggleButton(JCheckBox.class);
        }
    }

    public boolean isSingleSelectionInParent() {
        return this.singleSelectionInParent;
    }

    public Set getSelectedNodes() {
        HashSet<TreeCheckNode> set = new HashSet<TreeCheckNode>();
        DefaultTreeModel dtm = (DefaultTreeModel)this.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Enumeration<TreeNode> nodes = root.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            TreeCheckNode node = (TreeCheckNode)nodes.nextElement();
            if (!node.isSelected()) continue;
            set.add(node);
        }
        return Collections.unmodifiableSet(set);
    }

    public void selectAllNodes() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Enumeration<TreeNode> nodes = root.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            TreeCheckNode node = (TreeCheckNode)nodes.nextElement();
            node.setSelected(true);
        }
        this.fireNodeSelection();
        this.repaint();
    }

    public void deselectAllNodes() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Enumeration<TreeNode> nodes = root.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            TreeCheckNode node = (TreeCheckNode)nodes.nextElement();
            node.setSelected(false);
        }
        this.fireNodeSelection();
        this.repaint();
    }

    public void setModel(TreeModel newModel) {
    }

    static /* synthetic */ boolean access$000(TreeCheck x0) {
        return x0.singleSelectionInParent;
    }

    static /* synthetic */ void access$100(TreeCheck x0, TreeCheckNode x1) {
        x0.handleSingleSelection(x1);
    }

    static /* synthetic */ void access$200(TreeCheck x0) {
        x0.fireNodeSelection();
    }
}

