/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TitlePanel
extends JXHeader {
    private static final Color BG_COLOR = UIUtilities.SELECTED_BACKGROUND_COLOUR.darker();

    public TitlePanel(String title, String subTitle, String text, Icon icon) {
        super.setTitle(title);
        String s = subTitle;
        if (text != null) {
            s = s + "\n " + text;
        }
        this.setDescription(s);
        this.setIcon(icon);
        Color translucent = new Color(BG_COLOR.getRed(), BG_COLOR.getGreen(), BG_COLOR.getBlue(), 0);
        this.setForeground(Color.LIGHT_GRAY);
        GradientPaint bgToTranslucent = new GradientPaint(new Point2D.Double(0.4, 0.0), BG_COLOR, new Point2D.Double(1.0, 0.0), translucent);
        MattePainter veil = new MattePainter((Paint)bgToTranslucent);
        veil.setPaintStretched(true);
        RectanglePainter backgroundPainter = new RectanglePainter(Color.white, null);
        CompoundPainter p = new CompoundPainter(new Painter[]{backgroundPainter, veil, new GlossPainter()});
        this.setBackgroundPainter((Painter)p);
    }

    public TitlePanel(String title, String subTitle, Icon icon) {
        this(title, subTitle, null, icon);
    }

    public void setTitle(String text) {
        super.setTitle(text);
        this.repaint();
    }

    public void setTextHeader(String text) {
        super.setDescription(text);
        this.repaint();
    }

    public void setSubtitle(String text) {
        String s = super.getDescription();
        if (text != null) {
            s = s + "\n " + text;
        }
        this.setTextHeader(s);
    }
}

