/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.RatingCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatingComponent
extends JPanel {
    public static final int HIGH_SIZE = 0;
    public static final int MEDIUM_SIZE = 1;
    public static final int SMALL_SIZE = 2;
    public static final String RATE_PROPERTY = "rate";
    public static final int MAX_VALUE = 5;
    public static final int MIN_VALUE = 0;
    private List<Image> plus;
    private List<Image> minus;
    private int currentValue;
    private Image selected;
    private Image unselected;
    private RatingCanvas canvas;
    private int size;

    private void fillLists() {
        int i;
        this.plus.clear();
        this.minus.clear();
        int n = 5 - this.currentValue;
        for (i = 0; i < n; ++i) {
            this.minus.add(this.unselected);
        }
        for (i = 0; i < this.currentValue; ++i) {
            this.plus.add(this.selected);
        }
    }

    private void initialize() {
        this.canvas = new RatingCanvas(this);
        this.plus = new ArrayList<Image>();
        this.minus = new ArrayList<Image>();
        IconManager icons = IconManager.getInstance();
        switch (this.size) {
            case 0: {
                this.selected = icons.getImageIcon(81).getImage();
                this.unselected = icons.getImageIcon(82).getImage();
                break;
            }
            case 1: {
                this.selected = icons.getImageIcon(90).getImage();
                this.unselected = icons.getImageIcon(91).getImage();
                break;
            }
            case 2: {
                this.selected = icons.getImageIcon(92).getImage();
                this.unselected = icons.getImageIcon(93).getImage();
            }
        }
        int w = this.selected.getWidth(null);
        int h = this.selected.getHeight(null);
        this.canvas.setPreferredSize(new Dimension(w * 5 + 8, h + 4));
        this.fillLists();
    }

    private void buildGUI(boolean hasListeners) {
        this.setBorder(null);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.canvas);
        if (!hasListeners) {
            this.canvas.uninstallListeners();
        }
    }

    public RatingComponent() {
        this(0, 0, true);
    }

    public RatingComponent(int size) {
        this(0, size, true);
    }

    public RatingComponent(int selected, int size) {
        this(selected, size, true);
    }

    public RatingComponent(int size, boolean hasListeners) {
        this(0, size, hasListeners);
    }

    public RatingComponent(int selected, int size, boolean hasListeners) {
        if (selected < 0) {
            selected = 0;
        }
        if (selected > 5) {
            selected = 5;
        }
        switch (size) {
            case 0: 
            case 1: 
            case 2: {
                this.size = size;
                break;
            }
            default: {
                this.size = 2;
            }
        }
        this.currentValue = selected;
        this.initialize();
        this.buildGUI(hasListeners);
    }

    List<Image> getPlus() {
        return this.plus;
    }

    List<Image> getMinus() {
        return this.minus;
    }

    public void setValue(int value) {
        if (value < 0 || value > 5) {
            return;
        }
        int oldValue = this.currentValue;
        this.currentValue = value;
        this.fillLists();
        this.canvas.repaint();
        this.firePropertyChange(RATE_PROPERTY, oldValue, this.currentValue);
    }

    public int getCurrentValue() {
        if (this.currentValue < 0) {
            return 0;
        }
        if (this.currentValue > 5) {
            return 5;
        }
        return this.currentValue;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.canvas != null) {
            this.canvas.setBackground(bg);
        }
    }
}

