/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;

public class NumericalTextField
extends JTextField
implements DocumentListener,
FocusListener {
    private static final String NUMERIC = "0123456789";
    private static final String FLOAT = "0123456789.";
    private Color editedColor;
    private Color defaultForeground;
    private NumericalPlainDocument document;
    private String originalText;
    private Class numberType;
    private boolean negativeAccepted;
    private String accepted;

    private void updateForeGround() {
        String text = this.getText();
        if (this.editedColor != null && this.originalText != null) {
            if (this.originalText.equals(text)) {
                this.setForeground(this.defaultForeground);
            } else {
                this.setForeground(this.editedColor);
            }
        }
        if (this.originalText == null) {
            this.originalText = text;
            this.defaultForeground = this.getForeground();
        }
    }

    public NumericalTextField() {
        this(0.0, Double.MAX_VALUE);
    }

    public NumericalTextField(double min, double max) {
        this.document = new NumericalPlainDocument(min, max);
        this.setDocument(this.document);
        this.originalText = null;
        this.editedColor = null;
        this.document.addDocumentListener(this);
        this.addFocusListener(this);
        this.numberType = Integer.class;
        this.accepted = NUMERIC;
        this.negativeAccepted = false;
    }

    public void setNegativeAccepted(boolean negativeAccepted) {
        this.negativeAccepted = negativeAccepted;
        if (negativeAccepted) {
            this.accepted = this.accepted + "-";
        }
    }

    public void setNumberType(Class numberType) {
        if (numberType == null) {
            numberType = Integer.class;
        }
        this.numberType = numberType;
        this.accepted = numberType.equals(Integer.class) ? NUMERIC : FLOAT;
        this.setNegativeAccepted(this.negativeAccepted);
    }

    public void setMinimum(double min) {
        this.document.setMinimum(min);
    }

    public void setMaximum(double max) {
        this.document.setMaximum(max);
    }

    public void setEditedColor(Color editedColor) {
        this.editedColor = editedColor;
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateForeGround();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateForeGround();
    }

    public void focusLost(FocusEvent e) {
        String s = this.getText();
        if (s != null && s.endsWith(".")) {
            s = s + "0";
            this.setText(s);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    static /* synthetic */ Class access$000(NumericalTextField x0) {
        return x0.numberType;
    }

    static /* synthetic */ String access$100(NumericalTextField x0) {
        return x0.accepted;
    }

    static /* synthetic */ boolean access$200(NumericalTextField x0) {
        return x0.negativeAccepted;
    }

    class NumericalPlainDocument
    extends PlainDocument {
        private double min;
        private double max;

        private boolean isInRange(String str) {
            try {
                double val;
                if (Integer.class.equals((Object)NumericalTextField.this.numberType)) {
                    int val2 = Integer.parseInt(str);
                    int m = (int)this.min;
                    int mx = (int)this.max;
                    if (m <= val2 && val2 <= mx) {
                        return true;
                    }
                } else if (Double.class.equals((Object)NumericalTextField.this.numberType) ? this.min <= (val = Double.parseDouble(str)) && val <= this.max : Float.class.equals((Object)NumericalTextField.this.numberType) && this.min <= (double)(val = Float.parseFloat(str)) && (double)val <= this.max) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return false;
        }

        NumericalPlainDocument(double min, double max) {
            this.min = min;
            this.max = max;
        }

        void setMinimum(double min) {
            this.min = min;
        }

        void setMaximum(double max) {
            this.max = max;
        }

        public void insertString(int offset, String str, AttributeSet a) {
            try {
                if (str == null) {
                    return;
                }
                for (int i = 0; i < str.length(); ++i) {
                    if (NumericalTextField.this.accepted.indexOf(String.valueOf(str.charAt(i))) != -1) continue;
                    return;
                }
                if ((NumericalTextField.this.accepted.equals(NumericalTextField.FLOAT) || NumericalTextField.this.accepted.equals("0123456789.-") && NumericalTextField.this.negativeAccepted) && str.indexOf(".") != -1 && this.getText(0, this.getLength()).indexOf(".") != -1) {
                    return;
                }
                if (NumericalTextField.this.negativeAccepted && str.indexOf("-") != -1 && (str.indexOf("-") != 0 || offset != 0)) {
                    return;
                }
                if (str.equals(".") && NumericalTextField.this.accepted.equals(NumericalTextField.FLOAT)) {
                    super.insertString(offset, str, a);
                } else if (str.equals("-") && NumericalTextField.this.negativeAccepted) {
                    super.insertString(offset, str, a);
                } else {
                    String s = this.getText(0, this.getLength());
                    if (this.isInRange(s = s + str)) {
                        super.insertString(offset, str, a);
                    }
                }
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

