/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class NotificationDialog
extends JDialog {
    protected static final Dimension MSG_AREA_SIZE = new Dimension(300, 50);
    protected static final Dimension H_SPACER_SIZE = new Dimension(20, 1);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    protected JXHeader contentPanel;
    protected JPanel messagePanel;
    protected JPanel controlsPanel;
    protected JButton okButton;
    private JPanel mainPanel;

    private void createComponents() {
        this.mainPanel = new JPanel();
        this.contentPanel = new JXHeader();
        this.messagePanel = new JPanel();
        this.messagePanel.setOpaque(true);
        this.controlsPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                NotificationDialog.this.close();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotificationDialog.this.close();
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel buildCommentPanel(String msg, Icon icon) {
        this.contentPanel.setBackgroundPainter((Painter)new RectanglePainter(UIUtilities.WINDOW_BACKGROUND_COLOR, null));
        this.contentPanel.setDescription(msg);
        this.contentPanel.setIcon(icon);
        this.contentPanel.setIconPosition(JXHeader.IconPosition.LEFT);
        return this.contentPanel;
    }

    private JPanel buildControlPanel() {
        this.controlsPanel.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        this.controlsPanel.setBorder(null);
        this.controlsPanel.add(this.okButton);
        this.controlsPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        JPanel p = UIUtilities.buildComponentPanelRight(this.controlsPanel);
        p.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        return p;
    }

    private void buildGUI(String message, Icon messageIcon) {
        this.mainPanel.setBackground(UIUtilities.WINDOW_BACKGROUND_COLOR);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridy = 0;
        this.mainPanel.add((Component)this.buildCommentPanel(message, messageIcon), c);
        ++c.gridy;
        this.mainPanel.add(Box.createVerticalStrut(5), c);
        ++c.gridy;
        this.mainPanel.add((Component)this.buildControlPanel(), c);
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private void initiliaze(String message, Icon messageIcon) {
        this.createComponents();
        this.attachListeners();
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.buildGUI(message, messageIcon);
        this.pack();
    }

    public NotificationDialog(JFrame owner, String title, String message, Icon messageIcon) {
        super((Frame)owner, title);
        this.initiliaze(message, messageIcon);
    }

    public NotificationDialog(JDialog owner, String title, String message, Icon messageIcon) {
        super((Dialog)owner, title);
        this.initiliaze(message, messageIcon);
    }

    public NotificationDialog(String title, String message, Icon messageIcon) {
        this.setTitle(title);
        this.initiliaze(message, messageIcon);
    }

    static /* synthetic */ void access$000(NotificationDialog x0) {
        x0.close();
    }
}

