/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class LoadingWindow
extends JDialog {
    public static final String CLOSED_PROPERTY = "closed";
    public static final String LOADING_TXT = "Loaded: ";
    private static final String TITLE = "Loading window";
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 60);
    private JLabel status;
    private JProgressBar progressBar;

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.status = new JLabel("Loading...");
        this.progressBar.setIndeterminate(true);
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.status);
        p.add(UIUtilities.buildComponentPanelRight(this.progressBar));
        this.getContentPane().add(p);
    }

    private void attachWindowListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (LoadingWindow.this.isVisible()) {
                    LoadingWindow.this.firePropertyChange(LoadingWindow.CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                }
            }
        });
    }

    private void setWindowProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    public LoadingWindow(JFrame owner) {
        super(owner);
        this.setWindowProperties();
        this.initComponents();
        this.buildGUI();
        this.attachWindowListeners();
        this.setSize(DEFAULT_SIZE);
        this.setVisible(false);
    }

    public void setStatus(String s) {
        this.status.setText(s);
    }

    public void setProgress(int perc) {
        if (perc < 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setValue(perc);
        }
    }

    static /* synthetic */ void access$000(LoadingWindow x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }
}

