/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColourIcon
implements Icon {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    private Color colour;
    private int height;
    private int width;

    public ColourIcon() {
        this(16, 16);
    }

    public ColourIcon(Dimension d) {
        if (d == null) {
            this.width = 16;
            this.height = 16;
        } else {
            this.width = d.width;
            this.height = d.height;
        }
    }

    public ColourIcon(int width, int height) {
        if (width <= 0) {
            width = 16;
        }
        if (height <= 0) {
            height = 16;
        }
        this.width = width;
        this.height = height;
    }

    public ColourIcon(int width, int height, Color color) {
        if (width <= 0) {
            width = 16;
        }
        if (height <= 0) {
            height = 16;
        }
        this.width = width;
        this.height = height;
        this.setColour(color);
    }

    public ColourIcon(Dimension d, Color color) {
        if (d == null) {
            this.width = 16;
            this.height = 16;
        } else {
            this.width = d.width;
            this.height = d.height;
        }
        this.setColour(color);
    }

    public void setColour(Color c) {
        this.colour = c;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.colour != null) {
            g2D.setColor(this.colour);
            g2D.fillRect(4, 4, this.width - 3, this.height - 3);
            g2D.setColor(this.colour.darker());
            g2D.drawRect(4, 4, this.width - 3, this.height - 3);
        }
    }
}

