/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.figures.EllipseTextFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureEllipseFigure
extends EllipseTextFigure
implements ROIFigure {
    private Rectangle2D measurementBounds;
    protected ROI roi;
    protected ROIShape shape;
    private MeasurementUnits units;
    private int status;

    public MeasureEllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public MeasureEllipseFigure(String text, double x, double y, double width, double height) {
        super(text, x, y, width, height);
        this.setAttributeEnabled(MeasurementAttributes.TEXT_COLOR, true);
        this.shape = null;
        this.roi = null;
        this.status = 0;
    }

    public MeasureEllipseFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0);
    }

    public MeasureEllipseFigure(double x, double y, double width, double height) {
        this("Text", x, y, width, height);
    }

    public double getMeasurementX() {
        if (this.units.isInMicrons()) {
            return this.getX() * this.units.getMicronsPixelX();
        }
        return this.getX();
    }

    public double getMeasurementY() {
        if (this.units.isInMicrons()) {
            return this.getY() * this.units.getMicronsPixelY();
        }
        return this.getY();
    }

    public double getMeasurementWidth() {
        if (this.units.isInMicrons()) {
            return this.getWidth() * this.units.getMicronsPixelX();
        }
        return this.getWidth();
    }

    public double getMeasurementHeight() {
        if (this.units.isInMicrons()) {
            return this.getHeight() * this.units.getMicronsPixelY();
        }
        return this.getHeight();
    }

    public Point2D getMeasurementCentre() {
        if (this.units.isInMicrons()) {
            return new Point2D.Double(this.getCentre().getX() * this.units.getMicronsPixelX(), this.getCentre().getY() * this.units.getMicronsPixelY());
        }
        return this.getCentre();
    }

    public double getX() {
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)this);
        if (t == null) {
            return this.ellipse.getX();
        }
        Point2D.Double src = new Point2D.Double(this.ellipse.getX(), this.ellipse.getY());
        Point2D.Double dest = new Point2D.Double();
        t.transform(src, dest);
        return ((Point2D)dest).getX();
    }

    public double getY() {
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)this);
        if (t == null) {
            return this.ellipse.getY();
        }
        Point2D.Double src = new Point2D.Double(this.ellipse.getX(), this.ellipse.getY());
        Point2D.Double dest = new Point2D.Double();
        t.transform(src, dest);
        return ((Point2D)dest).getY();
    }

    @Override
    public double getWidth() {
        return super.getWidth();
    }

    @Override
    public double getHeight() {
        return super.getHeight();
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue() || ((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
            DecimalFormat formatter = new DecimalFormat("###.#");
            String ellipseArea = formatter.format(this.getArea());
            ellipseArea = this.addUnits(ellipseArea);
            double sz = (Double)this.getAttribute(MeasurementAttributes.FONT_SIZE);
            g.setFont(new Font("Arial", 0, (int)sz));
            Rectangle2D stringBoundsbounds = g.getFontMetrics().getStringBounds(ellipseArea, g);
            this.measurementBounds = new Rectangle2D.Double(this.getCentreX() - stringBoundsbounds.getWidth() / 2.0, this.getCentreY() + stringBoundsbounds.getHeight() / 2.0, stringBoundsbounds.getWidth(), stringBoundsbounds.getHeight());
            if (((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get((Figure)this)).booleanValue()) {
                g.setColor((Color)MeasurementAttributes.MEASUREMENTTEXT_COLOUR.get((Figure)this));
                g.drawString(ellipseArea, (int)this.measurementBounds.getX(), (int)this.measurementBounds.getY());
            }
            if (((Boolean)MeasurementAttributes.SHOWID.get((Figure)this)).booleanValue()) {
                g.setColor(this.getTextColor());
                this.measurementBounds = g.getFontMetrics().getStringBounds(this.getROI().getID() + "", g);
                this.measurementBounds = new Rectangle2D.Double(this.getBounds().getCenterX() - this.measurementBounds.getWidth() / 2.0, this.getBounds().getCenterY() + this.measurementBounds.getHeight() / 2.0, this.measurementBounds.getWidth(), this.measurementBounds.getHeight());
                g.drawString(this.getROI().getID() + "", (int)this.measurementBounds.getX(), (int)this.measurementBounds.getY());
            }
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double newBounds = super.getDrawingArea();
        if (this.measurementBounds != null) {
            double diff;
            if (newBounds.getX() > this.measurementBounds.getX()) {
                diff = newBounds.x - this.measurementBounds.getX();
                newBounds.x = this.measurementBounds.getX();
                newBounds.width += diff;
            }
            if (newBounds.getY() > this.measurementBounds.getY()) {
                diff = newBounds.y - this.measurementBounds.getY();
                newBounds.y = this.measurementBounds.getY();
                newBounds.height += diff;
            }
            if (this.measurementBounds.getX() + this.measurementBounds.getWidth() > newBounds.getX() + newBounds.getWidth()) {
                diff = this.measurementBounds.getX() + this.measurementBounds.getWidth() - newBounds.getX() + newBounds.getWidth();
                newBounds.width += diff;
            }
            if (this.measurementBounds.getY() + this.measurementBounds.getHeight() > newBounds.getY() + newBounds.getHeight()) {
                diff = this.measurementBounds.getY() + this.measurementBounds.getHeight() - newBounds.getY() + newBounds.getHeight();
                newBounds.height += diff;
            }
        }
        return newBounds;
    }

    public String addUnits(String str) {
        if (this.shape == null) {
            return str;
        }
        if (this.units.isInMicrons()) {
            return str + "\u00b5m" + "\u00b2";
        }
        return str + "px" + "\u00b2";
    }

    public double getArea() {
        return this.getMeasurementHeight() / 2.0 * (this.getMeasurementWidth() / 2.0) * Math.PI;
    }

    public double getPerimeter() {
        if (this.getMeasurementWidth() == this.getMeasurementHeight()) {
            return this.getMeasurementWidth() * 2.0 * Math.PI;
        }
        double a = Math.max(this.getMeasurementWidth(), this.getMeasurementHeight());
        double b = Math.min(this.getMeasurementWidth(), this.getMeasurementHeight());
        return Math.PI * (3.0 * a + 3.0 * b - Math.sqrt((a + 3.0 * b) * (b + 3.0 * a)));
    }

    public Point2D getCentre() {
        return new Point2D.Double(Math.round(this.getCentreX()), Math.round(this.getCentreY()));
    }

    @Override
    public ROI getROI() {
        return this.roi;
    }

    @Override
    public ROIShape getROIShape() {
        return this.shape;
    }

    @Override
    public void setROI(ROI roi) {
        this.roi = roi;
    }

    @Override
    public void setROIShape(ROIShape shape) {
        this.shape = shape;
    }

    @Override
    public void calculateMeasurements() {
        if (this.shape == null) {
            return;
        }
        AnnotationKeys.AREA.set(this.shape, (Double)this.getArea());
        AnnotationKeys.HEIGHT.set(this.shape, (Double)this.getMeasurementHeight());
        AnnotationKeys.WIDTH.set(this.shape, (Double)this.getMeasurementWidth());
        AnnotationKeys.PERIMETER.set(this.shape, (Double)this.getPerimeter());
        AnnotationKeys.CENTREX.set(this.shape, (Double)this.getMeasurementCentre().getX());
        AnnotationKeys.CENTREY.set(this.shape, (Double)this.getMeasurementCentre().getY());
    }

    @Override
    public String getType() {
        return "Ellipse";
    }

    @Override
    public void setMeasurementUnits(MeasurementUnits units) {
        this.units = units;
    }

    @Override
    public List<Point> getPoints() {
        double startY;
        Shape transformedEllipse = this.getTransformedShape();
        Rectangle2D r = transformedEllipse.getBounds2D();
        ArrayList<Point> vector = new ArrayList<Point>((int)r.getHeight() * (int)r.getWidth());
        double xEnd = r.getX() + r.getWidth();
        double yEnd = r.getY() + r.getHeight();
        double startX = r.getX();
        for (double y = startY = r.getY(); y < yEnd; y += 1.0) {
            for (double x = startX; x < xEnd; x += 1.0) {
                if (!transformedEllipse.intersects(x, y, 0.001, 0.001)) continue;
                vector.add(new Point((int)x, (int)y));
            }
        }
        return vector;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }
}

