/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.geom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RescaleOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.util.ui.IconManager;
import sun.awt.image.IntegerInterleavedRaster;

public class Factory {
    public static final int THUMB_DEFAULT_WIDTH = 96;
    public static final int THUMB_DEFAULT_HEIGHT = 96;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    public static final int BLANK_MASK = 0;
    public static final int LOC_TOP_LEFT = 0;
    public static final int LOC_TOP_RIGHT = 1;
    public static final int LOC_BOTTOM_LEFT = 2;
    public static final int LOC_BOTTOM_RIGHT = 3;
    public static final int DEFAULT_THUMB = 96;
    private static final int BORDER = 2;
    private static final String DEFAULT_TEXT = "No thumbnail";
    private static final String LOADING_TEXT = "Loading...";
    public static final int[] RGB = new int[]{0xFF0000, 65280, 255};
    public static final float[] SHARPEN = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public static final float[] LOW_PASS = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};

    public static BufferedImage createDefaultImageThumbnail(int width, int height) {
        IconManager icons = IconManager.getInstance();
        ImageIcon img = icons.getImageIcon(83);
        if (img == null) {
            return Factory.createDefaultImageThumbnail();
        }
        int h = img.getIconHeight();
        int w = img.getIconWidth();
        if (width == 0) {
            width = 96;
        }
        if (height == 0) {
            height = 96;
        }
        if (h == height && w == width) {
            return Factory.createDefaultImageThumbnail();
        }
        BufferedImage thumbPix = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)thumbPix.getGraphics();
        g.drawImage(img.getImage(), 0, 0, width, height, null);
        return thumbPix;
    }

    public static BufferedImage createDefaultImageThumbnail() {
        IconManager icons = IconManager.getInstance();
        ImageIcon img = icons.getImageIcon(83);
        if (img == null) {
            return Factory.createDefaultImageThumbnail();
        }
        int h = img.getIconHeight();
        int w = img.getIconWidth();
        BufferedImage thumbPix = new BufferedImage(w, h, 1);
        Graphics2D g = (Graphics2D)thumbPix.getGraphics();
        g.drawImage(img.getImage(), 0, 0, null);
        return thumbPix;
    }

    public static BufferedImage createDefaultThumbnail(int sizeX, int sizeY, String text) {
        BufferedImage thumbPix = new BufferedImage(sizeX, sizeY, 1);
        Graphics2D g = (Graphics2D)thumbPix.getGraphics();
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, sizeX, sizeY);
        if (text != null && text.trim().length() != 0) {
            FontMetrics fontMetrics = g.getFontMetrics();
            int xTxt = 2;
            int yTxt = sizeY / 2 - fontMetrics.getHeight();
            g.setColor(Color.WHITE);
            g.setFont(g.getFont().deriveFont(1));
            g.drawString(text, xTxt, yTxt);
        }
        return thumbPix;
    }

    public static BufferedImage createDefaultThumbnail(String text) {
        return Factory.createDefaultThumbnail(96, 96, text);
    }

    public static BufferedImage createDefaultThumbnail() {
        return Factory.createDefaultThumbnail(96, 96, LOADING_TEXT);
    }

    public static BufferedImage createDefaultThumbnail(int sizeX, int sizeY) {
        return Factory.createDefaultThumbnail(sizeX, sizeY, DEFAULT_TEXT);
    }

    public static BufferedImage magnifyImage(BufferedImage img, double level, int w) {
        if (img == null) {
            return null;
        }
        AffineTransform a = new AffineTransform();
        a.scale(level, level);
        AffineTransformOp biop = new AffineTransformOp(a, 2);
        int width = (int)((double)img.getWidth() * level) + w;
        int height = (int)((double)img.getHeight() * level) + w;
        if (width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage rescaleBuff = new BufferedImage(width, height, 1);
        BufferedImage bimg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        RescaleOp rop = new RescaleOp(1.0f, 0.0f, null);
        rop.filter(img, bimg);
        Graphics2D g = rescaleBuff.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(bimg, biop, 0, 0);
        g.dispose();
        bimg.flush();
        rescaleBuff.flush();
        System.gc();
        return rescaleBuff;
    }

    public static BufferedImage magnifyImage(double f, BufferedImage img) {
        if (img == null) {
            return null;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        AffineTransform at = new AffineTransform();
        at.scale(f, f);
        AffineTransformOp biop = new AffineTransformOp(at, 2);
        int type = img.getType();
        if (type == 0) {
            type = 1;
        }
        int scaleWidth = (int)((double)width * f);
        int scaleHeight = (int)((double)height * f);
        if (scaleWidth <= 0 || scaleHeight <= 0) {
            return null;
        }
        BufferedImage rescaleBuff = img;
        rescaleBuff = new BufferedImage(scaleWidth, scaleHeight, type);
        biop.filter(img, rescaleBuff);
        rescaleBuff.flush();
        System.gc();
        return rescaleBuff;
    }

    public static BufferedImage convolveImage(BufferedImage img, float[] filter) {
        if (img == null) {
            return null;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage bimg = new BufferedImage(width, height, 1);
        RescaleOp rop = new RescaleOp(1.0f, 0.0f, null);
        rop.filter(img, bimg);
        Kernel kernel = new Kernel(3, 3, filter);
        ConvolveOp cop = new ConvolveOp(kernel, 1, null);
        BufferedImage finalImg = new BufferedImage(width, height, 1);
        cop.filter(bimg, finalImg);
        return finalImg;
    }

    public static BufferedImage createImageWithText(BufferedImage img, String text, int indexLocation, Color c) {
        if (img == null) {
            return null;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 1);
        Graphics2D g2 = (Graphics2D)newImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.drawImage(img, null, 0, 0);
        FontMetrics fontMetrics = g2.getFontMetrics();
        int charWidth = fontMetrics.charWidth('m');
        int hFont = fontMetrics.getHeight();
        int length = text.length() * charWidth;
        int xTxt = 0;
        int yTxt = 0;
        switch (indexLocation) {
            case 0: {
                xTxt = 2;
                yTxt = 2 + hFont;
                break;
            }
            case 1: {
                xTxt = w - 2 - length;
                yTxt = 2 + hFont;
                break;
            }
            case 2: {
                xTxt = 2;
                yTxt = h - 2 - hFont;
                break;
            }
            case 3: {
                xTxt = w - 2 - length;
                yTxt = h - 2 - hFont;
            }
        }
        if (c != null) {
            g2.setColor(c);
            g2.setFont(g2.getFont().deriveFont(1));
            g2.drawString(text, xTxt, yTxt);
        }
        return newImage;
    }

    public static BufferedImage createImage(BufferedImage img) {
        if (img == null) {
            return null;
        }
        int sizeY = img.getWidth();
        int sizeX = img.getHeight();
        DataBufferByte buffer = new DataBufferByte(sizeX * sizeY, 3);
        DataBuffer dataBuf = img.getRaster().getDataBuffer();
        ColorModel cm = img.getColorModel();
        int pos = 0;
        int v = 0;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                pos = sizeX * y + x;
                v = dataBuf.getElem(0, pos);
                buffer.setElem(0, pos, cm.getRed(v));
                buffer.setElem(1, pos, cm.getGreen(v));
                buffer.setElem(2, pos, cm.getBlue(v));
            }
        }
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, 0);
        BandedSampleModel csm = new BandedSampleModel(0, sizeX, sizeY, 3);
        return new BufferedImage(ccm, Raster.createWritableRaster(csm, buffer, null), false, null);
    }

    public static BufferedImage createImage(Image img) {
        if (img == null) {
            return null;
        }
        BufferedImage buff = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D gfx = buff.createGraphics();
        gfx.drawImage(img, 0, 0, null);
        gfx.dispose();
        return buff;
    }

    public static BufferedImage copyBufferedImage(BufferedImage img) {
        if (img == null) {
            return null;
        }
        BufferedImage buff = new BufferedImage(img.getWidth(null), img.getHeight(null), img.getType());
        Graphics2D gfx = buff.createGraphics();
        gfx.drawImage((Image)img, 0, 0, null);
        gfx.dispose();
        return buff;
    }

    public static BufferedImage createImage(DataBuffer buf, int bits, int sizeX, int sizeY) {
        return Factory.createImage(buf, bits, RGB, sizeX, sizeY);
    }

    public static BufferedImage createImage(DataBuffer buf, int bits, int[] masks, int sizeX, int sizeY) {
        if (buf instanceof DataBufferInt) {
            DataBufferInt j2DBuf = (DataBufferInt)buf;
            SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, sizeX, sizeY, sizeX, masks);
            IntegerInterleavedRaster raster = new IntegerInterleavedRaster((SampleModel)sampleModel, (DataBuffer)j2DBuf, new Point(0, 0));
            DirectColorModel colorModel = new DirectColorModel(bits, masks[0], masks[1], masks[2]);
            return new BufferedImage(colorModel, raster, false, null);
        }
        return null;
    }

    public static BufferedImage createImage(int[] buf, int bits, int sizeX, int sizeY) {
        if (buf == null) {
            return null;
        }
        DataBufferInt j2DBuf = new DataBufferInt(buf, sizeX * sizeY);
        return Factory.createImage(j2DBuf, bits, sizeX, sizeY);
    }

    public static BufferedImage createImage(int[] buf, int bits, int[] masks, int sizeX, int sizeY) {
        if (buf == null) {
            return null;
        }
        DataBufferInt j2DBuf = new DataBufferInt(buf, sizeX * sizeY);
        return Factory.createImage(j2DBuf, bits, masks, sizeX, sizeY);
    }

    public static Dimension computeThumbnailSize(int sizeX, int sizeY, double realSizeX, double realSizeY) {
        double ratio = 0.0;
        int value = 0;
        if (realSizeY != 0.0) {
            ratio = realSizeX / realSizeY;
        }
        if (sizeX <= 0 && sizeY <= 0) {
            return new Dimension(96, 96);
        }
        if (sizeX <= 0 && sizeY > 0) {
            return new Dimension(96, sizeY);
        }
        if (sizeX > 0 && sizeY <= 0) {
            return new Dimension(sizeX, 96);
        }
        if (ratio < 1.0) {
            value = (int)((double)sizeX * ratio);
            if (value != 0) {
                return new Dimension(value, sizeY);
            }
            return new Dimension(96, sizeY);
        }
        if (ratio > 1.0 && ratio != 0.0) {
            value = (int)((double)(sizeY * 1) / ratio);
            if (value != 0) {
                return new Dimension(sizeX, value);
            }
            return new Dimension(sizeX, 96);
        }
        return new Dimension(sizeX, sizeY);
    }
}

