/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class HTMLFilter
extends CustomizedFileFilter {
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String[] extensions = new String[2];
    private static final String description;

    public String getExtension() {
        return HTML;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        HTMLFilter.extensions[0] = HTML;
        HTMLFilter.extensions[1] = HTM;
        String s = "HTML (";
        for (int i = 0; i < extensions.length; ++i) {
            s = s + "*." + extensions[i];
            if (i >= extensions.length - 1) continue;
            s = s + ", ";
        }
        description = s = s + ")";
    }
}

