/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static InputStream readFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        File f = new File(fileName);
        FileInputStream input = null;
        try {
            input = new FileInputStream(f);
            return new BufferedInputStream(input);
        }
        catch (Exception e) {
            if (input != null) {
                input.close();
            }
            throw new IOException("Cannot read the file " + fileName + ". " + "Error: " + e.getMessage());
        }
    }

    public static OutputStream writeFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("No file name specified.");
        }
        File f = new File(fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            return new BufferedOutputStream(out);
        }
        catch (Exception e) {
            if (out != null) {
                out.close();
            }
            throw new IOException("Cannot write the file " + fileName + ". " + "Error: " + e.getMessage());
        }
    }
}

