/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.DownloadsDialog;
import org.openmicroscopy.shoola.env.ui.FileLoader;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.svc.SvcRegistry;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class UserNotifierManager
implements PropertyChangeListener {
    private static final String MESSAGE_START = "Sorry, but due to an error we were not able to automatically \nsend your ";
    private static final String MESSAGE_END = "\n\nYou can still send us the error message by clicking on the \nerror message tab, copying the error message to the clipboard, \nand sending it to ";
    private static final String ERROR_MSG = "debug information.";
    private static final String COMMENT_MSG = "comment.";
    private static final String COMMENT_REPLY = "Thanks, your comments have been successfully posted.";
    private static final String ERROR_REPLY = "Thanks, the error message has been successfully posted.";
    private static final String INVOKER_ERROR = "insight_bugs";
    private static final String INVOKER_COMMENT = "insight_comments";
    private static final String DEFAULT_COMMENT_TITLE = "Comment";
    private Container container;
    private UserNotifier component;
    private DownloadsDialog download;
    private Map<String, UserNotifierLoader> loaders;
    private MessengerDialog commentDialog;

    private void handleSendMessage(MessengerDialog source, MessengerDetails details) {
        Registry reg = this.container.getRegistry();
        boolean bug = true;
        String error = details.getError();
        if (error == null || error.length() == 0) {
            bug = false;
        }
        String url = bug ? (String)reg.lookup("/services/DEBUGGER/hostnameBug") : (String)reg.lookup("/services/DEBUGGER/hostnameComment");
        String teamAddress = (String)reg.lookup("/services/DEBUGGER/email");
        CommunicatorDescriptor desc = new CommunicatorDescriptor(1, url, -1);
        try {
            Communicator c = SvcRegistry.getCommunicator(desc);
            String reply = "";
            if (!bug) {
                c.submitComment(INVOKER_COMMENT, details.getEmail(), details.getComment(), details.getExtra(), reply);
            } else {
                c.submitError(INVOKER_ERROR, details.getEmail(), details.getComment(), details.getExtra(), error, reply);
            }
            reply = !bug ? reply + COMMENT_REPLY : reply + ERROR_REPLY;
            JOptionPane.showMessageDialog(source, reply);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.println("Failed to send message.");
            msg.println("Reason: " + e.getMessage());
            Logger logger = this.container.getRegistry().getLogger();
            logger.error((Object)this, msg);
            String s = MESSAGE_START;
            s = source.getDialogType() == 0 ? s + ERROR_MSG : s + COMMENT_MSG;
            s = s + MESSAGE_END;
            JOptionPane.showMessageDialog(source, s + teamAddress + ".");
        }
        source.setVisible(false);
        source.dispose();
    }

    private String getFileName(File[] files, OriginalFile f, String original, String dirPath, int index) {
        String path = dirPath + original;
        boolean exist = false;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getAbsolutePath().equals(path)) continue;
                exist = true;
                break;
            }
        }
        if (!exist) {
            return original;
        }
        if (f == null) {
            return original;
        }
        String name = f.getName().getValue();
        int lastDot = name.lastIndexOf(".");
        if (lastDot != -1) {
            String extension = name.substring(lastDot, name.length());
            String v = name.substring(0, lastDot) + " (" + index + ")" + extension;
            return this.getFileName(files, f, v, dirPath, ++index);
        }
        return original;
    }

    UserNotifierManager(UserNotifier component, Container c) {
        this.container = c;
        this.component = component;
        this.loaders = new HashMap<String, UserNotifierLoader>();
    }

    void setLoadingStatus(int percent, long fileID, String fileName) {
        if (this.download == null) {
            return;
        }
        this.download.setLoadingStatus(percent, fileName, fileID);
        this.loaders.remove(fileName);
    }

    void saveFileToDisk(OriginalFile file, File directory) {
        Logger log = this.container.getRegistry().getLogger();
        log.debug((Object)this, "original: " + file);
        if (file == null) {
            return;
        }
        if (this.download == null) {
            Registry reg = this.container.getRegistry();
            JFrame f = reg.getTaskBar().getFrame();
            this.download = new DownloadsDialog(f, IconManager.getInstance(reg));
            this.download.addPropertyChangeListener(this);
        }
        if (directory == null) {
            JFileChooser chooser = new JFileChooser();
            directory = chooser.getCurrentDirectory();
        }
        File[] files = directory.listFiles();
        String dirPath = directory + File.separator;
        log.debug((Object)this, "dirPath: " + dirPath);
        String name = this.getFileName(files, file, file.getName().getValue(), dirPath, 1);
        log.debug((Object)this, "name: " + name);
        String path = dirPath + name;
        log.debug((Object)this, "name and path: " + path);
        FileLoader loader = new FileLoader(this.component, this.container.getRegistry(), path, file.getId().getValue(), file.getSize().getValue());
        loader.load();
        this.download.addDowloadEntry(dirPath, name, file.getId().getValue());
        this.loaders.put(path, loader);
        if (!this.download.isVisible()) {
            UIUtilities.centerAndShow(this.download);
        }
    }

    void saveFileToDisk(Collection data, File directory) {
        if (data == null) {
            return;
        }
        if (this.download == null) {
            Registry reg = this.container.getRegistry();
            JFrame f = reg.getTaskBar().getFrame();
            this.download = new DownloadsDialog(f, IconManager.getInstance(reg));
            this.download.addPropertyChangeListener(this);
        }
        if (directory == null) {
            JFileChooser chooser = new JFileChooser();
            directory = chooser.getCurrentDirectory();
        }
        File[] files = directory.listFiles();
        String dirPath = directory + File.separator;
        for (OriginalFile file : data) {
            String name = this.getFileName(files, file, file.getName().getValue(), dirPath, 1);
            String path = dirPath + name;
            FileLoader loader = new FileLoader(this.component, this.container.getRegistry(), path, file.getId().getValue(), file.getSize().getValue());
            loader.load();
            this.download.addDowloadEntry(dirPath, name, file.getId().getValue());
            this.loaders.put(path, loader);
        }
        if (!this.download.isVisible()) {
            UIUtilities.centerAndShow(this.download);
        }
    }

    String getVersionNumber() {
        if (this.container == null) {
            return "";
        }
        Object version = this.container.getRegistry().lookup("Version");
        return (String)version;
    }

    MessengerDialog getCommentDialog(JFrame frame, String email) {
        if (this.commentDialog != null) {
            return this.commentDialog;
        }
        this.commentDialog = new MessengerDialog(frame, DEFAULT_COMMENT_TITLE, email);
        this.commentDialog.setVersion(this.getVersionNumber());
        this.commentDialog.addPropertyChangeListener(this);
        this.commentDialog.setModal(false);
        this.commentDialog.setAlwaysOnTop(false);
        return this.commentDialog;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String fileName;
        UserNotifierLoader loader;
        String name = pce.getPropertyName();
        if ("send".equals(name)) {
            MessengerDialog source = (MessengerDialog)pce.getSource();
            this.handleSendMessage(source, (MessengerDetails)pce.getNewValue());
        } else if ("closeMessenger".equals(name)) {
            this.commentDialog = null;
        } else if (!"saveToDisk".equals(name) && "cancelLoading".equals(name) && (loader = this.loaders.get(fileName = (String)pce.getNewValue())) != null) {
            loader.cancel();
        }
    }
}

