/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

abstract class UserNotifierLoader
extends DSCallAdapter {
    protected final Registry registry;
    protected final UserNotifier viewer;
    protected final MetadataHandlerView mhView;

    UserNotifierLoader(UserNotifier viewer, Registry registry) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        this.viewer = viewer;
        this.registry = registry;
        this.mhView = (MetadataHandlerView)registry.getDataServicesView(MetadataHandlerView.class);
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Loading Failure", s, exc);
    }

    public abstract void load();

    public abstract void cancel();
}

