/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JFrame;
import omero.model.FileAnnotation;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierManager;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.FileAnnotationData;

public class UserNotifierImpl
implements UserNotifier {
    private static final String DEFAULT_ERROR_TITLE = "Error";
    private static final String DEFAULT_WARNING_TITLE = "Warning";
    private static final String DEFAULT_INFO_TITLE = "Information";
    private static JFrame SHARED_FRAME = null;
    private UserNotifierManager manager;

    private String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private void showNotificationDialog(String title, String message, Icon icon) {
        NotificationDialog dialog = new NotificationDialog(SHARED_FRAME, title, message, icon);
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    private void showErrorDialog(String title, String summary, String detail) {
        Exception e = detail == null ? new Exception(summary) : new Exception(detail);
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        MessengerDialog d = new MessengerDialog(SHARED_FRAME, title, "", e);
        d.setVersion(this.manager.getVersionNumber());
        d.addPropertyChangeListener(this.manager);
        d.setModal(true);
        UIUtilities.centerAndShow(d);
    }

    UserNotifierImpl(Container c) {
        this.manager = new UserNotifierManager(this, c);
        if (SHARED_FRAME == null) {
            SHARED_FRAME = new JFrame();
            SHARED_FRAME.setIconImage(AbstractIconManager.getOMEImageIcon());
        }
    }

    public void notifyError(String title, String summary) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        this.showNotificationDialog(title, summary, IconManager.getDefaultErrorIcon());
    }

    public void notifyError(String title, String summary, Throwable detail) {
        this.notifyError(title, summary, detail == null ? null : this.printErrorText(detail));
    }

    public void notifyError(String title, String summary, String detail) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_ERROR_TITLE;
        }
        this.showErrorDialog(title, summary, detail);
    }

    public void notifyWarning(String title, String message) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultWarnIcon());
    }

    public void notifyWarning(String title, String summary, String detail) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_WARNING_TITLE;
        }
        this.showErrorDialog(title, summary, detail);
    }

    public void notifyWarning(String title, String summary, Throwable detail) {
        this.notifyWarning(title, summary, detail == null ? null : detail.getMessage());
    }

    public void notifyInfo(String title, String message) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_INFO_TITLE;
        }
        this.showNotificationDialog(title, message, IconManager.getDefaultInfoIcon());
    }

    public void notifyInfo(String title, String message, Icon icon) {
        if (title == null || title.length() == 0) {
            title = DEFAULT_INFO_TITLE;
        }
        if (icon == null) {
            icon = IconManager.getDefaultInfoIcon();
        }
        this.showNotificationDialog(title, message, icon);
    }

    public void submitMessage(String email) {
        MessengerDialog d = this.manager.getCommentDialog(SHARED_FRAME, email);
        UIUtilities.centerAndShow(d);
    }

    public void notifyDownload(FileAnnotationData data, File directory) {
        if (data == null) {
            return;
        }
        OriginalFile f = ((FileAnnotation)data.asAnnotation()).getFile();
        this.manager.saveFileToDisk(f, directory);
    }

    public void notifyDownload(Collection data, File directory) {
        this.manager.saveFileToDisk(data, directory);
    }

    public void notifyDownload(FileAnnotationData data) {
        this.notifyDownload(data, null);
    }

    public void notifyDownload(Collection data) {
        this.manager.saveFileToDisk(data, null);
    }

    public void setLoadingStatus(int percent, long fileID, String fileName) {
        this.manager.setLoadingStatus(percent, fileID, fileName);
    }
}

