/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.cache.CacheServiceFactory;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.events.SaveEventResponse;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationRequest;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationResponse;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.SoftwareUpdateDialog;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TaskBarView;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.BrowserLauncher;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskBarManager
implements AgentEventListener,
PropertyChangeListener {
    static final String TITLE_ABOUT = "About";
    private static final String A_TAG = "a";
    private TaskBarView view;
    private Container container;
    private SoftwareUpdateDialog suDialog;
    private Map<Agent, Integer> exitResponses;

    private String parse(String refFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(refFile));
            NodeList list = document.getElementsByTagName(A_TAG);
            String url = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                url = n.getFirstChild().getNodeValue();
            }
            return url;
        }
        catch (Exception e) {
            if (this.suDialog != null) {
                this.suDialog.close();
            }
            Logger logger = this.container.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print("Error while saving.");
            msg.print(e);
            logger.error((Object)this, msg);
            return null;
        }
    }

    void openURL(String url) {
        BrowserLauncher launcher = new BrowserLauncher(AbstractIconManager.getOMEIcon());
        launcher.openURL(url);
        if (this.suDialog != null) {
            this.suDialog.close();
        }
    }

    private String loadAbout(String file) {
        String message;
        try {
            String line;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            StringBuffer buffer = new StringBuffer();
            int number = 0;
            while ((line = in.readLine()) != null) {
                if (number != 0) {
                    buffer.append(line);
                }
                ++number;
            }
            in.close();
            message = buffer.toString();
        }
        catch (Exception e) {
            message = "Error: Cannot find the About file.";
            Logger logger = this.container.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print(message);
            msg.print(e);
            logger.error((Object)this, msg);
        }
        return message;
    }

    private void synchConnectionButtons() {
        boolean connected = false;
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            connected = f.isConnected();
        }
        catch (DSOutOfServiceException dSOutOfServiceException) {
            // empty catch block
        }
        this.view.getButton(9).setEnabled(!connected);
        this.view.getButton(1).setEnabled(!connected);
        this.view.getButton(10).setEnabled(connected);
        this.view.getButton(2).setEnabled(connected);
    }

    private void doManageConnection() {
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            if (f.isConnected()) {
                f.shutdown();
                this.synchConnectionButtons();
            } else {
                EventBus bus = this.container.getRegistry().getEventBus();
                bus.post(new ServiceActivationRequest(1));
            }
        }
        catch (DSOutOfServiceException oose) {
            this.synchConnectionButtons();
        }
    }

    private void handleSaveEventResponse(SaveEventResponse e) {
        int v;
        Iterator<Agent> j = this.exitResponses.keySet().iterator();
        while (j.hasNext()) {
            System.err.println(j.next());
        }
        if (e == null) {
            return;
        }
        Agent a = e.getAgent();
        Integer r = this.exitResponses.get(a);
        if (r != null && (v = r - 1) == 0) {
            this.exitResponses.remove(a);
        }
        if (this.exitResponses.size() == 0) {
            this.container.exit();
        }
    }

    private void notAvailable() {
        UserNotifier un = this.container.getRegistry().getUserNotifier();
        un.notifyInfo("Not Available", "Sorry, this functionality is not yet available.");
    }

    private void sendComment() {
        Registry reg = this.container.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        un.submitMessage("");
    }

    private void doExit(boolean askQuestion) {
        IconManager icons = IconManager.getInstance(this.container.getRegistry());
        int option = 1;
        if (askQuestion) {
            MessageBox msg = new MessageBox(this.view, "Exit application", "Do you really want to close the application?", icons.getIcon(10));
            option = msg.centerMsgBox();
        }
        if (option == 1) {
            try {
                CacheServiceFactory.shutdown(this.container);
                DataServicesFactory f = DataServicesFactory.getInstance(this.container);
                f.exitApplication();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void softwareAbout() {
        String aboutFile = (String)this.container.getRegistry().lookup("AboutFile");
        String refFile = this.container.resolveConfigFile(aboutFile);
        String message = this.loadAbout(refFile);
        String title = (String)this.container.getRegistry().lookup("SoftwareName");
        this.suDialog = new SoftwareUpdateDialog(this.view, message, refFile);
        this.suDialog.setTitle("About " + title + "...");
        this.suDialog.addPropertyChangeListener("openURL", this);
        UIUtilities.centerAndShow(this.suDialog);
    }

    private void help() {
        String path = (String)this.container.getRegistry().lookup("HelpOnLine");
        this.openURL(path);
    }

    private void attachMIListeners() {
        ActionListener noOp = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.notAvailable();
            }
        };
        this.view.getButton(3).addActionListener(noOp);
        this.view.getButton(4).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.help();
            }
        });
        this.view.getButton(5).addActionListener(noOp);
        this.view.getButton(6).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.softwareAbout();
            }
        });
        this.view.getButton(7).addActionListener(noOp);
        this.view.getButton(11).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.help();
            }
        });
        this.view.getButton(12).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.sendComment();
            }
        });
    }

    private void attachConnectionListeners() {
        ActionListener conx = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.doManageConnection();
            }
        };
        this.view.getButton(9).addActionListener(conx);
        this.view.getButton(1).addActionListener(conx);
        this.view.getButton(10).addActionListener(conx);
        this.view.getButton(2).addActionListener(conx);
    }

    private void attachOpenExitListeners() {
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                TaskBarManager.this.doExit(true);
            }

            public void windowOpened(WindowEvent we) {
                TaskBarManager.this.synchConnectionButtons();
            }
        });
    }

    private void attachListeners() {
        this.attachOpenExitListeners();
        this.attachConnectionListeners();
        this.attachMIListeners();
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.register((AgentEventListener)this, ServiceActivationResponse.class);
        bus.register((AgentEventListener)this, ExitApplication.class);
        bus.register((AgentEventListener)this, SaveEventResponse.class);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac os")) {
            try {
                MacOSMenuHandler handler = new MacOSMenuHandler(this.view);
                handler.initialize();
                this.view.addPropertyChangeListener(this);
            }
            catch (Throwable e) {
                Logger logger = this.container.getRegistry().getLogger();
                LogMessage message = new LogMessage();
                message.print(e);
                logger.info((Object)this, message);
            }
        }
    }

    TaskBarManager(Container c) {
        this.container = c;
        this.view = new TaskBarView(this, IconManager.getInstance(c.getRegistry()));
        this.attachListeners();
    }

    TaskBar getView() {
        return this.view;
    }

    String getSoftwareName() {
        return (String)this.container.getRegistry().lookup("SoftwareName");
    }

    public void eventFired(AgentEvent e) {
        if (e instanceof ServiceActivationResponse) {
            this.synchConnectionButtons();
        } else if (e instanceof ExitApplication) {
            this.doExit(((ExitApplication)e).isAskQuestion());
        } else if (e instanceof SaveEventResponse) {
            this.handleSaveEventResponse((SaveEventResponse)e);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("openURL".equals(name)) {
            String refFile = (String)evt.getNewValue();
            if (refFile != null) {
                this.openURL(this.parse(refFile));
            }
        } else if ("aboutApplication".equals(name)) {
            this.softwareAbout();
        } else if ("quitpplication".equals(name)) {
            Registry reg = this.container.getRegistry();
            Object exp = reg.lookup("/current_user/details");
            if (exp == null) {
                this.container.exit();
            } else {
                this.doExit(true);
            }
        }
    }
}

