/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

class FileLoader
extends UserNotifierLoader {
    private long fileID;
    private File file;
    private long size;
    private CallHandle handle;

    FileLoader(UserNotifier viewer, Registry reg, String path, long fileID, long size) {
        super(viewer, reg);
        this.file = new File(path);
        this.fileID = fileID;
        this.size = size;
    }

    public void load() {
        this.handle = this.mhView.loadFile(this.file, this.fileID, this.size, this);
    }

    public void cancel() {
        this.handle.cancel();
        this.file.delete();
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.viewer.setLoadingStatus(-1, this.fileID, this.file.getAbsolutePath());
    }

    public void handleResult(Object result) {
        this.viewer.setLoadingStatus(0, this.fileID, this.file.getAbsolutePath());
    }
}

