/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import layout.TableLayout;
import org.openmicroscopy.shoola.env.ui.FileLoadingComponent;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class DownloadsDialog
extends JDialog
implements PropertyChangeListener {
    static final String CANCEL_LOADING_PROPERTY = "cancelLoading";
    private static final String TITLE = "Downloads";
    private IconManager icons;
    private JPanel entries;
    private JButton cleanupButton;
    private List<FileLoadingComponent> components;

    private void initComponents() {
        this.components = new ArrayList<FileLoadingComponent>();
        this.entries = new JPanel();
        this.entries.setBackground(UIUtilities.BACKGROUND);
        this.entries.setLayout(new BoxLayout(this.entries, 1));
        this.cleanupButton = new JButton("Clean Up");
        this.getRootPane().setDefaultButton(this.cleanupButton);
        this.cleanupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadsDialog.this.cleanup();
            }
        });
    }

    private void cleanup() {
        this.components.clear();
        this.entries.removeAll();
        this.repaint();
    }

    private JPanel buildStatusBar() {
        JPanel p = new JPanel();
        p.add(this.cleanupButton);
        JPanel bar = UIUtilities.buildComponentPanelRight(p);
        bar.setBorder(new LineBorder(Color.LIGHT_GRAY));
        return bar;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        JScrollPane pane = new JScrollPane(this.entries);
        pane.setOpaque(false);
        pane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        c.add((Component)pane, "Center");
        c.add((Component)this.buildStatusBar(), "South");
    }

    private void layoutEntries() {
        this.entries.removeAll();
        double[] columns = new double[]{-1.0};
        TableLayout layout = new TableLayout();
        layout.setColumn(columns);
        this.entries.setLayout((LayoutManager)layout);
        int index = 0;
        Iterator<FileLoadingComponent> i = this.components.iterator();
        while (i.hasNext()) {
            layout.insertRow(index, -2.0);
            FileLoadingComponent c = i.next();
            this.entries.add((Component)c, "0, " + index + ", f, c");
            if (index % 2 == 0) {
                c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
            } else {
                c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
            }
            ++index;
        }
        this.entries.revalidate();
        this.repaint();
    }

    DownloadsDialog(JFrame owner, IconManager icons) {
        super(owner);
        this.icons = icons;
        this.setTitle(TITLE);
        this.initComponents();
        this.buildGUI();
        this.setSize(200, 300);
    }

    void setLoadingStatus(int percent, String name, long fileID) {
        for (FileLoadingComponent c : this.components) {
            if (c.getFileID() != fileID || !c.getAbsolutePath().equals(name)) continue;
            c.setStatus(percent);
        }
    }

    void addDowloadEntry(String directory, String fileName, long fileID) {
        FileLoadingComponent c = new FileLoadingComponent(directory, fileName, fileID, this.icons);
        c.addPropertyChangeListener(this);
        this.components.add(c);
        this.layoutEntries();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("cancel".equals(name)) {
            this.firePropertyChange(CANCEL_LOADING_PROPERTY, evt.getOldValue(), evt.getNewValue());
        } else if ("remove".equals(name)) {
            String path = (String)evt.getNewValue();
            Iterator<FileLoadingComponent> i = this.components.iterator();
            FileLoadingComponent toRemove = null;
            while (i.hasNext()) {
                FileLoadingComponent c = i.next();
                if (!c.getAbsolutePath().equals(path)) continue;
                toRemove = c;
                break;
            }
            if (toRemove != null) {
                this.components.remove(toRemove);
                this.layoutEntries();
            }
        }
    }
}

