/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.data;

import org.openmicroscopy.shoola.env.cache.CacheService;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.rnd.data.BytesConverter;
import org.openmicroscopy.shoola.env.rnd.data.DataSourceException;
import org.openmicroscopy.shoola.env.rnd.data.Plane2D;
import org.openmicroscopy.shoola.util.mem.ReadOnlyByteArray;
import pojos.PixelsData;

public class DataSink {
    static final String INT_8 = "int8";
    static final String UINT_8 = "uint8";
    static final String INT_16 = "int16";
    static final String UINT_16 = "uint16";
    static final String INT_32 = "int32";
    static final String UINT_32 = "uint32";
    static final String FLOAT = "float";
    static final String DOUBLE = "double";
    private PixelsData source;
    private Registry context;
    private int bytesPerPixels;
    private BytesConverter strategy;
    private int cacheID;

    public static DataSink makeNew(PixelsData source, Registry context, int cacheSize) {
        if (source == null) {
            throw new NullPointerException("No pixels.");
        }
        if (context == null) {
            throw new NullPointerException("No registry.");
        }
        return new DataSink(source, context, cacheSize);
    }

    private DataSink(PixelsData source, Registry context, int cacheSize) {
        this.source = source;
        this.context = context;
        String type = source.getPixelType();
        this.bytesPerPixels = this.getBytesPerPixels(type);
        int maxEntries = cacheSize / (source.getSizeX() * source.getSizeY() * this.bytesPerPixels);
        this.cacheID = context.getCacheService().createCache(2, maxEntries);
        this.strategy = BytesConverter.getConverter(type);
    }

    private int getBytesPerPixels(String v) {
        if (INT_8.equals(v) || UINT_8.equals(v)) {
            return 1;
        }
        if (INT_16.equals(v) || UINT_16.equals(v)) {
            return 2;
        }
        if (INT_32.equals(v) || UINT_32.equals(v) || FLOAT.equals(v)) {
            return 4;
        }
        if (DOUBLE.equals(v)) {
            return 8;
        }
        return -1;
    }

    private Integer linearize(int z, int w, int t) {
        int sizeZ = this.source.getSizeZ();
        int sizeC = this.source.getSizeC();
        if (z < 0 || sizeZ <= z) {
            throw new IllegalArgumentException("z out of range [0, " + sizeZ + "): " + z + ".");
        }
        if (w < 0 || sizeC <= w) {
            throw new IllegalArgumentException("w out of range [0, " + sizeC + "): " + w + ".");
        }
        if (t < 0 || this.source.getSizeT() <= t) {
            throw new IllegalArgumentException("t out of range [0, " + this.source.getSizeT() + "): " + t + ".");
        }
        return new Integer(sizeZ * sizeC * t + sizeZ * w + z);
    }

    private Plane2D createPlane(int z, int t, int w, BytesConverter strategy) throws DataSourceException {
        Integer planeIndex = this.linearize(z, w, t);
        CacheService cache = this.context.getCacheService();
        Plane2D plane = (Plane2D)cache.getElement(this.cacheID, planeIndex);
        if (plane != null) {
            return plane;
        }
        byte[] data = null;
        try {
            OmeroImageService service = this.context.getImageService();
            data = service.getPlane(this.source.getId(), z, t, w);
        }
        catch (Exception e) {
            String p = "(" + z + ", " + t + ", " + w + ")";
            throw new DataSourceException("Cannot retrieve the plane " + p, e);
        }
        ReadOnlyByteArray array = new ReadOnlyByteArray(data, 0, data.length);
        plane = new Plane2D(array, this.source.getSizeX(), this.source.getSizeY(), this.bytesPerPixels, strategy);
        cache.addElement(this.cacheID, planeIndex, plane);
        return plane;
    }

    public Plane2D getPlane(int z, int t, int w) throws DataSourceException {
        return this.createPlane(z, t, w, this.strategy);
    }

    public boolean isSame(long pixelsID) {
        return pixelsID == this.source.getId();
    }

    public void clearCache() {
        this.context.getCacheService().clearCache(this.cacheID);
    }

    public void setCacheInMemory(boolean cacheInMemory) {
        this.clearCache();
        if (cacheInMemory) {
            this.context.getCacheService().setCacheEntries(this.cacheID, 1);
        } else {
            this.context.getCacheService().setCacheEntries(this.cacheID, 0);
        }
    }
}

