/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import omero.ServerError;
import omero.api.RenderingEnginePrx;
import omero.model.Family;
import omero.model.Pixels;
import omero.model.QuantumDef;
import omero.model.RenderingModel;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.rnd.ChannelBindingsProxy;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.WriterImage;
import pojos.ChannelData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenderingControlProxy
implements RenderingControl {
    private static final String ERROR = "An error occured while trying to set the ";
    private List families;
    private List models;
    private Pixels pixs;
    private RenderingEnginePrx servant;
    private int cacheID;
    private ChannelData[] metadata;
    private RndProxyDef rndDef;
    private int compression;
    private Registry context;
    private int cacheSize;
    private int imageSize;

    private void handleException(Throwable e, String message) throws RenderingServiceException, DSOutOfServiceException {
        if (e instanceof ServerError) {
            this.shutDown();
            throw new DSOutOfServiceException(message + "\n\n" + this.printErrorText(e), e);
        }
        throw new RenderingServiceException(message + "\n\n" + this.printErrorText(e), e);
    }

    private String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private Object getFromCache(PlaneDef pd) {
        if (pd.slice == 0 && this.cacheID >= 0) {
            int index = pd.z + this.getPixelsDimensionsZ() * pd.t;
            return this.context.getCacheService().getElement(this.cacheID, index);
        }
        return null;
    }

    private void cache(PlaneDef pd, Object object) {
        if (pd.slice == 0 && this.cacheID >= 0) {
            int index = pd.z + this.getPixelsDimensionsZ() * pd.t;
            this.context.getCacheService().addElement(this.cacheID, new Integer(index), object);
        }
    }

    private void invalidateCache() {
        if (this.cacheID >= 0) {
            this.context.getCacheService().clearCache(this.cacheID);
        }
    }

    private void eraseCache() {
        this.invalidateCache();
        this.context.getCacheService().removeCache(this.cacheID);
    }

    private void initializeCache(PlaneDef pDef) {
        if (this.cacheID >= 0) {
            return;
        }
        if (pDef.slice == 0) {
            this.cacheID = this.context.getCacheService().createCache(2, this.cacheSize / this.imageSize);
        }
    }

    private void checkBitResolution(int v) {
        switch (v) {
            case 1: 
            case 3: 
            case 7: 
            case 15: 
            case 31: 
            case 63: 
            case 127: 
            case 255: {
                return;
            }
        }
        throw new IllegalArgumentException("Bit resolution not supported.");
    }

    private boolean isRightColor(int red, int green, int blue) {
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            if (!this.isActive(i) || !this.isRightChannelColor(i, red, green, blue)) continue;
            return true;
        }
        return false;
    }

    private boolean isRightChannelColor(int index, int red, int green, int blue) {
        int[] rgba = this.rndDef.getChannel(index).getRGBA();
        return rgba[0] == red && rgba[1] == green && rgba[2] == blue;
    }

    private void initialize() {
        try {
            this.rndDef.setTypeSigned(this.servant.isPixelsTypeSigned());
            this.rndDef.setDefaultZ(this.servant.getDefaultZ());
            this.rndDef.setDefaultT(this.servant.getDefaultT());
            QuantumDef qDef = this.servant.getQuantumDef();
            this.rndDef.setBitResolution(qDef.getBitResolution().getValue());
            this.rndDef.setColorModel(this.servant.getModel().getValue().getValue());
            this.rndDef.setCodomain(qDef.getCdStart().getValue(), qDef.getCdEnd().getValue());
            for (int i = 0; i < this.metadata.length; ++i) {
                ChannelData channel = this.metadata[i];
                ChannelBindingsProxy cb = this.rndDef.getChannel(channel.getIndex());
                if (cb == null) {
                    cb = new ChannelBindingsProxy();
                    this.rndDef.setChannel(channel.getIndex(), cb);
                }
                cb.setActive(this.servant.isActive(i));
                cb.setInterval(this.servant.getChannelWindowStart(i), this.servant.getChannelWindowEnd(i));
                cb.setQuantization(this.servant.getChannelFamily(i).getValue().getValue(), this.servant.getChannelCurveCoefficient(i), this.servant.getChannelNoiseReduction(i));
                cb.setRGBA(this.servant.getRGBA(i));
                cb.setLowerBound(this.servant.getPixelsTypeLowerBound(i));
                cb.setUpperBound(this.servant.getPixelsTypeUpperBound(i));
            }
            this.tmpSolutionForNoiseReduction();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void tmpSolutionForNoiseReduction() {
        try {
            for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                this.setQuantizationMap(i, this.getChannelFamily(i), this.getChannelCurveCoefficient(i), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setRGBA(int w, int[] rgba) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setRGBA(w, rgba[0], rgba[1], rgba[2], rgba[3]);
            this.rndDef.getChannel(w).setRGBA(rgba[0], rgba[1], rgba[2], rgba[3]);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occured while trying to set the color for: " + w + ".");
        }
    }

    private BufferedImage renderPlaneCompressed(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        Object array = this.getFromCache(pDef);
        try {
            if (array != null) {
                return ImageIO.read(new ByteArrayInputStream((byte[])array));
            }
            byte[] values = this.servant.renderCompressed(pDef);
            this.imageSize = values.length;
            this.initializeCache(pDef);
            this.cache(pDef, values);
            return WriterImage.bytesToImageJPEG(values);
        }
        catch (Throwable e) {
            this.handleException(e, "An error occured while trying to set the cannot render the compressed image.");
            return null;
        }
    }

    private BufferedImage renderPlaneUncompressed(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        BufferedImage img = (BufferedImage)this.getFromCache(pDef);
        if (img != null) {
            return img;
        }
        try {
            int sizeX2;
            int sizeX1;
            int[] buf = this.servant.renderAsPackedInt(pDef);
            switch (pDef.slice) {
                case 2: {
                    sizeX1 = this.pixs.getSizeX().getValue();
                    sizeX2 = this.pixs.getSizeZ().getValue();
                    break;
                }
                case 1: {
                    sizeX1 = this.pixs.getSizeZ().getValue();
                    sizeX2 = this.pixs.getSizeY().getValue();
                    break;
                }
                default: {
                    sizeX1 = this.pixs.getSizeX().getValue();
                    sizeX2 = this.pixs.getSizeY().getValue();
                }
            }
            this.imageSize = 3 * buf.length;
            this.initializeCache(pDef);
            img = Factory.createImage(buf, 32, sizeX1, sizeX2);
            this.cache(pDef, img);
        }
        catch (Throwable e) {
            this.handleException(e, "An error occured while trying to set the cannot render the plane.");
        }
        return img;
    }

    private BufferedImage renderProjectedCompressed(int startZ, int endZ, int stepping, int type) throws RenderingServiceException, DSOutOfServiceException {
        try {
            byte[] values = this.servant.renderProjectedCompressed(ProjectionParam.convertType(type), this.getDefaultT(), stepping, startZ, endZ);
            return WriterImage.bytesToImageJPEG(values);
        }
        catch (Throwable e) {
            this.handleException(e, "An error occured while trying to set the cannot render projected selection.");
            return null;
        }
    }

    private BufferedImage renderProjectedUncompressed(int startZ, int endZ, int stepping, int type) throws RenderingServiceException, DSOutOfServiceException {
        BufferedImage img = null;
        try {
            int[] buf = this.servant.renderProjectedAsPackedInt(ProjectionParam.convertType(type), this.getDefaultT(), stepping, startZ, endZ);
            int sizeX1 = this.pixs.getSizeX().getValue();
            int sizeX2 = this.pixs.getSizeY().getValue();
            img = Factory.createImage(buf, 32, sizeX1, sizeX2);
        }
        catch (Throwable e) {
            this.handleException(e, "An error occured while trying to set the cannot render projected selection.");
        }
        return img;
    }

    RenderingControlProxy(Registry context, RenderingEnginePrx re, Pixels pixels, List m, int compression, RndProxyDef rndDef, int cacheSize) {
        if (re == null) {
            throw new NullPointerException("No rendering engine.");
        }
        if (pixels == null) {
            throw new NullPointerException("No pixels set.");
        }
        if (context == null) {
            throw new NullPointerException("No registry.");
        }
        this.cacheSize = cacheSize;
        this.context = context;
        this.servant = re;
        this.pixs = pixels;
        this.families = null;
        this.models = null;
        try {
            this.families = this.servant.getAvailableFamilies();
            this.models = this.servant.getAvailableModels();
            this.cacheID = -1;
            this.imageSize = 1;
            this.compression = compression;
            if (rndDef == null) {
                this.rndDef = new RndProxyDef();
                this.initialize();
            } else {
                this.rndDef = rndDef;
                for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                    ChannelBindingsProxy cb = rndDef.getChannel(i);
                    cb.setLowerBound(this.servant.getPixelsTypeLowerBound(i));
                    cb.setUpperBound(this.servant.getPixelsTypeUpperBound(i));
                }
            }
            this.metadata = new ChannelData[m.size()];
            Iterator i = m.iterator();
            while (i.hasNext()) {
                ChannelData cm;
                this.metadata[cm.getIndex()] = cm = (ChannelData)i.next();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void resetRenderingEngine(RenderingEnginePrx servant, RndProxyDef rndDef) throws RenderingServiceException, DSOutOfServiceException {
        if (servant == null) {
            return;
        }
        try {
            this.servant.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.invalidateCache();
        this.servant = servant;
        try {
            if (rndDef == null) {
                this.initialize();
            } else {
                this.rndDef = rndDef;
                for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                    ChannelBindingsProxy cb = rndDef.getChannel(i);
                    cb.setLowerBound(servant.getPixelsTypeLowerBound(i));
                    cb.setUpperBound(servant.getPixelsTypeUpperBound(i));
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering engine.");
        }
    }

    void setRenderingEngine(RenderingEnginePrx servant) throws RenderingServiceException, DSOutOfServiceException {
        if (servant == null) {
            return;
        }
        this.servant = servant;
        if (this.rndDef == null) {
            return;
        }
        try {
            servant.setDefaultZ(this.rndDef.getDefaultZ());
            servant.setDefaultT(this.rndDef.getDefaultT());
            servant.setQuantumStrategy(this.rndDef.getBitResolution());
            Iterator k = this.models.iterator();
            String value = this.rndDef.getColorModel();
            while (k.hasNext()) {
                RenderingModel model = (RenderingModel)k.next();
                if (!model.getValue().getValue().equals(value)) continue;
                servant.setModel(model);
            }
            servant.setCodomainInterval(this.rndDef.getCdStart(), this.rndDef.getCdEnd());
            for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                ChannelBindingsProxy cb = this.rndDef.getChannel(i);
                servant.setActive(i, cb.isActive());
                servant.setChannelWindow(i, cb.getInputStart(), cb.getInputEnd());
                k = this.families.iterator();
                value = cb.getFamily();
                while (k.hasNext()) {
                    Family family = (Family)k.next();
                    if (!family.getValue().getValue().equals(value)) continue;
                    servant.setQuantizationMap(i, family, cb.getCurveCoefficient(), cb.isNoiseReduction());
                }
                int[] rgba = cb.getRGBA();
                servant.setRGBA(i, rgba[0], rgba[1], rgba[2], rgba[3]);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering engine.");
        }
    }

    void shutDown() {
        try {
            this.servant.close();
            this.context.getCacheService().removeCache(this.cacheID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setCacheSize(int size) {
        if (this.imageSize == 0) {
            this.imageSize = 1;
        }
        this.context.getCacheService().setCacheEntries(this.cacheID, size / this.imageSize);
    }

    @Override
    public void setModel(String value) throws RenderingServiceException, DSOutOfServiceException {
        try {
            for (RenderingModel model : this.models) {
                if (!model.getValue().getValue().equals(value)) continue;
                this.servant.setModel(model);
                this.rndDef.setColorModel(value);
                this.invalidateCache();
            }
        }
        catch (Exception e) {
            this.rndDef.setColorModel(value);
            this.handleException(e, "An error occured while trying to set the model.");
        }
    }

    @Override
    public String getModel() {
        return this.rndDef.getColorModel();
    }

    @Override
    public int getDefaultZ() {
        return this.rndDef.getDefaultZ();
    }

    @Override
    public int getDefaultT() {
        return this.rndDef.getDefaultT();
    }

    @Override
    public void setDefaultZ(int z) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setDefaultZ(z);
            this.rndDef.setDefaultZ(z);
        }
        catch (Exception e) {
            this.rndDef.setDefaultZ(z);
            this.handleException(e, "An error occured while trying to set the default Z.");
        }
    }

    @Override
    public void setDefaultT(int t) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setDefaultT(t);
            this.rndDef.setDefaultT(t);
        }
        catch (Exception e) {
            this.rndDef.setDefaultT(t);
            this.handleException(e, "An error occured while trying to set the default T.");
        }
    }

    @Override
    public void setQuantumStrategy(int bitResolution) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.checkBitResolution(bitResolution);
            this.servant.setQuantumStrategy(bitResolution);
            this.rndDef.setBitResolution(bitResolution);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.rndDef.setBitResolution(bitResolution);
            this.handleException(e, "An error occured while trying to set the bit resolution.");
        }
    }

    @Override
    public void setCodomainInterval(int start, int end) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setCodomainInterval(start, end);
            this.rndDef.setCodomain(start, end);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.rndDef.setCodomain(start, end);
            this.handleException(e, "An error occured while trying to set the codomain interval.");
        }
    }

    @Override
    public void setQuantizationMap(int w, String value, double coefficient, boolean noiseReduction) throws RenderingServiceException, DSOutOfServiceException {
        try {
            List list = this.servant.getAvailableFamilies();
            for (Family family : list) {
                if (!family.getValue().getValue().equals(value)) continue;
                this.servant.setQuantizationMap(w, family, coefficient, noiseReduction);
                this.rndDef.getChannel(w).setQuantization(value, coefficient, noiseReduction);
                this.invalidateCache();
            }
        }
        catch (Exception e) {
            this.rndDef.getChannel(w).setQuantization(value, coefficient, noiseReduction);
            this.handleException(e, "An error occured while trying to set the quantization map.");
        }
    }

    @Override
    public String getChannelFamily(int w) {
        return this.rndDef.getChannel(w).getFamily();
    }

    @Override
    public boolean getChannelNoiseReduction(int w) {
        return this.rndDef.getChannel(w).isNoiseReduction();
    }

    @Override
    public double getChannelCurveCoefficient(int w) {
        return this.rndDef.getChannel(w).getCurveCoefficient();
    }

    @Override
    public void setChannelWindow(int w, double start, double end) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setChannelWindow(w, start, end);
            this.rndDef.getChannel(w).setInterval(start, end);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.rndDef.getChannel(w).setInterval(start, end);
            this.handleException(e, "An error occured while trying to set the input channel for: " + w + ".");
        }
    }

    @Override
    public double getChannelWindowStart(int w) {
        return this.rndDef.getChannel(w).getInputStart();
    }

    @Override
    public double getChannelWindowEnd(int w) {
        return this.rndDef.getChannel(w).getInputEnd();
    }

    @Override
    public void setRGBA(int w, Color c) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setRGBA(w, c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            this.rndDef.getChannel(w).setRGBA(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occured while trying to set the color for: " + w + ".");
        }
    }

    @Override
    public Color getRGBA(int w) {
        int[] rgba = this.rndDef.getChannel(w).getRGBA();
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    @Override
    public void setActive(int w, boolean active) throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.setActive(w, active);
            this.rndDef.getChannel(w).setActive(active);
            this.invalidateCache();
        }
        catch (Exception e) {
            this.handleException(e, "An error occured while trying to set the active channel for: " + w + ".");
        }
    }

    @Override
    public boolean isActive(int w) {
        return this.rndDef.getChannel(w).isActive();
    }

    @Override
    public List getCodomainMaps() {
        return new ArrayList(0);
    }

    @Override
    public RndProxyDef saveCurrentSettings() throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.saveCurrentSettings();
            return this.rndDef.copy();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.handleException(e, "An error occured while trying to set the save current settings.");
            return null;
        }
    }

    @Override
    public void resetDefaults() throws RenderingServiceException, DSOutOfServiceException {
        try {
            this.servant.resetDefaultsNoSave();
            this.setModel("rgb");
            this.invalidateCache();
            this.initialize();
        }
        catch (Throwable e) {
            this.handleException(e, "An error occured while trying to set the default settings.");
        }
    }

    @Override
    public double getPixelsPhysicalSizeX() {
        if (this.pixs.getPhysicalSizeX() == null) {
            return 1.0;
        }
        return this.pixs.getPhysicalSizeX().getValue();
    }

    @Override
    public double getPixelsPhysicalSizeY() {
        if (this.pixs.getPhysicalSizeY() == null) {
            return 1.0;
        }
        return this.pixs.getPhysicalSizeY().getValue();
    }

    @Override
    public double getPixelsPhysicalSizeZ() {
        if (this.pixs.getPhysicalSizeZ() == null) {
            return 1.0;
        }
        return this.pixs.getPhysicalSizeZ().getValue();
    }

    @Override
    public int getPixelsDimensionsX() {
        return this.pixs.getSizeX().getValue();
    }

    @Override
    public int getPixelsDimensionsY() {
        return this.pixs.getSizeY().getValue();
    }

    @Override
    public int getPixelsDimensionsZ() {
        return this.pixs.getSizeZ().getValue();
    }

    @Override
    public int getPixelsDimensionsT() {
        return this.pixs.getSizeT().getValue();
    }

    @Override
    public int getPixelsDimensionsC() {
        return this.pixs.getSizeC().getValue();
    }

    @Override
    public List getFamilies() {
        ArrayList<String> l = new ArrayList<String>(this.families.size());
        Iterator i = this.families.iterator();
        while (i.hasNext()) {
            l.add(((Family)i.next()).getValue().getValue());
        }
        return l;
    }

    @Override
    public ChannelData getChannelData(int w) {
        return this.metadata[w];
    }

    @Override
    public ChannelData[] getChannelData() {
        return this.metadata;
    }

    @Override
    public int getCodomainStart() {
        return this.rndDef.getCdStart();
    }

    @Override
    public int getCodomainEnd() {
        return this.rndDef.getCdEnd();
    }

    @Override
    public int getBitResolution() {
        return this.rndDef.getBitResolution();
    }

    @Override
    public boolean hasActiveChannelBlue() {
        return this.isRightColor(0, 0, 255);
    }

    @Override
    public boolean hasActiveChannelGreen() {
        return this.isRightColor(0, 255, 0);
    }

    @Override
    public boolean hasActiveChannelRed() {
        return this.isRightColor(255, 0, 0);
    }

    @Override
    public boolean isChannelRed(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        return this.isRightChannelColor(index, 255, 0, 0);
    }

    @Override
    public boolean isChannelBlue(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        return this.isRightChannelColor(index, 0, 0, 255);
    }

    @Override
    public boolean isChannelGreen(int index) {
        if (index < 0 || index > this.getPixelsDimensionsC()) {
            return false;
        }
        return this.isRightChannelColor(index, 0, 255, 0);
    }

    @Override
    public RndProxyDef getRndSettingsCopy() {
        return this.rndDef.copy();
    }

    @Override
    public void resetSettings(RndProxyDef rndDef) throws RenderingServiceException, DSOutOfServiceException {
        if (rndDef == null) {
            throw new IllegalArgumentException("No rendering settings to set");
        }
        if (rndDef.getNumberOfChannels() != this.getPixelsDimensionsC()) {
            throw new IllegalArgumentException("Rendering settings not compatible.");
        }
        this.setDefaultT(rndDef.getDefaultT());
        this.setDefaultZ(rndDef.getDefaultZ());
        this.setModel(rndDef.getColorModel());
        this.setCodomainInterval(rndDef.getCdStart(), rndDef.getCdEnd());
        this.setQuantumStrategy(rndDef.getBitResolution());
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            ChannelBindingsProxy c = rndDef.getChannel(i);
            if (c == null) continue;
            this.setRGBA(i, c.getRGBA());
            this.setChannelWindow(i, c.getInputStart(), c.getInputEnd());
            this.setQuantizationMap(i, c.getFamily(), c.getCurveCoefficient(), c.isNoiseReduction());
            this.setActive(i, c.isActive());
        }
    }

    @Override
    public double getPixelsTypeLowerBound(int w) {
        return this.rndDef.getChannel(w).getLowerBound();
    }

    @Override
    public double getPixelsTypeUpperBound(int w) {
        return this.rndDef.getChannel(w).getUpperBound();
    }

    @Override
    public boolean isPixelsTypeSigned() {
        return this.rndDef.isTypeSigned();
    }

    @Override
    public boolean validatePixels(PixelsData pixels) {
        if (pixels == null) {
            return false;
        }
        if (this.getPixelsDimensionsC() != pixels.getSizeC()) {
            return false;
        }
        if (this.getPixelsDimensionsY() != pixels.getSizeY()) {
            return false;
        }
        if (this.getPixelsDimensionsX() != pixels.getSizeX()) {
            return false;
        }
        String s = pixels.getPixelType();
        String value = this.pixs.getPixelsType().getValue().getValue();
        return value.equals(s);
    }

    @Override
    public BufferedImage renderPlane(PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        if (pDef == null) {
            throw new IllegalArgumentException("Plane def cannot be null.");
        }
        if (this.isCompressed()) {
            return this.renderPlaneCompressed(pDef);
        }
        return this.renderPlaneUncompressed(pDef);
    }

    @Override
    public void setCompression(int compression) {
        try {
            float f = PixelsServicesFactory.getCompressionQuality(compression);
            this.rndDef.setCompression(f);
            this.servant.setCompressionLevel(f);
            this.compression = compression;
            this.eraseCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isCompressed() {
        return this.compression != 0;
    }

    @Override
    public int getCompressionLevel() {
        return this.compression;
    }

    @Override
    public void setOriginalRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        DataServicesFactory.isSessionAlive(this.context);
        try {
            this.servant.resetDefaultsNoSave();
            this.setModel("rgb");
            List list = this.servant.getAvailableFamilies();
            for (int i = 0; i < this.pixs.getSizeC().getValue(); ++i) {
                for (Family family : list) {
                    String value = family.getValue().getValue();
                    if (!value.equals(this.getChannelFamily(i))) continue;
                    this.servant.setQuantizationMap(i, family, this.getChannelCurveCoefficient(i), false);
                }
                ChannelData m = this.getChannelData(i);
                this.servant.setChannelWindow(i, m.getGlobalMin(), m.getGlobalMax());
            }
            this.invalidateCache();
            this.initialize();
        }
        catch (Throwable e) {
            this.handleException(e, "An error occured while trying to set the default settings.");
        }
    }

    @Override
    public BufferedImage renderProjected(int startZ, int endZ, int stepping, int type, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        DataServicesFactory.isSessionAlive(this.context);
        List<Integer> active = this.getActiveChannels();
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            this.setActive(i, false);
        }
        Iterator<Integer> j = channels.iterator();
        while (j.hasNext()) {
            this.setActive(j.next(), true);
        }
        BufferedImage img = this.isCompressed() ? this.renderProjectedCompressed(startZ, endZ, stepping, type) : this.renderProjectedUncompressed(startZ, endZ, stepping, type);
        j = active.iterator();
        while (j.hasNext()) {
            this.setActive(j.next(), true);
        }
        return img;
    }

    @Override
    public void copyRenderingSettings(RndProxyDef rndToCopy, List<Integer> indexes) throws RenderingServiceException, DSOutOfServiceException {
        DataServicesFactory.isSessionAlive(this.context);
        if (this.rndDef == null) {
            throw new IllegalArgumentException("No rendering settings to set");
        }
        DataServicesFactory.isSessionAlive(this.context);
        this.setModel(rndToCopy.getColorModel());
        this.setCodomainInterval(rndToCopy.getCdStart(), rndToCopy.getCdEnd());
        this.setQuantumStrategy(rndToCopy.getBitResolution());
        int defaultT = rndToCopy.getDefaultT();
        int maxT = this.getPixelsDimensionsT();
        if (defaultT >= 0 && defaultT < maxT) {
            this.setDefaultT(rndToCopy.getDefaultT());
        }
        Iterator<Integer> j = indexes.iterator();
        int k = 0;
        while (j.hasNext()) {
            Integer index = j.next();
            ChannelBindingsProxy c = rndToCopy.getChannel(index);
            if (c != null) {
                this.setRGBA(k, c.getRGBA());
                this.setChannelWindow(k, c.getInputStart(), c.getInputEnd());
                this.setQuantizationMap(k, c.getFamily(), c.getCurveCoefficient(), c.isNoiseReduction());
                this.setActive(k, c.isActive());
            }
            ++k;
        }
    }

    @Override
    public List<Integer> getActiveChannels() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            if (!this.isActive(i)) continue;
            active.add(new Integer(i));
        }
        return active;
    }

    @Override
    public boolean isSameSettings(RndProxyDef def, boolean checkPlane) {
        ChannelBindingsProxy channel;
        if (def == null) {
            return false;
        }
        if (checkPlane) {
            if (def.getDefaultZ() != this.getDefaultZ()) {
                return false;
            }
            if (def.getDefaultT() != this.getDefaultT()) {
                return false;
            }
        }
        if (def.getBitResolution() != this.getBitResolution()) {
            return false;
        }
        if (def.getCdEnd() != this.getCodomainEnd()) {
            return false;
        }
        if (def.getCdStart() != this.getCodomainStart()) {
            return false;
        }
        if (!def.getColorModel().equals(this.getModel())) {
            return false;
        }
        if (def.getCompression() != this.rndDef.getCompression()) {
            return false;
        }
        HashMap<Integer, ChannelBindingsProxy> oldChannels = new HashMap<Integer, ChannelBindingsProxy>();
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            channel = def.getChannel(i);
            if (!channel.isActive()) continue;
            oldChannels.put(i, channel);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.getPixelsDimensionsC(); ++i) {
            if (!this.isActive(i)) continue;
            indexes.add(i);
        }
        if (indexes.size() != oldChannels.size()) {
            return false;
        }
        Iterator j = oldChannels.keySet().iterator();
        while (j.hasNext()) {
            Color color;
            int i = (Integer)j.next();
            if (!indexes.contains(i)) {
                return false;
            }
            channel = (ChannelBindingsProxy)oldChannels.get(i);
            if (channel.getInputStart() != this.getChannelWindowStart(i)) {
                return false;
            }
            if (channel.getInputEnd() != this.getChannelWindowEnd(i)) {
                return false;
            }
            if (channel.getCurveCoefficient() != this.getChannelCurveCoefficient(i)) {
                return false;
            }
            if (!channel.getFamily().equals(this.getChannelFamily(i))) {
                return false;
            }
            if (channel.isNoiseReduction() != this.getChannelNoiseReduction(i)) {
                return false;
            }
            int[] rgba = channel.getRGBA();
            if (rgba[0] != (color = this.getRGBA(i)).getRed()) {
                return false;
            }
            if (rgba[1] != color.getGreen()) {
                return false;
            }
            if (rgba[2] != color.getBlue()) {
                return false;
            }
            if (rgba[3] == color.getAlpha()) continue;
            return false;
        }
        return true;
    }
}

