/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd;

import java.awt.image.BufferedImage;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.api.RenderingEnginePrx;
import omero.model.ChannelBinding;
import omero.model.Pixels;
import omero.model.QuantumDef;
import omero.model.RenderingDef;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.rnd.ChannelBindingsProxy;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingControlProxy;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.rnd.data.DataSink;
import pojos.ChannelData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PixelsServicesFactory {
    private static final double RATIO = 0.1;
    private static final int FACTOR = 0x100000;
    private static PixelsServicesFactory singleton;
    private static Registry registry;
    private static int maxSize;
    private Map<Long, RenderingControl> rndSvcProxies = new HashMap<Long, RenderingControl>();
    private DataSink pixelsSource;

    public static RndProxyDef convert(RenderingDef rndDef) {
        if (rndDef == null) {
            return null;
        }
        RndProxyDef proxy = new RndProxyDef();
        proxy.setDefaultZ(rndDef.getDefaultZ().getValue());
        proxy.setDefaultT(rndDef.getDefaultT().getValue());
        proxy.setColorModel(rndDef.getModel().getValue().getValue());
        QuantumDef def = rndDef.getQuantization();
        proxy.setCodomain(def.getCdStart().getValue(), def.getCdEnd().getValue());
        proxy.setBitResolution(def.getBitResolution().getValue());
        List bindings = rndDef.copyWaveRendering();
        Iterator k = bindings.iterator();
        int i = 0;
        while (k.hasNext()) {
            ChannelBinding c = (ChannelBinding)k.next();
            ChannelBindingsProxy cb = proxy.getChannel(i);
            if (cb == null) {
                cb = new ChannelBindingsProxy();
                proxy.setChannel(i, cb);
            }
            if (c != null) {
                int[] rgba = new int[]{c.getRed().getValue(), c.getGreen().getValue(), c.getBlue().getValue(), c.getAlpha().getValue()};
                cb.setActive(c.getActive().getValue());
                cb.setInterval(c.getInputStart().getValue(), c.getInputEnd().getValue());
                cb.setRGBA(rgba);
                cb.setQuantization(c.getFamily().getValue().getValue(), c.getCoefficient().getValue(), c.getNoiseReduction().getValue());
            }
            ++i;
        }
        return proxy;
    }

    public static PixelsServicesFactory getInstance(Container c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            registry = c.getRegistry();
            singleton = new PixelsServicesFactory();
            MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            String message = "Heap memory usage: max " + usage.getMax();
            registry.getLogger().info((Object)singleton, message);
            maxSize = (int)(0.1 * (double)usage.getMax()) / 0x100000;
        }
        return singleton;
    }

    public static RenderingControl createRenderingControl(Registry context, RenderingEnginePrx re, Pixels pixels, List<ChannelData> metadata, int compression, RenderingDef def) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        return singleton.makeNew(re, pixels, metadata, compression, def);
    }

    public static RenderingControlProxy reloadRenderingControl(Registry context, long pixelsID, RenderingEnginePrx re) throws RenderingServiceException, DSOutOfServiceException {
        if (!registry.equals(context)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy != null) {
            proxy.shutDown();
            proxy.setRenderingEngine(re);
        }
        return proxy;
    }

    public static RenderingControlProxy resetRenderingControl(Registry context, long pixelsID, RenderingEnginePrx re, RenderingDef def) throws RenderingServiceException, DSOutOfServiceException {
        if (!registry.equals(context)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy != null) {
            proxy.resetRenderingEngine(re, PixelsServicesFactory.convert(def));
        }
        return proxy;
    }

    public static void shutDownRenderingControl(Registry context, long pixelsID) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy != null) {
            proxy.shutDown();
            PixelsServicesFactory.singleton.rndSvcProxies.remove(pixelsID);
            PixelsServicesFactory.getCacheSize();
        }
    }

    public static void shutDownRenderingControls(Registry context) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        for (Map.Entry<Long, RenderingControl> entry : PixelsServicesFactory.singleton.rndSvcProxies.entrySet()) {
            ((RenderingControlProxy)entry.getValue()).shutDown();
        }
        PixelsServicesFactory.singleton.rndSvcProxies.clear();
    }

    public static RenderingControl getRenderingControl(Registry context, Long pixelsID) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        return PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
    }

    public static DataSink createDataSink(PixelsData pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("Pixels cannot be null.");
        }
        if (PixelsServicesFactory.singleton.pixelsSource != null && PixelsServicesFactory.singleton.pixelsSource.isSame(pixels.getId())) {
            return PixelsServicesFactory.singleton.pixelsSource;
        }
        registry.getCacheService().clearAllCaches();
        int size = PixelsServicesFactory.getCacheSize();
        if (size <= 0) {
            size = 0;
        }
        PixelsServicesFactory.singleton.pixelsSource = DataSink.makeNew(pixels, registry, size);
        return PixelsServicesFactory.singleton.pixelsSource;
    }

    public static void shutDownDataSink(Registry context, long pixelsID) {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        if (PixelsServicesFactory.singleton.pixelsSource != null && PixelsServicesFactory.singleton.pixelsSource.isSame(pixelsID)) {
            int size = PixelsServicesFactory.getCacheSize();
            boolean cacheInMemory = true;
            if (size <= 0) {
                cacheInMemory = false;
            }
            PixelsServicesFactory.singleton.pixelsSource.clearCache();
            PixelsServicesFactory.singleton.pixelsSource.setCacheInMemory(cacheInMemory);
        }
    }

    public static BufferedImage render(Registry context, Long pixelsID, PlaneDef pDef) throws RenderingServiceException, DSOutOfServiceException {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy == null) {
            throw new RuntimeException("No rendering service initialized for the specified pixels set.");
        }
        return proxy.renderPlane(pDef);
    }

    public static BufferedImage renderProjected(Registry context, Long pixelsID, int startZ, int endZ, int type, int stepping, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        if (!context.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        RenderingControlProxy proxy = (RenderingControlProxy)PixelsServicesFactory.singleton.rndSvcProxies.get(pixelsID);
        if (proxy == null) {
            throw new RuntimeException("No rendering service initialized for the specified pixels set.");
        }
        return proxy.renderProjected(startZ, endZ, stepping, type, channels);
    }

    static final float getCompressionQuality(int compressionLevel) {
        switch (compressionLevel) {
            default: {
                Float value = (Float)registry.lookup("/services/RE/compressionMedium");
                return value.floatValue();
            }
            case 2: 
        }
        Float value = (Float)registry.lookup("/services/RE/compressionLow");
        return value.floatValue();
    }

    private PixelsServicesFactory() {
    }

    private RenderingControl makeNew(RenderingEnginePrx re, Pixels pixels, List metadata, int compression, RenderingDef def) {
        if (singleton == null) {
            throw new NullPointerException();
        }
        Long id = pixels.getId().getValue();
        RenderingControl rnd = PixelsServicesFactory.getRenderingControl(registry, id);
        if (rnd != null) {
            return rnd;
        }
        RndProxyDef proxyDef = PixelsServicesFactory.convert(def);
        rnd = new RenderingControlProxy(registry, re, pixels, metadata, compression, proxyDef, PixelsServicesFactory.getCacheSize());
        PixelsServicesFactory.singleton.rndSvcProxies.put(id, rnd);
        return rnd;
    }

    private static int getCacheSize() {
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        maxSize = (int)(0.1 * (double)(usage.getMax() - usage.getUsed())) / 0x100000;
        int m = PixelsServicesFactory.singleton.rndSvcProxies.size();
        int n = 0;
        int sizeCache = 0;
        if (PixelsServicesFactory.singleton.pixelsSource != null) {
            n = 1;
        }
        if (n == 0 && m == 0) {
            return maxSize * 0x100000;
        }
        if (n == 0 && m > 0) {
            sizeCache = maxSize / (m + 1) * 0x100000;
            for (Map.Entry<Long, RenderingControl> entry : PixelsServicesFactory.singleton.rndSvcProxies.entrySet()) {
                RenderingControlProxy proxy = (RenderingControlProxy)entry.getValue();
                proxy.setCacheSize(sizeCache);
            }
            return sizeCache;
        }
        if (m == 0 && n > 0) {
            sizeCache = maxSize / (n + 1) * 0x100000;
            return sizeCache;
        }
        sizeCache = maxSize / (m + n + 1) * 0x100000;
        for (Map.Entry<Long, RenderingControl> entry : PixelsServicesFactory.singleton.rndSvcProxies.entrySet()) {
            RenderingControlProxy proxy = (RenderingControlProxy)entry.getValue();
            proxy.setCacheSize(sizeCache);
        }
        return sizeCache;
    }
}

