/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.login.LoginConfig;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.init.InitializationListener;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;
import org.openmicroscopy.shoola.env.ui.SplashScreen;
import org.openmicroscopy.shoola.env.ui.UIFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public final class SplashScreenInit
extends InitializationTask
implements InitializationListener {
    private SplashScreen splashScreen;
    private int totalTasks;

    SplashScreenInit() {
    }

    String getName() {
        return "";
    }

    void configure() {
        this.initializer.register(this);
    }

    void execute() throws StartupException {
        this.splashScreen = UIFactory.makeSplashScreen(this.container);
        this.splashScreen.open();
        this.splashScreen.setTotalTasks(this.totalTasks);
    }

    void rollback() {
    }

    public void onStart(int totalTasks) {
        this.totalTasks = totalTasks;
    }

    public void onExecute(String taskName) {
        if (this.splashScreen != null) {
            this.splashScreen.updateProgress(taskName);
        }
    }

    public void onEnd() {
        this.splashScreen.updateProgress("");
        Registry reg = this.container.getRegistry();
        Boolean b = (Boolean)reg.lookup("/services/SERVER/available");
        if (!b.booleanValue()) {
            this.splashScreen.close();
            return;
        }
        LoginConfig cfg = new LoginConfig(reg);
        int max = cfg.getMaxRetry();
        LoginService loginSvc = (LoginService)reg.lookup("/services/Login");
        int index = max;
        UserNotifier un = UIFactory.makeUserNotifier(this.container);
        while (0 < max--) {
            UserCredentials uc = this.splashScreen.getUserCredentials(max == index - 1);
            switch (loginSvc.login(uc)) {
                case 1: {
                    reg.bind("/user/credentials", uc);
                    max = 0;
                    break;
                }
                case 2: {
                    this.splashScreen.notifyLoginTimeout();
                    break;
                }
                case 0: {
                    if (max != 0) {
                        this.splashScreen.notifyLoginFailure(loginSvc.getLoginFailureIndex());
                        break;
                    }
                    if (max != 0) break;
                    un.notifyError("Login Failure", "A valid connection to the OMERO server could not be established. \nThe application will exit.");
                    this.container.exit();
                }
            }
        }
        this.splashScreen.close();
    }
}

