/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;

public final class AgentsInit
extends InitializationTask {
    private void createAgent(AgentInfo info) throws StartupException {
        if (!info.isActive()) {
            return;
        }
        try {
            Class<?> agentClass = Class.forName(info.getAgentClass());
            if (!Agent.class.isAssignableFrom(agentClass)) {
                throw new Exception(agentClass + "'s type is not Agent.");
            }
            Object agentInstance = agentClass.newInstance();
            Registry reg = this.createAgentRegistry(info.getConfigPath());
            info.setAgent((Agent)agentInstance);
            info.setRegistry(reg);
        }
        catch (Exception e) {
            throw new StartupException("Couldn't create agent: " + info.getName(), e);
        }
    }

    private Registry createAgentRegistry(String configFile) throws Exception {
        String absPathName = this.container.resolveConfigFile(configFile);
        Registry agentReg = RegistryFactory.makeNew(absPathName);
        Registry containerReg = this.container.getRegistry();
        RegistryFactory.linkEventBus(containerReg.getEventBus(), agentReg);
        RegistryFactory.linkLogger(containerReg.getLogger(), agentReg);
        RegistryFactory.linkIS(containerReg.getImageService(), agentReg);
        RegistryFactory.linkTaskBar(containerReg.getTaskBar(), agentReg);
        RegistryFactory.linkUserNotifier(containerReg.getUserNotifier(), agentReg);
        RegistryFactory.linkOS(containerReg.getDataService(), agentReg);
        RegistryFactory.linkMS(containerReg.getMetadataService(), agentReg);
        return agentReg;
    }

    String getName() {
        return "Loading Agents";
    }

    void configure() {
    }

    void execute() throws StartupException {
        Registry reg = this.container.getRegistry();
        List agents = (List)reg.lookup("/agents");
        Iterator i = agents.iterator();
        while (i.hasNext()) {
            this.createAgent((AgentInfo)i.next());
        }
    }

    void rollback() {
    }
}

