/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailSetLoader
extends BatchCallTree {
    private static final int FETCH_SIZE = 10;
    private static final double FETCH_LOW_SPEED = 0.25;
    private static final double FETCH_MEDIUM_SPEED = 0.5;
    private OmeroImageService service;
    private int maxLength;
    private List<List> toHandle;
    private Map<Long, ImageData> input;
    private List notValid;
    private Object currentThumbs;
    private int fetchSize;

    private BufferedImage createDefaultImage(ImageData data) {
        PixelsData pxd = null;
        try {
            pxd = data.getDefaultPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pxd == null) {
            return Factory.createDefaultImageThumbnail();
        }
        Dimension d = Factory.computeThumbnailSize(this.maxLength, this.maxLength, pxd.getSizeX(), pxd.getSizeY());
        return Factory.createDefaultImageThumbnail(d.width, d.height);
    }

    private void computeFetchSize() {
        int value = -1;
        Object fSize = this.context.lookup("/services/Thumbnailing/fetchSz");
        if (fSize != null && fSize instanceof Integer) {
            value = (Integer)fSize;
        } else {
            this.context.getLogger().warn((Object)this, "Thumbnail fetching size not set");
        }
        if (value <= 0) {
            value = 10;
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        double f = 0.0;
        Object fSpeed = null;
        switch (uc.getSpeedLevel()) {
            case 1: {
                fSpeed = this.context.lookup("/services/Thumbnailing/fetchMediumSpeed");
                if (fSpeed != null && fSpeed instanceof Double) {
                    f = (Double)fSpeed;
                } else {
                    this.context.getLogger().warn((Object)this, "Thumbnail fetching factor not set");
                }
                if (f <= 0.0 || f > 1.0) {
                    f = 0.5;
                }
                this.fetchSize = (int)((double)value * f);
                break;
            }
            case 2: {
                fSpeed = this.context.lookup("/services/Thumbnailing/fetchSz");
                if (fSpeed != null && fSpeed instanceof Double) {
                    f = (Double)fSpeed;
                } else {
                    this.context.getLogger().warn((Object)this, "Thumbnail fetching factor not set");
                }
                if (f <= 0.0 || f > 1.0) {
                    f = 0.25;
                }
                this.fetchSize = (int)((double)value * f);
                break;
            }
            default: {
                this.fetchSize = value;
            }
        }
    }

    private void loadThumbails(List ids) {
        try {
            Map<Long, BufferedImage> m = this.service.getThumbnailSet(ids, this.maxLength);
            ArrayList<ThumbnailData> result = new ArrayList<ThumbnailData>();
            Iterator<Long> i = m.keySet().iterator();
            boolean valid = true;
            while (i.hasNext()) {
                long pixelsID = i.next();
                ImageData image = this.input.get(pixelsID);
                BufferedImage thumbPix = m.get(pixelsID);
                if (thumbPix == null) {
                    valid = false;
                    thumbPix = this.createDefaultImage(image);
                }
                result.add(new ThumbnailData(image.getId(), thumbPix, valid));
            }
            this.currentThumbs = result;
        }
        catch (RenderingServiceException e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail: " + e.getExtendedMessage());
        }
    }

    @Override
    protected void buildTree() {
        Iterator<List> i = this.toHandle.iterator();
        String description = "Loading collection of thumbnails";
        while (i.hasNext()) {
            List l;
            final List ids = l = i.next();
            this.add(new BatchCall(description){

                public void doCall() {
                    ThumbnailSetLoader.this.loadThumbails(ids);
                }
            });
        }
        this.currentThumbs = this.notValid;
    }

    @Override
    protected Object getPartialResult() {
        return this.currentThumbs;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    public ThumbnailSetLoader(Collection<ImageData> images, int maxLength) {
        if (images == null) {
            throw new NullPointerException("No images.");
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxLength + ".");
        }
        this.computeFetchSize();
        this.maxLength = maxLength;
        this.service = this.context.getImageService();
        this.toHandle = new ArrayList<List>();
        this.input = new HashMap<Long, ImageData>();
        this.notValid = new ArrayList();
        Iterator<ImageData> i = images.iterator();
        int index = 0;
        ArrayList<Long> l = null;
        PixelsData pxd = null;
        while (i.hasNext()) {
            ImageData img = i.next();
            try {
                pxd = img.getDefaultPixels();
                this.input.put(pxd.getId(), img);
                if (index == 0) {
                    l = new ArrayList<Long>();
                }
                if (index >= this.fetchSize) continue;
                l.add(pxd.getId());
                if (++index != this.fetchSize) continue;
                this.toHandle.add(l);
                index = 0;
                l = null;
            }
            catch (Exception e) {
                this.notValid.add(new ThumbnailData(img.getId(), this.createDefaultImage(img), false));
            }
        }
        if (l != null && l.size() > 0) {
            this.toHandle.add(l);
        }
    }
}

