/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.List;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagesImporter
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final DataObject container, final List<Object> images, final long userID, final long groupID) {
        return new BatchCall("Importing images: "){

            public void doCall() throws Exception {
                OmeroImageService os = ImagesImporter.this.context.getImageService();
                ImagesImporter.this.results = os.importImages(container, images, userID, groupID);
            }
        };
    }

    private BatchCall makeBatchCall(final DataObject container, final File directory, final long userID, final long groupID) {
        return new BatchCall("Importing images: "){

            public void doCall() throws Exception {
                OmeroImageService os = ImagesImporter.this.context.getImageService();
                ImagesImporter.this.results = os.monitor(directory.getAbsolutePath(), container, userID, groupID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.results;
    }

    public ImagesImporter(DataObject container, List<Object> images, long userID, long groupID) {
        if (images == null || images.size() == 0) {
            throw new IllegalArgumentException("No images to import.");
        }
        this.loadCall = this.makeBatchCall(container, images, userID, groupID);
    }

    public ImagesImporter(DataObject container, File directory, long userID, long groupID) {
        if (directory == null) {
            throw new IllegalArgumentException("No directory to monitor.");
        }
        this.loadCall = this.makeBatchCall(container, directory, userID, groupID);
    }
}

