/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.HashMap;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.FileAnnotationData;

public class FilesLoader
extends BatchCallTree {
    private BatchCall loadCall;
    private Object result;

    private BatchCall makeBatchCall(final File file, final long fileID, final long size) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FilesLoader.this.result = service.downloadFile(file, fileID, size);
            }
        };
    }

    private BatchCall makeBatchCall(final long fileAnnotationID) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FileAnnotationData fa = (FileAnnotationData)service.loadAnnotation(fileAnnotationID);
                HashMap<FileAnnotationData, File> m = new HashMap<FileAnnotationData, File>();
                File f = service.downloadFile(new File(fa.getFileName()), fa.getFileID(), fa.getFileSize());
                m.put(fa, f);
                FilesLoader.this.result = m;
            }
        };
    }

    private BatchCall makeLoadFilesBatchCall(final int type, final long userID) {
        return new BatchCall("Downloading files."){

            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FilesLoader.this.result = service.loadFiles(type, userID);
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public FilesLoader(File file, long fileID, long size) {
        this.loadCall = file == null ? this.makeBatchCall(fileID) : this.makeBatchCall(file, fileID, size);
    }

    public FilesLoader(int type, long userID) {
        this.loadCall = this.makeLoadFilesBatchCall(type, userID);
    }
}

