/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.log.LogMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimenterImagesCounter
extends BatchCallTree {
    private long userID;
    private Map<Integer, Object> result;
    private Map<Integer, TimeRefObject> nodes;
    private OmeroDataService os;
    private OmeroMetadataService ms;

    private void countTimeItems(Integer index, Timestamp start, Timestamp end) {
        try {
            int number = -1;
            this.result = new HashMap<Integer, Object>(1);
            if (start == null || end == null) {
                Collection l = this.os.getImagesPeriod(start, end, this.userID, false);
                if (l != null) {
                    number = l.size();
                }
                this.result.put(index, number);
            } else {
                List l = this.os.getImagesAllPeriodCount(start, end, this.userID);
                this.result.put(index, l);
            }
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Cannot count the number of items imported during the specified period");
            msg.print(e);
            this.context.getLogger().error((Object)this, msg);
        }
    }

    private void countFileItems(Integer index, int type) {
        try {
            this.result = new HashMap<Integer, Object>();
            this.result.put(index, this.ms.countFileType(type));
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Cannot count the number of items imported during the specified period");
            msg.print(e);
            this.context.getLogger().error((Object)this, msg);
        }
    }

    private void countItems(Integer index, TimeRefObject ref) {
        switch (ref.getIndex()) {
            case 0: {
                this.countTimeItems(index, ref.getStartTime(), ref.getEndTime());
                break;
            }
            case 1: {
                this.countFileItems(index, ref.getFileType());
            }
        }
    }

    @Override
    protected void buildTree() {
        for (final Integer index : this.nodes.keySet()) {
            String description = "Count items";
            final TimeRefObject ref = this.nodes.get(index);
            this.add(new BatchCall(description){

                public void doCall() {
                    ExperimenterImagesCounter.this.countItems(index, ref);
                }
            });
        }
    }

    @Override
    protected Object getPartialResult() {
        return this.result;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    public ExperimenterImagesCounter(long userID, Map<Integer, TimeRefObject> m) {
        if (m == null || m.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        this.userID = userID;
        this.nodes = m;
        this.os = this.context.getDataService();
        this.ms = this.context.getMetadataService();
    }
}

