/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMRefreshLoader
extends BatchCallTree {
    private Map results;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final Class rootNodeType, final Map<Long, List> nodes) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = DMRefreshLoader.this.context.getDataService();
                Iterator users = nodes.keySet().iterator();
                DMRefreshLoader.this.results = new HashMap(nodes.size());
                while (users.hasNext()) {
                    Object result;
                    long userID = (Long)users.next();
                    List containers = (List)nodes.get(userID);
                    if (containers == null || containers.size() == 0) {
                        result = os.loadContainerHierarchy(rootNodeType, null, false, userID);
                    } else {
                        Set set = os.loadContainerHierarchy(rootNodeType, null, false, userID);
                        Iterator i = containers.iterator();
                        ArrayList<Long> ids = new ArrayList<Long>(containers.size());
                        while (i.hasNext()) {
                            ids.add(new Long(((DataObject)i.next()).getId()));
                        }
                        Iterator j = set.iterator();
                        HashSet<DataObject> children = null;
                        Class<DatasetData> klass = null;
                        HashMap topNodes = new HashMap(set.size());
                        while (j.hasNext()) {
                            HashSet newChildren = new HashSet();
                            DataObject parent = (DataObject)j.next();
                            if (parent instanceof ProjectData) {
                                children = ((ProjectData)parent).getDatasets();
                                klass = DatasetData.class;
                            } else if (parent instanceof DatasetData) {
                                children = new HashSet<DataObject>(1);
                                children.add(parent);
                                klass = DatasetData.class;
                            }
                            topNodes.put(parent, newChildren);
                            for (DataObject child : children) {
                                Long id = new Long(child.getId());
                                if (ids.contains(id)) {
                                    ArrayList<Long> cIds = new ArrayList<Long>(1);
                                    cIds.add(id);
                                    Set r = os.loadContainerHierarchy(klass, cIds, true, userID);
                                    Iterator k = r.iterator();
                                    while (k.hasNext()) {
                                        newChildren.add(k.next());
                                    }
                                    continue;
                                }
                                newChildren.add(child);
                            }
                        }
                        result = topNodes;
                    }
                    DMRefreshLoader.this.results.put(userID, result);
                }
            }
        };
    }

    private BatchCall makeImagesBatchCall(final Map<Long, List> nodes) {
        return new BatchCall("Loading images: "){

            public void doCall() throws Exception {
                OmeroDataService os = DMRefreshLoader.this.context.getDataService();
                Iterator users = nodes.keySet().iterator();
                while (users.hasNext()) {
                    long userID = (Long)users.next();
                    List containers = (List)nodes.get(userID);
                    for (TimeRefObject ref : containers) {
                        ref.setResults(os.getImagesPeriod(ref.getStartTime(), ref.getEndTime(), userID, true));
                    }
                }
                DMRefreshLoader.this.results = nodes;
            }
        };
    }

    private BatchCall makeFilesBatchCall(final Map<Long, List> nodes) {
        return new BatchCall("Loading files: "){

            public void doCall() throws Exception {
                OmeroMetadataService os = DMRefreshLoader.this.context.getMetadataService();
                Iterator users = nodes.keySet().iterator();
                while (users.hasNext()) {
                    long userID = (Long)users.next();
                    List containers = (List)nodes.get(userID);
                    for (TimeRefObject ref : containers) {
                        ref.setResults(os.loadFiles(ref.getFileType(), userID));
                    }
                }
                DMRefreshLoader.this.results = nodes;
            }
        };
    }

    private BatchCall makeTagsBatchCall(final Map<Long, List> nodes) {
        return new BatchCall("Loading files: "){

            public void doCall() throws Exception {
                OmeroMetadataService os = DMRefreshLoader.this.context.getMetadataService();
                Iterator users = nodes.keySet().iterator();
                DMRefreshLoader.this.results = new HashMap(nodes.size());
                while (users.hasNext()) {
                    long userID = (Long)users.next();
                    Collection result = os.loadTags(-1L, false, true, userID);
                    DMRefreshLoader.this.results.put(userID, result);
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.results;
    }

    public DMRefreshLoader(Class rootNodeType, Map<Long, List> nodes) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No container with images.");
        }
        if (ImageData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeImagesBatchCall(nodes);
        } else if (ProjectData.class.equals((Object)rootNodeType) || ScreenData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeBatchCall(rootNodeType, nodes);
        } else if (FileAnnotationData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeFilesBatchCall(nodes);
        } else if (TagAnnotationData.class.equals((Object)rootNodeType)) {
            this.loadCall = this.makeTagsBatchCall(nodes);
        }
    }
}

