/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerCounterLoader
extends BatchCallTree {
    private Map currentMap;
    private BatchCall loadCall;

    private BatchCall makeBatchCall(final List<Long> ids, final Class type) {
        return new BatchCall("Counting items."){

            public void doCall() throws Exception {
                OmeroDataService os = ContainerCounterLoader.this.context.getDataService();
                ContainerCounterLoader.this.currentMap = os.getCollectionCount(type, "images", ids);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.currentMap;
    }

    public ContainerCounterLoader(Set<DataObject> rootIDs) {
        if (rootIDs == null) {
            throw new NullPointerException("No root nodes.");
        }
        Iterator<DataObject> i = rootIDs.iterator();
        Long id = null;
        Class<DatasetData> rootType = null;
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            DataObject root = i.next();
            if (root instanceof DatasetData) {
                rootType = DatasetData.class;
                id = ((DatasetData)root).getId();
            } else if (root instanceof TagAnnotationData) {
                rootType = TagAnnotationData.class;
                id = ((TagAnnotationData)root).getId();
            }
            if (id == null) continue;
            ids.add(id);
        }
        this.loadCall = this.makeBatchCall(ids, rootType);
    }
}

