/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.ExperimenterData;

public class AdminLoader
extends BatchCallTree {
    public static final int SPACE = 1;
    private Object result;
    private BatchCall loadCall;

    private BatchCall availableSpaceCall(long userID) {
        return new BatchCall("Loading disk space information"){

            public void doCall() throws Exception {
                OmeroDataService os = AdminLoader.this.context.getDataService();
                ArrayList<Long> l = new ArrayList<Long>();
                l.add(os.getSpace(101));
                l.add(os.getSpace(100));
                AdminLoader.this.result = l;
            }
        };
    }

    private BatchCall changePassword(final String oldPassword, final String newPassword) {
        return new BatchCall("Change password"){

            public void doCall() throws Exception {
                OmeroDataService os = AdminLoader.this.context.getDataService();
                AdminLoader.this.result = os.changePassword(oldPassword, newPassword);
            }
        };
    }

    private BatchCall updateExperimenter(final ExperimenterData exp) {
        return new BatchCall("Update experimenter"){

            public void doCall() throws Exception {
                OmeroDataService os = AdminLoader.this.context.getDataService();
                AdminLoader.this.result = os.updateExperimenter(exp);
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public AdminLoader(long userID, int index) {
        switch (index) {
            case 1: {
                this.loadCall = this.availableSpaceCall(userID);
            }
        }
    }

    public AdminLoader(String oldPassword, String newPassword) {
        if (newPassword == null || newPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        if (oldPassword == null || oldPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        this.loadCall = this.changePassword(oldPassword, newPassword);
    }

    public AdminLoader(ExperimenterData exp) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter not valid.");
        }
        this.loadCall = this.updateExperimenter(exp);
    }
}

