/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.io.File;
import java.util.List;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.calls.AcquisitionDataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.AcquisitionDataSaver;
import org.openmicroscopy.shoola.env.data.views.calls.Analyser;
import org.openmicroscopy.shoola.env.data.views.calls.ChannelMetadataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.EnumerationLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ImageRenderer;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesImporter;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.PixelsDataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.PlaneInfoLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ProjectionSaver;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingControlLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingSettingsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingSettingsSaver;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import pojos.DataObject;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageDataViewImpl
implements ImageDataView {
    ImageDataViewImpl() {
    }

    @Override
    public CallHandle loadChannelMetadata(long imageID, AgentEventListener observer) {
        ChannelMetadataLoader cmd = new ChannelMetadataLoader(imageID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadRenderingControl(long pixelsID, int index, AgentEventListener observer) {
        int i = -1;
        switch (index) {
            default: {
                i = 0;
                break;
            }
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
            }
        }
        RenderingControlLoader cmd = new RenderingControlLoader(pixelsID, i);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle render(long pixelsID, PlaneDef pd, AgentEventListener observer) {
        ImageRenderer cmd = new ImageRenderer(pixelsID, pd);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPixels(long pixelsID, AgentEventListener observer) {
        PixelsDataLoader cmd = new PixelsDataLoader(pixelsID, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle analyseShapes(PixelsData pixels, List channels, List shapes, AgentEventListener observer) {
        Analyser cmd = new Analyser(pixels, channels, shapes);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getRenderingSettings(long pixelsID, AgentEventListener observer) {
        return this.getRenderingSettings(pixelsID, -1L, observer);
    }

    @Override
    public CallHandle getRenderingSettings(long pixelsID, long userID, AgentEventListener observer) {
        RenderingSettingsLoader cmd = new RenderingSettingsLoader(pixelsID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle renderProjected(long pixelsID, int startZ, int endZ, int stepping, int algorithm, List<Integer> channels, AgentEventListener observer) {
        ProjectionSaver cmd = new ProjectionSaver(pixelsID, startZ, endZ, stepping, algorithm, channels);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle projectImage(ProjectionParam ref, AgentEventListener observer) {
        ProjectionSaver cmd = new ProjectionSaver(ref);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createRndSetting(long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(pixelsID, rndToCopy, indexes);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadAcquisitionData(Object refObject, AgentEventListener observer) {
        AcquisitionDataLoader cmd = new AcquisitionDataLoader(refObject);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle saveAcquisitionData(Object refObject, AgentEventListener observer) {
        AcquisitionDataSaver cmd = new AcquisitionDataSaver(refObject);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPlaneInfo(long pixelsID, AgentEventListener observer) {
        PlaneInfoLoader cmd = new PlaneInfoLoader(pixelsID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadChannelMetadataEnumerations(AgentEventListener observer) {
        EnumerationLoader cmd = new EnumerationLoader(1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImageMetadataEnumerations(AgentEventListener observer) {
        EnumerationLoader cmd = new EnumerationLoader(0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle importImages(DataObject container, List<Object> images, long userID, long groupID, AgentEventListener observer) {
        ImagesImporter cmd = new ImagesImporter(container, images, userID, groupID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle monitorDirectory(File directory, DataObject container, long userID, long groupID, AgentEventListener observer) {
        ImagesImporter cmd = new ImagesImporter(container, directory, userID, groupID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImage(long imageID, long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(imageID, userID);
        return cmd.exec(observer);
    }
}

