/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.calls.AdminLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ChannelMetadataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ContainerCounterLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DMLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DMRefreshLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DataObjectRemover;
import org.openmicroscopy.shoola.env.data.views.calls.DataObjectSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ExistingObjectsSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ExperimenterImagesCounter;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.PlateWellsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.TagsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ThumbnailLoader;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataManagerViewImpl
implements DataManagerView {
    DataManagerViewImpl() {
    }

    @Override
    public CallHandle loadContainerHierarchy(Class rootNodeType, List<Long> rootNodeIDs, boolean withLeaves, long userID, AgentEventListener observer) {
        DMLoader cmd = new DMLoader(rootNodeType, rootNodeIDs, withLeaves, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImages(long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getImages(Class nodeType, List nodeIDs, long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(nodeType, nodeIDs, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createDataObject(DataObject userObject, DataObject parent, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(userObject, parent, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle countContainerItems(Set rootIDs, AgentEventListener observer) {
        ContainerCounterLoader cmd = new ContainerCounterLoader(rootIDs);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadThumbnail(ImageData image, int maxWidth, int maxHeight, long userID, AgentEventListener observer) {
        ThumbnailLoader cmd = new ThumbnailLoader(image, maxWidth, maxHeight, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle addExistingObjects(DataObject parent, Set children, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(parent, children);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle addExistingObjects(Map toPaste, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(toPaste, null);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle cutAndPaste(Map toPaste, Map toCut, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(toPaste, toCut);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadChannelsData(long pixelsID, AgentEventListener observer) {
        ChannelMetadataLoader cmd = new ChannelMetadataLoader(pixelsID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle changePassword(String oldPassword, String newPassword, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(oldPassword, newPassword);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle updateExperimenter(ExperimenterData exp, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(exp);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getDiskSpace(long userID, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(userID, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle refreshHierarchy(Class rootNodeType, Map<Long, List> m, AgentEventListener observer) {
        DMRefreshLoader cmd = new DMRefreshLoader(rootNodeType, m);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle countExperimenterImages(long userID, Map<Integer, TimeRefObject> m, AgentEventListener observer) {
        ExperimenterImagesCounter cmd = new ExperimenterImagesCounter(userID, m);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadTags(Long id, boolean dataObject, boolean topLevel, long userID, AgentEventListener observer) {
        TagsLoader cmd = new TagsLoader(id, dataObject, topLevel, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadPlateWells(long plateID, long userID, AgentEventListener observer) {
        PlateWellsLoader cmd = new PlateWellsLoader(plateID, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle delete(Collection<DeletableObject> values, AgentEventListener observer) {
        DataObjectRemover cmd = new DataObjectRemover(values);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle delete(DeletableObject value, AgentEventListener observer) {
        DataObjectRemover cmd = new DataObjectRemover(value);
        return cmd.exec(observer);
    }
}

