/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.sql.Timestamp;
import java.util.List;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.util.SearchDataContext;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.calls.ArchivedFilesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.FilesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ObjectFinder;
import org.openmicroscopy.shoola.env.data.views.calls.RenderingSettingsSaver;
import org.openmicroscopy.shoola.env.event.AgentEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHandlerViewImpl
implements DataHandlerView {
    @Override
    public CallHandle loadArchivedFiles(String location, long pixelsID, AgentEventListener observer) {
        ArchivedFilesLoader cmd = new ArchivedFilesLoader(location, pixelsID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImages(Timestamp startTime, Timestamp endTime, long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(startTime, endTime, userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle pasteRndSettings(long pixelsID, Class rootNodeType, List<Long> ids, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(pixelsID, rootNodeType, ids);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle pasteRndSettings(long pixelsID, TimeRefObject ref, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(pixelsID, ref);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle resetRndSettings(Class rootNodeType, List<Long> ids, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(rootNodeType, ids, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle resetRndSettings(TimeRefObject ref, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(ref, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle setRndSettings(Class rootNodeType, List<Long> ids, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(rootNodeType, ids, 2);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle setRndSettings(TimeRefObject ref, AgentEventListener observer) {
        RenderingSettingsSaver cmd = new RenderingSettingsSaver(ref, 2);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle advancedSearchFor(SearchDataContext context, AgentEventListener observer) {
        ObjectFinder cmd = new ObjectFinder(context);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadFiles(int type, long userID, AgentEventListener observer) {
        FilesLoader cmd = new FilesLoader(type, userID);
        return cmd.exec(observer);
    }
}

