/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.sql.Timestamp;
import java.util.List;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDataContext {
    public static final int TEXT_ANNOTATION = 0;
    public static final int TAGS = 1;
    public static final int NAME = 2;
    public static final int FILE_ANNOTATION = 3;
    public static final int URL_ANNOTATION = 4;
    public static final int DESCRIPTION = 5;
    public static final int CREATION_TIME = 0;
    public static final int MODIFICATION_TIME = 1;
    public static final int ANNOTATION_TIME = 2;
    public static final int EXCLUDE_OWNER = 102;
    public static final int EXCLUDE_ANNOTATOR = 103;
    private int timeIndex;
    private boolean unionOfContexts;
    private boolean caseSensitive;
    private Timestamp start;
    private Timestamp end;
    private List<Integer> scope;
    private List<Class> types;
    private String[] some;
    private String[] must;
    private String[] none;
    private List<ExperimenterData> owners;
    private List<ExperimenterData> annotators;
    private List<ExperimenterData> excludedOwners;
    private List<ExperimenterData> excludedAnnotators;
    private int numberOfResults;

    public SearchDataContext(List<Integer> scope, List<Class> types, String[] some, String[] must, String[] none) {
        if (some == null && must == null && none == null) {
            throw new IllegalArgumentException("No terms to search for.");
        }
        this.some = some;
        this.must = must;
        this.none = none;
        this.scope = scope;
        this.types = types;
        this.numberOfResults = -1;
        this.unionOfContexts = true;
    }

    public void setUnionOfContexts(boolean unionOfContexts) {
        this.unionOfContexts = unionOfContexts;
    }

    public boolean isUnionOfContexts() {
        return this.unionOfContexts;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setTimeInterval(Timestamp start, Timestamp end) {
        this.start = start;
        this.end = end;
    }

    public Timestamp getStart() {
        return this.start;
    }

    public Timestamp getEnd() {
        return this.end;
    }

    public List<Integer> getScope() {
        return this.scope;
    }

    public List<Class> getTypes() {
        return this.types;
    }

    public String[] getSome() {
        return this.some;
    }

    public String[] getMust() {
        return this.must;
    }

    public String[] getNone() {
        return this.none;
    }

    public boolean isValid() {
        return true;
    }

    public void setTimeIndex(int index) {
        switch (index) {
            case 0: 
            case 1: {
                this.timeIndex = index;
                break;
            }
            default: {
                this.timeIndex = -1;
            }
        }
    }

    public int getTimeIndex() {
        return this.timeIndex;
    }

    public List<ExperimenterData> getOwners() {
        return this.owners;
    }

    public List<ExperimenterData> getAnnotators() {
        return this.annotators;
    }

    public List<ExperimenterData> getExcludedOwners() {
        return this.excludedOwners;
    }

    public List<ExperimenterData> getExcludedAnnotators() {
        return this.excludedAnnotators;
    }

    public void setOwners(List<ExperimenterData> users) {
        this.owners = users;
    }

    public void setExcludedOwners(List<ExperimenterData> users) {
        this.excludedOwners = users;
    }

    public void setAnnotators(List<ExperimenterData> users) {
        this.annotators = users;
    }

    public void setExcludedAnnotators(List<ExperimenterData> users) {
        this.excludedAnnotators = users;
    }

    public void setNumberOfResults(int results) {
        this.numberOfResults = results;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }
}

