/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RString;
import omero.model.BooleanAnnotation;
import omero.model.CommentAnnotation;
import omero.model.Dataset;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.FileAnnotation;
import omero.model.IObject;
import omero.model.Image;
import omero.model.LongAnnotation;
import omero.model.Pixels;
import omero.model.Plate;
import omero.model.Project;
import omero.model.Screen;
import omero.model.TagAnnotation;
import omero.model.TimestampAnnotation;
import omero.model.UriAnnotation;
import omero.model.Well;
import omero.model.WellSample;
import pojos.BooleanAnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.LongAnnotationData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.RatingAnnotationData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;
import pojos.TimeAnnotationData;
import pojos.URLAnnotationData;
import pojos.WellData;
import pojos.WellSampleData;

public class PojoMapper {
    private static Object convert(Object value) {
        if (value instanceof IObject) {
            return PojoMapper.asDataObject((IObject)value);
        }
        if (value instanceof Collection) {
            return PojoMapper.asDataObjects((Collection)value);
        }
        if (value instanceof Map) {
            return PojoMapper.asDataObjects((Map)value);
        }
        return null;
    }

    public static DataObject asDataObject(IObject object) {
        if (object == null) {
            throw new IllegalArgumentException("IObject cannot be null.");
        }
        if (object instanceof Project) {
            return new ProjectData((Project)object);
        }
        if (object instanceof Dataset) {
            return new DatasetData((Dataset)object);
        }
        if (object instanceof Image) {
            return new ImageData((Image)object);
        }
        if (object instanceof UriAnnotation) {
            return new URLAnnotationData((UriAnnotation)object);
        }
        if (object instanceof TagAnnotation) {
            return new TagAnnotationData((TagAnnotation)object);
        }
        if (object instanceof CommentAnnotation) {
            return new TextualAnnotationData((CommentAnnotation)object);
        }
        if (object instanceof LongAnnotation) {
            LongAnnotation ann = (LongAnnotation)object;
            RString ns = ann.getNs();
            if (ns != null) {
                if ("openmicroscopy.org/omero/insight/rating".equals(ns.getValue())) {
                    return new RatingAnnotationData(ann);
                }
                return new LongAnnotationData(ann);
            }
            return new LongAnnotationData(ann);
        }
        if (object instanceof FileAnnotation) {
            return new FileAnnotationData((FileAnnotation)object);
        }
        if (object instanceof BooleanAnnotation) {
            return new BooleanAnnotationData((BooleanAnnotation)object);
        }
        if (object instanceof TimestampAnnotation) {
            return new TimeAnnotationData((TimestampAnnotation)object);
        }
        if (object instanceof Pixels) {
            return new PixelsData((Pixels)object);
        }
        if (object instanceof Experimenter) {
            return new ExperimenterData((Experimenter)object);
        }
        if (object instanceof ExperimenterGroup) {
            return new GroupData((ExperimenterGroup)object);
        }
        if (object instanceof Screen) {
            return new ScreenData((Screen)object);
        }
        if (object instanceof Plate) {
            return new PlateData((Plate)object);
        }
        if (object instanceof Well) {
            return new WellData((Well)object);
        }
        if (object instanceof WellSample) {
            return new WellSampleData((WellSample)object);
        }
        return null;
    }

    public static Set asDataObjects(Collection objects) {
        if (objects == null) {
            return new HashSet();
        }
        HashSet<DataObject> set = new HashSet<DataObject>(objects.size());
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            DataObject data = PojoMapper.asDataObject((IObject)i.next());
            if (data == null) continue;
            set.add(data);
        }
        return set;
    }

    public static Set asDataObjects(List objects) {
        if (objects == null) {
            return new HashSet();
        }
        HashSet<DataObject> set = new HashSet<DataObject>(objects.size());
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            DataObject data = PojoMapper.asDataObject((IObject)i.next());
            if (data == null) continue;
            set.add(data);
        }
        return set;
    }

    public static Set asDataObjects(IObject[] objects) {
        HashSet<DataObject> set = new HashSet<DataObject>();
        if (objects == null) {
            return set;
        }
        for (int i = 0; i < objects.length; ++i) {
            DataObject data = PojoMapper.asDataObject(objects[i]);
            set.add(data);
        }
        return set;
    }

    public static Map asDataObjects(Map objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The map cannot be null.");
        }
        HashMap map = new HashMap(objects.size());
        Set set = objects.entrySet();
        Iterator i = set.iterator();
        Object convertedKey = null;
        Object convertedValue = null;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            convertedKey = PojoMapper.convert(key);
            convertedValue = PojoMapper.convert(value);
            map.put(convertedKey == null ? key : convertedKey, convertedValue == null ? value : convertedValue);
        }
        return map;
    }
}

