/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.util.Iterator;
import java.util.List;
import omero.RString;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.AnnotationAnnotationLinkI;
import omero.model.CommentAnnotation;
import omero.model.CommentAnnotationI;
import omero.model.Dataset;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetAnnotationLinkI;
import omero.model.DatasetI;
import omero.model.DatasetImageLink;
import omero.model.DatasetImageLinkI;
import omero.model.Experimenter;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.ImageAnnotationLinkI;
import omero.model.ImageI;
import omero.model.LongAnnotation;
import omero.model.LongAnnotationI;
import omero.model.Plate;
import omero.model.PlateAnnotationLink;
import omero.model.PlateAnnotationLinkI;
import omero.model.PlateI;
import omero.model.Project;
import omero.model.ProjectAnnotationLink;
import omero.model.ProjectAnnotationLinkI;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectDatasetLinkI;
import omero.model.ProjectI;
import omero.model.Screen;
import omero.model.ScreenAnnotationLink;
import omero.model.ScreenAnnotationLinkI;
import omero.model.ScreenI;
import omero.model.ScreenPlateLinkI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.model.UriAnnotation;
import omero.model.UriAnnotationI;
import omero.model.Well;
import omero.model.WellAnnotationLink;
import omero.model.WellAnnotationLinkI;
import omero.rtypes;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.RatingAnnotationData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;
import pojos.URLAnnotationData;

public class ModelMapper {
    public static void unloadCollections(IObject object) {
        if (object == null) {
            throw new IllegalArgumentException("The object mustn't be null.");
        }
        object.unloadCollections();
    }

    public static IObject unlinkChildFromParent(IObject child, IObject parent) {
        if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            List links = ((Image)child).copyDatasetLinks();
            Iterator i = links.iterator();
            DatasetImageLink link = null;
            long parentID = parent.getId().getValue();
            while (i.hasNext() && (link = (DatasetImageLink)i.next()).getParent().getId().getValue() != parentID) {
            }
            return link;
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            List links = ((Project)parent).copyDatasetLinks();
            Iterator i = links.iterator();
            ProjectDatasetLink link = null;
            long childID = child.getId().getValue();
            while (i.hasNext()) {
                link = (ProjectDatasetLink)i.next();
                if (link.getChild().getId().getValue() != childID) continue;
                return link;
            }
        }
        throw new IllegalArgumentException("Parent not supported.");
    }

    public static IObject linkParentToChild(IObject child, IObject parent) {
        if (parent == null) {
            return null;
        }
        if (child == null) {
            throw new IllegalArgumentException("Child cannotbe null.");
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            ProjectI unloadedProject = new ProjectI(parent.getId().getValue(), false);
            DatasetI unloadedDataset = new DatasetI(child.getId().getValue(), false);
            ProjectDatasetLinkI l = new ProjectDatasetLinkI();
            l.link((Project)unloadedProject, (Dataset)unloadedDataset);
            return l;
        }
        if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            DatasetI unloadedDataset = new DatasetI(parent.getId().getValue(), false);
            ImageI unloadedImage = new ImageI(child.getId().getValue(), false);
            DatasetImageLinkI l = new DatasetImageLinkI();
            l.link((Dataset)unloadedDataset, (Image)unloadedImage);
            return l;
        }
        if (parent instanceof Screen) {
            if (!(child instanceof Plate)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            ScreenI unloadedScreen = new ScreenI(parent.getId().getValue(), false);
            PlateI unloadedPlate = new PlateI(child.getId().getValue(), false);
            ScreenPlateLinkI l = new ScreenPlateLinkI();
            l.link((Screen)unloadedScreen, (Plate)unloadedPlate);
            return l;
        }
        if (parent instanceof TagAnnotation) {
            if (!(child instanceof TagAnnotation)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            RString ns = ((TagAnnotation)parent).getNs();
            if (ns == null || !"openmicroscopy.org/omero/insight/tagset".equals(ns.getValue())) {
                return null;
            }
            return ModelMapper.linkAnnotation(parent, (Annotation)((TagAnnotation)child));
        }
        return null;
    }

    public static void linkParentToNewChild(IObject child, IObject parent) {
        if (parent == null) {
            return;
        }
        if (child == null) {
            throw new IllegalArgumentException("Child cannotbe null.");
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Project p = (Project)parent;
            Dataset d = (Dataset)child;
            List l = d.copyProjectLinks();
            if (l == null) {
                return;
            }
            Iterator it = l.iterator();
            long id = p.getId().getValue();
            while (it.hasNext()) {
                ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                if (id != link.getParent().getId().getValue()) continue;
                p.addProjectDatasetLink(link);
            }
        } else if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Dataset p = (Dataset)parent;
            Image d = (Image)child;
            List l = d.copyDatasetLinks();
            if (l == null) {
                return;
            }
            Iterator it = l.iterator();
            long id = p.getId().getValue();
            while (it.hasNext()) {
                DatasetImageLink link = (DatasetImageLink)it.next();
                if (id != link.getParent().getId().getValue()) continue;
                p.addDatasetImageLink(link);
            }
        } else {
            throw new IllegalArgumentException("DataObject not supported.");
        }
    }

    public static IObject createIObject(DataObject child, DataObject parent) {
        if (child instanceof ProjectData) {
            ProjectData data = (ProjectData)child;
            ProjectI model = new ProjectI();
            model.setName(rtypes.rstring((String)data.getName()));
            model.setDescription(rtypes.rstring((String)data.getDescription()));
            return model;
        }
        if (child instanceof DatasetData) {
            DatasetData data = (DatasetData)child;
            DatasetI model = new DatasetI();
            model.setName(rtypes.rstring((String)data.getName()));
            model.setDescription(rtypes.rstring((String)data.getDescription()));
            if (parent != null) {
                model.linkProject((Project)new ProjectI(Long.valueOf(parent.getId()).longValue(), false));
            }
            return model;
        }
        if (child instanceof ImageData) {
            if (!(parent instanceof DatasetData)) {
                throw new IllegalArgumentException("Parent not valid.");
            }
            ImageData data = (ImageData)child;
            ImageI model = new ImageI();
            model.setName(rtypes.rstring((String)data.getName()));
            model.setDescription(rtypes.rstring((String)data.getDescription()));
            model.linkDataset((Dataset)new DatasetI(Long.valueOf(parent.getId()).longValue(), false));
            return model;
        }
        if (child instanceof ScreenData) {
            ScreenData data = (ScreenData)child;
            ScreenI model = new ScreenI();
            model.setName(rtypes.rstring((String)data.getName()));
            model.setDescription(rtypes.rstring((String)data.getDescription()));
            return model;
        }
        if (child instanceof TagAnnotationData) {
            return ModelMapper.createAnnotation((AnnotationData)((TagAnnotationData)child));
        }
        throw new IllegalArgumentException("Child and parent are not compatible.");
    }

    public static IObject removeIObject(IObject child, IObject parent) {
        if (child instanceof Dataset && parent instanceof Project) {
            Project mParent = (Project)parent;
            List s = mParent.copyDatasetLinks();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                mParent.removeProjectDatasetLink((ProjectDatasetLink)i.next());
            }
            return mParent;
        }
        throw new IllegalArgumentException("DataObject not supported.");
    }

    public static IObject createAnnotationAndLink(IObject annotatedObject, AnnotationData data) {
        Annotation annotation = ModelMapper.createAnnotation(data);
        if (annotation == null) {
            return null;
        }
        return ModelMapper.linkAnnotation(annotatedObject, annotation);
    }

    public static Annotation createAnnotation(AnnotationData data) {
        CommentAnnotationI annotation = null;
        if (data instanceof TextualAnnotationData) {
            annotation = new CommentAnnotationI();
            ((CommentAnnotation)annotation).setTextValue(rtypes.rstring((String)data.getContentAsString()));
        } else if (data instanceof RatingAnnotationData) {
            int rate = ((RatingAnnotationData)data).getRating();
            if (rate == 0) {
                return null;
            }
            annotation = new LongAnnotationI();
            annotation.setNs(rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
            ((LongAnnotation)annotation).setLongValue(rtypes.rlong((long)((Long)data.getContent())));
        } else if (data instanceof URLAnnotationData) {
            annotation = new UriAnnotationI();
            try {
                ((UriAnnotation)annotation).setTextValue(rtypes.rstring((String)data.getContentAsString()));
            }
            catch (Exception e) {
                return null;
            }
        } else if (data instanceof TagAnnotationData) {
            annotation = new TagAnnotationI();
            ((TagAnnotation)annotation).setTextValue(rtypes.rstring((String)data.getContentAsString()));
            annotation.setDescription(rtypes.rstring((String)((TagAnnotationData)data).getTagDescription()));
            String ns = data.getNameSpace();
            if (ns != null && ns.length() > 0) {
                annotation.setNs(rtypes.rstring((String)ns));
            }
        }
        return annotation;
    }

    public static IObject linkAnnotation(IObject annotatedObject, Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        if (annotatedObject instanceof Dataset) {
            Dataset m = (Dataset)annotatedObject;
            DatasetAnnotationLinkI l = new DatasetAnnotationLinkI();
            l.setParent(m);
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Image) {
            Image m = (Image)annotatedObject;
            ImageAnnotationLinkI l = new ImageAnnotationLinkI();
            l.setParent(m);
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Project) {
            Project m = (Project)annotatedObject;
            ProjectAnnotationLinkI l = new ProjectAnnotationLinkI();
            l.setParent(m);
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Annotation) {
            Annotation ann = (Annotation)annotatedObject;
            AnnotationAnnotationLinkI l = new AnnotationAnnotationLinkI();
            l.setParent(ann);
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Screen) {
            Screen m = (Screen)annotatedObject;
            ScreenAnnotationLinkI l = new ScreenAnnotationLinkI();
            l.setParent(m);
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Plate) {
            Plate m = (Plate)annotatedObject;
            PlateAnnotationLinkI l = new PlateAnnotationLinkI();
            l.setParent(m);
            l.setChild(annotation);
            return l;
        }
        if (annotatedObject instanceof Well) {
            Well m = (Well)annotatedObject;
            WellAnnotationLinkI l = new WellAnnotationLinkI();
            l.setParent(m);
            l.setChild(annotation);
            return l;
        }
        return null;
    }

    public static void setAnnotatedObject(IObject annotated, IObject annotation) {
    }

    public static IObject getAnnotatedObject(IObject annotation) {
        if (annotation instanceof DatasetAnnotationLink) {
            return ((DatasetAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof ProjectAnnotationLink) {
            return ((ProjectAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof ImageAnnotationLink) {
            return ((ImageAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof AnnotationAnnotationLink) {
            return ((AnnotationAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof PlateAnnotationLink) {
            return ((PlateAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof ScreenAnnotationLink) {
            return ((ScreenAnnotationLink)annotation).getParent();
        }
        if (annotation instanceof WellAnnotationLink) {
            return ((WellAnnotationLink)annotation).getParent();
        }
        return null;
    }

    public static IObject getAnnotationObject(IObject annotation) {
        if (annotation instanceof DatasetAnnotationLink) {
            return ((DatasetAnnotationLink)annotation).getChild();
        }
        if (annotation instanceof ProjectAnnotationLink) {
            return ((ProjectAnnotationLink)annotation).getChild();
        }
        if (annotation instanceof ImageAnnotationLink) {
            return ((ImageAnnotationLink)annotation).getChild();
        }
        if (annotation instanceof PlateAnnotationLink) {
            return ((PlateAnnotationLink)annotation).getChild();
        }
        if (annotation instanceof ScreenAnnotationLink) {
            return ((ScreenAnnotationLink)annotation).getChild();
        }
        if (annotation instanceof WellAnnotationLink) {
            return ((WellAnnotationLink)annotation).getChild();
        }
        return null;
    }

    public static void fillIObject(IObject oldObject, IObject newObject) {
        if (oldObject == null || newObject == null) {
            throw new IllegalArgumentException("Object cannot be NULL.");
        }
        if (oldObject.getClass() != newObject.getClass()) {
            throw new IllegalArgumentException("Objects should be of the same type.");
        }
        if (oldObject instanceof Project) {
            Project n = (Project)newObject;
            Project o = (Project)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Dataset) {
            Dataset n = (Dataset)newObject;
            Dataset o = (Dataset)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Image) {
            Image n = (Image)newObject;
            Image o = (Image)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Experimenter) {
            Experimenter n = (Experimenter)newObject;
            Experimenter o = (Experimenter)oldObject;
            n.setEmail(o.getEmail());
            n.setFirstName(o.getFirstName());
            n.setLastName(o.getLastName());
            n.setInstitution(o.getInstitution());
        } else if (oldObject instanceof Screen) {
            Screen n = (Screen)newObject;
            Screen o = (Screen)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Plate) {
            Plate n = (Plate)newObject;
            Plate o = (Plate)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        }
    }
}

