/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterContext {
    public static final int RATE = 0;
    public static final int TAG = 1;
    public static final int COMMENT = 2;
    public static final int MULTI = 3;
    public static final int NONE = 4;
    public static final int HIGHER = 0;
    public static final int LOWER = 1;
    public static final int EQUAL = 2;
    public static final int UNION = 100;
    public static final int INTERSECTION = 101;
    private int rate = -1;
    private int index = -1;
    private Map<Class, List<String>> annotationType = new HashMap<Class, List<String>>();
    private Timestamp fromDate;
    private Timestamp toDate;
    private int resultType = 101;
    private List<Integer> type = new ArrayList<Integer>();

    public int getContext() {
        int size = this.type.size();
        if (size == 0) {
            return 4;
        }
        if (size > 1) {
            return 3;
        }
        return this.type.get(0);
    }

    public List<Integer> getContextList() {
        return this.type;
    }

    public void setResultType(int type) {
        switch (type) {
            case 100: 
            case 101: {
                this.resultType = type;
                break;
            }
            default: {
                this.resultType = 101;
            }
        }
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setRate(int index, int rate) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.index = index;
                break;
            }
            default: {
                this.index = 0;
            }
        }
        this.rate = rate;
        this.type.add(0);
    }

    public void setTimeInterval(Timestamp fromDate, Timestamp toDate) {
        if (fromDate != null && fromDate.after(toDate)) {
            this.fromDate = toDate;
            this.toDate = fromDate;
        } else {
            this.fromDate = fromDate;
            this.toDate = toDate;
        }
    }

    public Timestamp getFromDate() {
        return this.fromDate;
    }

    public Timestamp getToDate() {
        return this.toDate;
    }

    public int getRate() {
        return this.rate;
    }

    public int getIndex() {
        return this.index;
    }

    public Map<Class, List<String>> getAnnotationType() {
        return this.annotationType;
    }

    public List<String> getAnnotation(Class klass) {
        return this.annotationType.get(klass);
    }

    public void addAnnotationType(Class klass, List<String> terms) {
        if (klass != null && terms != null && terms.size() > 0) {
            if (klass.equals(TagAnnotationData.class)) {
                this.type.add(1);
            } else if (klass.equals(TextualAnnotationData.class)) {
                this.type.add(2);
            }
            this.annotationType.put(klass, terms);
        }
    }
}

