/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import omero.api.RenderingEnginePrx;
import omero.model.Channel;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.RenderingDef;
import omero.romio.PlaneDef;
import omero.rtypes;
import omero.sys.Parameters;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OmeroImageServiceImpl
implements OmeroImageService {
    private List<FileFilter> filters;
    private String[] supportedExtensions;
    private Registry context;
    private OMEROGateway gateway;

    private BufferedImage createImage(byte[] values) throws RenderingServiceException {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(values);
            return ImageIO.read(stream);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot create buffered image", e);
        }
    }

    OmeroImageServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    void shutDown() {
        PixelsServicesFactory.shutDownRenderingControls(this.context);
    }

    @Override
    public RenderingControl loadRenderingControl(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID));
        if (proxy == null) {
            int compressionLevel;
            UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
            switch (uc.getSpeedLevel()) {
                case 1: {
                    compressionLevel = 1;
                    break;
                }
                case 2: {
                    compressionLevel = 2;
                    break;
                }
                default: {
                    compressionLevel = 0;
                }
            }
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            RenderingEnginePrx re = this.gateway.createRenderingEngine(pixelsID);
            Pixels pixels = this.gateway.getPixels(pixelsID);
            RenderingDef def = this.gateway.getRenderingDef(pixelsID, exp.getId());
            List l = pixels.copyChannels();
            Iterator i = l.iterator();
            ArrayList<ChannelData> m = new ArrayList<ChannelData>(l.size());
            int index = 0;
            while (i.hasNext()) {
                m.add(new ChannelData(index, (Channel)i.next()));
                ++index;
            }
            proxy = PixelsServicesFactory.createRenderingControl(this.context, re, pixels, m, compressionLevel, def);
        }
        return proxy;
    }

    @Override
    public BufferedImage renderImage(long pixelsID, PlaneDef pDef) throws RenderingServiceException {
        try {
            return PixelsServicesFactory.render(this.context, new Long(pixelsID), pDef);
        }
        catch (Exception e) {
            throw new RenderingServiceException("RenderImage", e);
        }
    }

    @Override
    public void shutDown(long pixelsID) {
        this.gateway.removeREService(pixelsID);
        PixelsServicesFactory.shutDownRenderingControl(this.context, pixelsID);
    }

    @Override
    public void shutDownDataSink(long pixelsID) {
        PixelsServicesFactory.shutDownRenderingControl(this.context, pixelsID);
    }

    @Override
    public BufferedImage getThumbnail(long pixID, int sizeX, int sizeY, long userID) throws RenderingServiceException {
        try {
            if (pixID < 0L) {
                return null;
            }
            return this.createImage(this.gateway.getThumbnail(pixID, sizeX, sizeY, userID));
        }
        catch (Exception e) {
            if (e instanceof DSOutOfServiceException) {
                this.context.getLogger().error((Object)this, e.getMessage());
                return this.getThumbnail(pixID, sizeX, sizeY, userID);
            }
            throw new RenderingServiceException("Get Thumbnail", e);
        }
    }

    @Override
    public Map<Long, BufferedImage> getThumbnailSet(List pixelsID, int max) throws RenderingServiceException {
        try {
            HashMap<Long, BufferedImage> r = new HashMap<Long, BufferedImage>();
            if (pixelsID == null || pixelsID.size() == 0) {
                return r;
            }
            Map m = this.gateway.getThumbnailSet(pixelsID, max);
            if (m == null || m.size() == 0) {
                return r;
            }
            Iterator i = m.keySet().iterator();
            while (i.hasNext()) {
                long id = (Long)i.next();
                byte[] values = (byte[])m.get(id);
                if (values == null) {
                    r.put(id, null);
                    continue;
                }
                try {
                    r.put(id, this.createImage(values));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    r.put(id, null);
                }
            }
            return r;
        }
        catch (Exception e) {
            if (e instanceof DSOutOfServiceException) {
                this.context.getLogger().error((Object)this, e.getMessage());
                return this.getThumbnailSet(pixelsID, max);
            }
            throw new RenderingServiceException("Get Thumbnail set", e);
        }
    }

    @Override
    public RenderingControl reloadRenderingService(long pixelsID) throws RenderingServiceException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID));
        if (proxy == null) {
            return null;
        }
        try {
            RenderingEnginePrx re = this.gateway.createRenderingEngine(pixelsID);
            return PixelsServicesFactory.reloadRenderingControl(this.context, pixelsID, re);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot restart the rendering engine for : " + pixelsID, e);
        }
    }

    @Override
    public RenderingControl resetRenderingService(long pixelsID) throws RenderingServiceException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID));
        if (proxy == null) {
            return null;
        }
        try {
            RenderingEnginePrx re = this.gateway.createRenderingEngine(pixelsID);
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            RenderingDef def = this.gateway.getRenderingDef(pixelsID, exp.getId());
            return PixelsServicesFactory.resetRenderingControl(this.context, pixelsID, re, def);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot restart the rendering engine for : " + pixelsID, e);
        }
    }

    @Override
    public PixelsData loadPixels(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels' ID not valid.");
        }
        return (PixelsData)PojoMapper.asDataObject((IObject)this.gateway.getPixels(pixelsID));
    }

    @Override
    public byte[] getPlane(long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels' ID not valid.");
        }
        return this.gateway.getPlane(pixelsID, z, t, c);
    }

    public Map pasteRenderingSettings(long pixelsID, Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.pasteRenderingSettings(pixelsID, rootNodeType, nodesID);
    }

    public Map resetRenderingSettings(Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.resetRenderingSettings(rootNodeType, nodesID);
    }

    public Map setOriginalRenderingSettings(Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.setOriginalRenderingSettings(rootNodeType, nodesID);
    }

    @Override
    public Map getRenderingSettings(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        Map m = this.gateway.getRenderingSettings(pixelsID, userID);
        if (m == null) {
            return null;
        }
        Iterator i = m.keySet().iterator();
        HashMap results = new HashMap(m.size());
        while (i.hasNext()) {
            Object key = i.next();
            results.put(key, PixelsServicesFactory.convert((RenderingDef)m.get(key)));
        }
        return results;
    }

    @Override
    public BufferedImage renderProjected(long pixelsID, int startZ, int endZ, int stepping, int type, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        return PixelsServicesFactory.renderProjected(this.context, pixelsID, startZ, endZ, type, stepping, channels);
    }

    @Override
    public ImageData projectImage(ProjectionParam ref) throws DSOutOfServiceException, DSAccessException {
        if (ref == null) {
            return null;
        }
        ImageData image = this.gateway.projectImage(ref.getPixelsID(), ref.getStartT(), ref.getEndT(), ref.getStartZ(), ref.getEndZ(), ref.getStepping(), ref.getProjectionType(), ref.getChannels(), ref.getName(), ref.getPixelsType());
        if (image == null) {
            return null;
        }
        Image img = image.asImage();
        img.setDescription(rtypes.rstring((String)ref.getDescription()));
        image = (ImageData)PojoMapper.asDataObject(this.gateway.updateObject((IObject)img, new Parameters()));
        image = this.gateway.getImage(image.getId(), new Parameters());
        List<DatasetData> datasets = ref.getDatasets();
        if (datasets != null && datasets.size() > 0) {
            Iterator<Object> i = datasets.iterator();
            ArrayList<DatasetData> existing = new ArrayList<DatasetData>();
            ArrayList<DatasetData> toCreate = new ArrayList<DatasetData>();
            while (i.hasNext()) {
                DatasetData dataset = i.next();
                if (dataset.getId() > 0L) {
                    existing.add(dataset);
                    continue;
                }
                toCreate.add(dataset);
            }
            if (toCreate.size() > 0) {
                i = toCreate.iterator();
                OmeroDataService svc = this.context.getDataService();
                while (i.hasNext()) {
                    existing.add((DatasetData)svc.createDataObject((DataObject)i.next(), null, null));
                }
            }
            ArrayList<IObject> links = new ArrayList<IObject>(datasets.size());
            img = image.asImage();
            i = existing.iterator();
            while (i.hasNext()) {
                IObject l = ModelMapper.linkParentToChild((IObject)img, ((DatasetData)i.next()).asIObject());
                links.add(l);
            }
            this.gateway.createObjects(links);
        }
        return image;
    }

    @Override
    public Boolean createRenderingSettings(long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes) throws DSOutOfServiceException, DSAccessException {
        if (rndToCopy == null) {
            RenderingDef def = this.gateway.createRenderingDef(pixelsID);
            return def != null;
        }
        RenderingControl rndControl = this.loadRenderingControl(pixelsID);
        try {
            rndControl.copyRenderingSettings(rndToCopy, indexes);
            rndControl.saveCurrentSettings();
            this.shutDown(pixelsID);
        }
        catch (Exception e) {
            throw new DSAccessException("Unable to copy the rendering settings.");
        }
        return Boolean.TRUE;
    }

    @Override
    public Collection loadPlaneInfo(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        List<IObject> planes = this.gateway.loadPlaneInfo(pixelsID);
        return planes;
    }

    @Override
    public Object importImages(DataObject container, List<Object> images, long userID, long groupID) throws DSOutOfServiceException, DSAccessException {
        return new ArrayList();
    }

    @Override
    public List<FileFilter> getSupportedFileFilters() {
        if (this.filters != null) {
            return this.filters;
        }
        this.filters = new ArrayList<FileFilter>();
        return this.filters;
    }

    @Override
    public FileSystemView getFSFileSystemView() {
        String path = (String)this.context.lookup("/services/FS/defaultDirectory");
        return this.gateway.getFSFileSystemView(path);
    }

    @Override
    public Object monitor(String directory, DataObject container, long userID, long groupID) {
        if (this.supportedExtensions == null) {
            List<FileFilter> l = this.getSupportedFileFilters();
            Iterator<FileFilter> i = l.iterator();
            ArrayList<String> formats = new ArrayList<String>();
            String regEx = "\\*";
            while (i.hasNext()) {
                String description = i.next().getDescription();
                String[] terms = description.split(regEx);
                for (int j = 1; j < terms.length; ++j) {
                    String v = terms[j].trim();
                    if ((v = v.replaceAll(",", "")).endsWith(")")) {
                        v = v.substring(0, v.length() - 1);
                    }
                    formats.add(v);
                }
            }
            this.supportedExtensions = new String[formats.size()];
            Iterator k = formats.iterator();
            int index = 0;
            while (k.hasNext()) {
                this.supportedExtensions[index] = (String)k.next();
                ++index;
            }
        }
        this.gateway.monitor(directory, this.supportedExtensions, container);
        return true;
    }
}

