/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import Ice.ConnectionLostException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.filechooser.FileSystemView;
import ome.system.UpgradeCheck;
import omero.AuthenticationException;
import omero.ExpiredCredentialException;
import omero.InternalException;
import omero.RLong;
import omero.RType;
import omero.SecurityViolation;
import omero.ServerError;
import omero.SessionException;
import omero.api.IAdminPrx;
import omero.api.IContainerPrx;
import omero.api.IDeletePrx;
import omero.api.IMetadataPrx;
import omero.api.IPixelsPrx;
import omero.api.IProjectionPrx;
import omero.api.IQueryPrx;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRepositoryInfoPrx;
import omero.api.ISessionPrx;
import omero.api.IUpdatePrx;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.SearchPrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.client;
import omero.constants.projection.ProjectionType;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.BooleanAnnotation;
import omero.model.BooleanAnnotationI;
import omero.model.CommentAnnotation;
import omero.model.CommentAnnotationI;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.Format;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.LogicalChannel;
import omero.model.LongAnnotation;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.Pixels;
import omero.model.PixelsI;
import omero.model.PixelsType;
import omero.model.Plate;
import omero.model.PlateI;
import omero.model.Project;
import omero.model.ProjectI;
import omero.model.RenderingDef;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.model.TimestampAnnotation;
import omero.model.TimestampAnnotationI;
import omero.model.UriAnnotation;
import omero.model.UriAnnotationI;
import omero.model.Well;
import omero.model.WellSample;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import org.openmicroscopy.shoola.env.data.util.SearchDataContext;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import pojos.BooleanAnnotationData;
import pojos.ChannelAcquisitionData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.LongAnnotationData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.RatingAnnotationData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;
import pojos.TimeAnnotationData;
import pojos.URLAnnotationData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OMEROGateway {
    static final int LOST_CONNECTION = 0;
    static final int SERVER_OUT_OF_SERVICE = 1;
    private static final int INC = 262144;
    private static final int MAX_RETRIEVAL = 100;
    private static final List<Character> SUPPORTED_SPECIAL_CHAR = new ArrayList<Character>();
    private static final List<String> WILD_CARDS;
    private int thumbRetrieval;
    private ServiceFactoryPrx entry;
    private ThumbnailStorePrx thumbnailService;
    private RawFileStorePrx fileStore;
    private RawPixelsStorePrx pixelsStore;
    private IProjectionPrx projService;
    private SearchPrx searchService;
    private IAdminPrx adminService;
    private IQueryPrx queryService;
    private IRenderingSettingsPrx rndSettingsService;
    private IRepositoryInfoPrx repInfoService;
    private IDeletePrx deleteService;
    private IPixelsPrx pixelsService;
    private IContainerPrx pojosService;
    private IUpdatePrx updateService;
    private IMetadataPrx metadataService;
    private boolean connected;
    private DataServicesFactory dsFactory;
    private float compression;
    private int port;
    private String hostName;
    private client blitzClient;
    private Map<String, List<EnumerationObject>> enumerations;
    private List<ServiceInterfacePrx> services;
    private Map<Long, ServiceInterfacePrx> reServices;
    private FileSystemView systemView;
    private List<String> monitorIDs;

    private void handleException(Throwable t, String message) throws DSOutOfServiceException, DSAccessException {
        Throwable cause = t.getCause();
        if (cause instanceof SecurityViolation) {
            String s = "For security reasons, cannot access data. \n";
            throw new DSAccessException(s + message, t);
        }
        if (cause instanceof SessionException) {
            String s = "Session is not valid. \n";
            throw new DSOutOfServiceException(s + message, t);
        }
        if (cause instanceof AuthenticationException) {
            String s = "Cannot initialize the session. \n";
            throw new DSOutOfServiceException(s + message, t);
        }
        if (cause instanceof ExpiredCredentialException) {
            String s = "Cannot initialize the session. \n";
            throw new DSOutOfServiceException(s + message, t);
        }
        throw new DSAccessException("Cannot access data. \n" + message, t);
    }

    private String printErrorText(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private Object handleSearchResult(String type, Collection r, SearchPrx svc) throws ServerError {
        boolean hasNext = false;
        try {
            hasNext = svc.hasNext();
        }
        catch (Exception e) {
            int size = 0;
            if (e instanceof InternalException) {
                size = -1;
            } else {
                svc.getBatchSize();
            }
            return new Integer(size);
        }
        if (!hasNext) {
            return r;
        }
        List l = svc.results();
        for (IObject object : l) {
            long id;
            if (!type.equals(object.getClass().getName()) || r.contains(id = object.getId().getValue())) continue;
            r.add(id);
        }
        return r;
    }

    private List<String> formatText(List<String> terms, String field) {
        if (terms == null || terms.size() == 0) {
            return null;
        }
        ArrayList<String> formatted = new ArrayList<String>(terms.size());
        Iterator<String> j = terms.iterator();
        while (j.hasNext()) {
            formatted.add(field + ":" + j.next());
        }
        return formatted;
    }

    private List<String> formatText(List<String> terms, String firstField, String sep, String secondField) {
        if (terms == null || terms.size() == 0) {
            return null;
        }
        ArrayList<String> formatted = new ArrayList<String>(terms.size());
        for (String v : terms) {
            String value = firstField + ":" + v + " " + sep + " ";
            value = value + secondField + ":" + v;
            formatted.add(value);
        }
        return formatted;
    }

    private String getTableForLink(Class klass) {
        String table = null;
        if (Dataset.class.equals((Object)klass)) {
            table = "DatasetImageLink";
        } else if (DatasetI.class.equals((Object)klass)) {
            table = "DatasetImageLink";
        } else if (Project.class.equals((Object)klass)) {
            table = "ProjectDatasetLink";
        } else if (ProjectI.class.equals((Object)klass)) {
            table = "ProjectDatasetLink";
        } else if (Screen.class.equals((Object)klass)) {
            table = "ScreenPlateLink";
        } else if (ScreenI.class.equals((Object)klass)) {
            table = "ScreenPlateLink";
        } else if (TagAnnotation.class.equals((Object)klass)) {
            table = "AnnotationAnnotationLink";
        } else if (TagAnnotationI.class.equals((Object)klass)) {
            table = "AnnotationAnnotationLink";
        }
        return table;
    }

    private String getTableForAnnotationLink(String klass) {
        String table = null;
        if (klass == null) {
            return table;
        }
        if (klass.equals(Dataset.class.getName())) {
            table = "DatasetAnnotationLink";
        } else if (klass.equals(Project.class.getName())) {
            table = "ProjectAnnotationLink";
        } else if (klass.equals(Image.class.getName())) {
            table = "ImageAnnotationLink";
        } else if (klass.equals(Pixels.class.getName())) {
            table = "PixelAnnotationLink";
        } else if (klass.equals(Annotation.class.getName())) {
            table = "AnnotationAnnotationLink";
        } else if (klass.equals(DatasetData.class.getName())) {
            table = "DatasetAnnotationLink";
        } else if (klass.equals(ProjectData.class.getName())) {
            table = "ProjectAnnotationLink";
        } else if (klass.equals(ImageData.class.getName())) {
            table = "ImageAnnotationLink";
        } else if (klass.equals(PixelsData.class.getName())) {
            table = "PixelAnnotationLink";
        } else if (klass.equals(Screen.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(Plate.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(ScreenData.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(PlateData.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(DatasetI.class.getName())) {
            table = "DatasetAnnotationLink";
        } else if (klass.equals(ProjectI.class.getName())) {
            table = "ProjectAnnotationLink";
        } else if (klass.equals(ImageI.class.getName())) {
            table = "ImageAnnotationLink";
        } else if (klass.equals(PixelsI.class.getName())) {
            table = "PixelAnnotationLink";
        } else if (klass.equals(ScreenI.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(PlateI.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(ScreenData.class.getName())) {
            table = "ScreenAnnotationLink";
        } else if (klass.equals(PlateData.class.getName())) {
            table = "PlateAnnotationLink";
        } else if (klass.equals(TagAnnotationData.class.getName())) {
            table = "AnnotationAnnotationLink";
        }
        return table;
    }

    private String getTableForClass(Class klass) {
        if (DatasetData.class.equals((Object)klass)) {
            return "Dataset";
        }
        if (ProjectData.class.equals((Object)klass)) {
            return "Project";
        }
        if (ImageData.class.equals((Object)klass)) {
            return "Image";
        }
        if (ScreenData.class.equals((Object)klass)) {
            return "Screen";
        }
        if (PlateData.class.equals((Object)klass)) {
            return "Plate";
        }
        return null;
    }

    private String convertProperty(Class nodeType, String property) {
        if (nodeType.equals(DatasetData.class)) {
            if (property.equals("images")) {
                return "ome.model.containers.Dataset_imageLinks";
            }
        } else {
            throw new IllegalArgumentException("NodeType or property not supported");
        }
        return null;
    }

    public ISessionPrx getSessionService() throws DSAccessException, DSOutOfServiceException {
        try {
            return this.entry.getSessionService();
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Session service.");
            return null;
        }
    }

    private IRenderingSettingsPrx getRenderingSettingsService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.rndSettingsService == null) {
                this.rndSettingsService = this.entry.getRenderingSettingsService();
                this.services.add((ServiceInterfacePrx)this.rndSettingsService);
            }
            return this.rndSettingsService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RenderingSettings service.");
            return null;
        }
    }

    private IRepositoryInfoPrx getRepositoryService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.repInfoService == null) {
                this.repInfoService = this.entry.getRepositoryInfoService();
                this.services.add((ServiceInterfacePrx)this.repInfoService);
            }
            return this.repInfoService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RepositoryInfo service.");
            return null;
        }
    }

    private IContainerPrx getPojosService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.pojosService == null) {
                this.pojosService = this.entry.getContainerService();
                this.services.add((ServiceInterfacePrx)this.pojosService);
            }
            return this.pojosService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Pojos service.");
            return null;
        }
    }

    private IQueryPrx getQueryService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.queryService == null) {
                this.queryService = this.entry.getQueryService();
                this.services.add((ServiceInterfacePrx)this.queryService);
            }
            return this.queryService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Query service.");
            return null;
        }
    }

    private IUpdatePrx getUpdateService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.updateService == null) {
                this.updateService = this.entry.getUpdateService();
                this.services.add((ServiceInterfacePrx)this.updateService);
            }
            return this.updateService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Update service.");
            return null;
        }
    }

    private IMetadataPrx getMetadataService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.metadataService == null) {
                this.metadataService = this.entry.getMetadataService();
                this.services.add((ServiceInterfacePrx)this.metadataService);
            }
            return this.metadataService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Update service.");
            return null;
        }
    }

    private IAdminPrx getAdminService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.adminService == null) {
                this.adminService = this.entry.getAdminService();
                this.services.add((ServiceInterfacePrx)this.adminService);
            }
            return this.adminService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Admin service.");
            return null;
        }
    }

    private IDeletePrx getDeleteService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.deleteService == null) {
                this.deleteService = this.entry.getDeleteService();
                this.services.add((ServiceInterfacePrx)this.deleteService);
            }
            return this.deleteService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Delete service.");
            return null;
        }
    }

    private ThumbnailStorePrx getThumbService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.thumbRetrieval == 100) {
                this.thumbRetrieval = 0;
                if (this.thumbnailService != null) {
                    this.thumbnailService.close();
                }
                this.services.remove(this.thumbnailService);
                this.thumbnailService = null;
            }
            if (this.thumbnailService == null) {
                this.thumbnailService = this.entry.createThumbnailStore();
                this.services.add((ServiceInterfacePrx)this.thumbnailService);
            }
            ++this.thumbRetrieval;
            return this.thumbnailService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Thumbnail service.");
            return null;
        }
    }

    private RawFileStorePrx getRawFileService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.fileStore != null) {
                this.services.remove(this.fileStore);
                try {
                    this.fileStore.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.fileStore = this.entry.createRawFileStore();
            this.services.add((ServiceInterfacePrx)this.fileStore);
            return this.fileStore;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RawFileStore service.");
            return null;
        }
    }

    private RenderingEnginePrx getRenderingService() throws DSAccessException, DSOutOfServiceException {
        try {
            RenderingEnginePrx engine = this.entry.createRenderingEngine();
            engine.setCompressionLevel(this.compression);
            return engine;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RawFileStore service.");
            return null;
        }
    }

    private RawPixelsStorePrx getPixelsStore() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.pixelsStore != null) {
                this.services.remove(this.pixelsStore);
                try {
                    this.pixelsStore.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.pixelsStore = this.entry.createRawPixelsStore();
            this.services.add((ServiceInterfacePrx)this.pixelsStore);
            return this.pixelsStore;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access RawPixelsStore service.");
            return null;
        }
    }

    private IPixelsPrx getPixelsService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.pixelsService == null) {
                this.pixelsService = this.entry.getPixelsService();
                this.services.add((ServiceInterfacePrx)this.pixelsService);
            }
            return this.pixelsService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Pixels service.");
            return null;
        }
    }

    private SearchPrx getSearchService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.searchService == null) {
                this.searchService = this.entry.createSearchService();
                this.services.add((ServiceInterfacePrx)this.searchService);
            }
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Search service.");
        }
        return this.searchService;
    }

    private IProjectionPrx getProjectionService() throws DSAccessException, DSOutOfServiceException {
        try {
            if (this.projService == null) {
                this.projService = this.entry.getProjectionService();
                this.services.add((ServiceInterfacePrx)this.projService);
            }
            return this.projService;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot access Pixels service.");
            return null;
        }
    }

    private synchronized void needDefault(long pixelsID, RenderingEnginePrx re) throws DSAccessException, DSOutOfServiceException {
        try {
            if (re == null) {
                ThumbnailStorePrx service = this.getThumbService();
                if (!service.setPixelsId(pixelsID)) {
                    service.resetDefaults();
                    service.setPixelsId(pixelsID);
                }
            } else if (!re.lookupRenderingDef(pixelsID)) {
                re.resetDefaults();
                re.lookupRenderingDef(pixelsID);
            }
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot set RE defaults.");
        }
    }

    private boolean isSystemGroup(ExperimenterGroup group) {
        String n = group.getName() == null ? null : group.getName().getValue();
        return "system".equals(n) || "user".equals(n) || "default".equals(n) || "guest".equals(n);
    }

    private List<Experimenter> containedExperimenters(long groupID) throws DSAccessException, DSOutOfServiceException {
        IQueryPrx service = this.getQueryService();
        ArrayList<Experimenter> exps = new ArrayList<Experimenter>();
        ParametersI p = new ParametersI();
        p.map = new HashMap();
        p.map.put("id", rtypes.rlong((long)groupID));
        try {
            List rv = service.findAllByQuery("select e from Experimenter e left outer join fetch e.groupExperimenterMap m left outer join fetch m.parent g where g.id = :id", (Parameters)p);
            for (IObject obj : rv) {
                exps.add((Experimenter)obj);
            }
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve experimenters.");
        }
        return exps;
    }

    private List<String> prepareTextSearch(String[] terms, SearchPrx service) throws DSAccessException, DSOutOfServiceException {
        if (terms == null || terms.length == 0) {
            return null;
        }
        ArrayList<String> formattedTerms = new ArrayList<String>(terms.length);
        try {
            for (int j = 0; j < terms.length; ++j) {
                String value = terms[j];
                if (this.startWithWildCard(value)) {
                    service.setAllowLeadingWildcard(true);
                }
                int n = value.length();
                char[] arr = new char[n];
                String v = "";
                value.getChars(0, n, arr, 0);
                for (int i = 0; i < arr.length; ++i) {
                    v = SUPPORTED_SPECIAL_CHAR.contains(Character.valueOf(arr[i])) ? v + "\\" + arr[i] : v + arr[i];
                }
                String formatted = value.contains(" ") ? "\"" + v.toLowerCase() + "\"" : v.toLowerCase();
                formattedTerms.add(formatted);
            }
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot format text for search.");
        }
        return formattedTerms;
    }

    private List<String> prepareTextSearch(Collection<String> terms, SearchPrx service) throws DSAccessException, DSOutOfServiceException {
        if (terms == null || terms.size() == 0) {
            return null;
        }
        if (terms == null || terms.size() == 0) {
            return null;
        }
        String[] values = new String[terms.size()];
        Iterator<String> i = terms.iterator();
        int index = 0;
        while (i.hasNext()) {
            values[index] = i.next();
            ++index;
        }
        return this.prepareTextSearch(values, service);
    }

    private boolean startWithWildCard(String value) {
        if (value == null) {
            return false;
        }
        Iterator<String> i = WILD_CARDS.iterator();
        while (i.hasNext()) {
            if (!value.startsWith(i.next())) continue;
            return true;
        }
        return false;
    }

    private String convertAnnotation(Class pojo) {
        if (TextualAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.CommentAnnotation";
        }
        if (TagAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.TagAnnotation";
        }
        if (RatingAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.LongAnnotation";
        }
        if (LongAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.LongAnnotation";
        }
        if (FileAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.FileAnnotation";
        }
        if (URLAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.UriAnnotation";
        }
        if (TimeAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.UriAnnotation";
        }
        if (BooleanAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.UriAnnotation";
        }
        return null;
    }

    OMEROGateway(int port, DataServicesFactory dsFactory) {
        if (dsFactory == null) {
            throw new IllegalArgumentException("No Data service factory.");
        }
        this.dsFactory = dsFactory;
        this.port = port;
        this.thumbRetrieval = 0;
        this.enumerations = new HashMap<String, List<EnumerationObject>>();
        this.services = new ArrayList<ServiceInterfacePrx>();
        this.reServices = new HashMap<Long, ServiceInterfacePrx>();
    }

    void setPort(int port) {
        if (this.port != port) {
            this.port = port;
        }
    }

    Class convertPojos(Class nodeType) {
        if (ProjectData.class.equals((Object)nodeType)) {
            return Project.class;
        }
        if (DatasetData.class.equals((Object)nodeType)) {
            return Dataset.class;
        }
        if (ImageData.class.equals((Object)nodeType)) {
            return Image.class;
        }
        if (BooleanAnnotationData.class.equals((Object)nodeType)) {
            return BooleanAnnotation.class;
        }
        if (RatingAnnotationData.class.equals((Object)nodeType) || LongAnnotationData.class.equals((Object)nodeType)) {
            return LongAnnotation.class;
        }
        if (TagAnnotationData.class.equals((Object)nodeType)) {
            return TagAnnotation.class;
        }
        if (TextualAnnotationData.class.equals((Object)nodeType)) {
            return CommentAnnotation.class;
        }
        if (FileAnnotationData.class.equals((Object)nodeType)) {
            return FileAnnotation.class;
        }
        if (URLAnnotationData.class.equals((Object)nodeType)) {
            return UriAnnotation.class;
        }
        if (ScreenData.class.equals((Object)nodeType)) {
            return Screen.class;
        }
        if (PlateData.class.equals((Object)nodeType)) {
            return Plate.class;
        }
        if (WellData.class.equals((Object)nodeType)) {
            return Well.class;
        }
        if (WellSampleData.class.equals((Object)nodeType)) {
            return WellSample.class;
        }
        throw new IllegalArgumentException("NodeType not supported");
    }

    private String convertTypeForSearch(Class nodeType) {
        if (nodeType.equals(Image.class)) {
            return ImageI.class.getName();
        }
        if (nodeType.equals(TagAnnotation.class) || nodeType.equals(TagAnnotationData.class)) {
            return TagAnnotationI.class.getName();
        }
        if (nodeType.equals(BooleanAnnotation.class) || nodeType.equals(BooleanAnnotationData.class)) {
            return BooleanAnnotationI.class.getName();
        }
        if (nodeType.equals(UriAnnotation.class) || nodeType.equals(URLAnnotationData.class)) {
            return UriAnnotationI.class.getName();
        }
        if (nodeType.equals(FileAnnotation.class) || nodeType.equals(FileAnnotationData.class)) {
            return FileAnnotationI.class.getName();
        }
        if (nodeType.equals(CommentAnnotation.class) || nodeType.equals(TextualAnnotationData.class)) {
            return CommentAnnotationI.class.getName();
        }
        if (nodeType.equals(TimestampAnnotation.class) || nodeType.equals(TimeAnnotationData.class)) {
            return TimestampAnnotationI.class.getName();
        }
        throw new IllegalArgumentException("type not supported");
    }

    boolean isConnected() {
        return this.connected;
    }

    ExperimenterData getUserDetails(String name) throws DSOutOfServiceException {
        try {
            IAdminPrx service = this.getAdminService();
            return (ExperimenterData)PojoMapper.asDataObject((IObject)service.lookupExperimenter(name));
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Cannot retrieve user's data " + this.printErrorText(e), e);
        }
    }

    boolean isUpgradeRequired() {
        ResourceBundle bundle = ResourceBundle.getBundle("omero");
        String version = bundle.getString("omero.version");
        String url = bundle.getString("omero.upgrades.url");
        UpgradeCheck check = new UpgradeCheck(url, version, "insight");
        check.run();
        return check.isUpgradeNeeded();
    }

    ExperimenterData login(String userName, String password, String hostName, float compressionLevel) throws DSOutOfServiceException {
        try {
            this.compression = compressionLevel;
            this.hostName = hostName;
            this.blitzClient = this.port > 0 ? new client(hostName, this.port) : new client(hostName);
            this.entry = this.blitzClient.createSession(userName, password);
            this.blitzClient.getProperties().setProperty("Ice.Override.Timeout", "5000");
            this.connected = true;
            return this.getUserDetails(userName);
        }
        catch (Throwable e) {
            this.connected = false;
            String s = "Can't connect to OMERO. OMERO info not valid.\n\n";
            s = s + this.printErrorText(e);
            throw new DSOutOfServiceException(s, e);
        }
    }

    String lookupLdapAuthExperimenter(long userID) throws DSOutOfServiceException {
        try {
            return this.getAdminService().lookupLdapAuthExperimenter(userID);
        }
        catch (Throwable e) {
            String s = "Can't connect find the LDAP information.\n\n";
            s = s + this.printErrorText(e);
            throw new DSOutOfServiceException(s, e);
        }
    }

    void startFS(Properties fsConfig) {
    }

    void reconnect(String userName, String password) throws DSOutOfServiceException {
        try {
            this.logout();
            this.thumbnailService = null;
            this.thumbRetrieval = 0;
            this.fileStore = null;
            this.blitzClient = this.port > 0 ? new client(this.hostName, this.port) : new client(this.hostName);
            this.entry = this.blitzClient.createSession(userName, password);
            this.connected = true;
        }
        catch (Throwable e) {
            this.connected = false;
            String s = "Can't connect to OMERO. OMERO info not valid.\n\n";
            s = s + this.printErrorText(e);
            throw new DSOutOfServiceException(s, e);
        }
    }

    void logout() {
        this.connected = false;
        try {
            this.thumbnailService = null;
            this.fileStore = null;
            this.entry = null;
            this.blitzClient = null;
            this.metadataService = null;
            this.pojosService = null;
            this.projService = null;
            this.searchService = null;
            this.adminService = null;
            this.queryService = null;
            this.rndSettingsService = null;
            this.repInfoService = null;
            this.deleteService = null;
            this.pixelsService = null;
            this.services.clear();
            this.reServices.clear();
            this.blitzClient.closeSession();
            this.entry.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Set loadContainerHierarchy(Class rootType, List rootIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            return PojoMapper.asDataObjects(service.loadContainerHierarchy(this.convertPojos(rootType).getName(), rootIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot load hierarchy for " + rootType + ".");
            return new HashSet();
        }
    }

    Set findContainerHierarchy(Class rootNodeType, List leavesIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            return PojoMapper.asDataObjects(service.findContainerHierarchies(this.convertPojos(rootNodeType).getName(), leavesIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find hierarchy for " + rootNodeType + ".");
            return new HashSet();
        }
    }

    Map loadAnnotations(Class nodeType, List nodeIDs, List<Class> annotationTypes, List annotatorIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ArrayList<String> types = new ArrayList<String>();
        if (annotationTypes != null && annotationTypes.size() > 0) {
            types = new ArrayList(annotationTypes.size());
            Iterator<Class> i = annotationTypes.iterator();
            while (i.hasNext()) {
                String k = this.convertAnnotation(i.next());
                if (k == null) continue;
                types.add(k);
            }
        }
        try {
            IMetadataPrx service = this.getMetadataService();
            return PojoMapper.asDataObjects(service.loadAnnotations(this.convertPojos(nodeType).getName(), nodeIDs, types, annotatorIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find annotations for " + nodeType + ".");
            return new HashMap();
        }
    }

    Set<DataObject> loadAnnotation(List<Long> annotationIds) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        if (annotationIds == null || annotationIds.size() == 0) {
            return new HashSet<DataObject>();
        }
        try {
            IMetadataPrx service = this.getMetadataService();
            return PojoMapper.asDataObjects(service.loadAnnotation(annotationIds));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find the annotations.");
            return new HashSet<DataObject>();
        }
    }

    Collection findAllAnnotations(Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            String table = this.getTableForAnnotationLink(type.getName());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link";
            sql = sql + " left outer join link.child as child";
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("uid", rtypes.rlong((long)userID));
            sql = sql + " where link.details.owner.id = :uid";
            return service.findAllByQuery(sql, (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for userID: " + userID);
            return new ArrayList();
        }
    }

    Set getContainerImages(Class nodeType, List nodeIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            return PojoMapper.asDataObjects(service.getImages(this.convertPojos(nodeType).getName(), nodeIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find images for " + nodeType + ".");
            return new HashSet();
        }
    }

    Set getUserImages(Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            return PojoMapper.asDataObjects(service.getUserImages(options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find user images.");
            return new HashSet();
        }
    }

    Map getCollectionCount(Class rootNodeType, String property, List ids, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            if (TagAnnotationData.class.equals((Object)rootNodeType)) {
                return this.getMetadataService().getTaggedObjectsCount(ids, options);
            }
            IContainerPrx service = this.getPojosService();
            String p = this.convertProperty(rootNodeType, property);
            if (p == null) {
                return null;
            }
            return PojoMapper.asDataObjects(service.getCollectionCount(this.convertPojos(rootNodeType).getName(), p, ids, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the collection.");
            return new HashMap();
        }
    }

    IObject createObject(IObject object) throws DSOutOfServiceException, DSAccessException {
        try {
            this.isSessionAlive();
            return this.saveAndReturnObject(object, null);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> createObjects(List<IObject> objects) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.saveAndReturnObject(objects, null);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot create the objects.");
            return new ArrayList<IObject>();
        }
    }

    void deleteObject(IObject object) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx service = this.getUpdateService();
            service.deleteObject(object);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot delete the object.");
        }
    }

    void deleteObjects(List<IObject> objects) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx service = this.getUpdateService();
            Iterator<IObject> i = objects.iterator();
            while (i.hasNext()) {
                service.deleteObject(i.next());
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot delete the object.");
        }
    }

    IObject saveAndReturnObject(IObject object, Map options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx service = this.getUpdateService();
            if (options == null) {
                return service.saveAndReturnObject(object);
            }
            return service.saveAndReturnObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> saveAndReturnObject(List<IObject> objects, Map options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IUpdatePrx service = this.getUpdateService();
            return service.saveAndReturnArray(objects);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    IObject updateObject(IObject object, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            IObject r = service.updateDataObject(object, options);
            return this.findIObject(r);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> updateObjects(List<IObject> objects, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            List l = service.updateDataObjects(objects, options);
            if (l == null) {
                return l;
            }
            Iterator i = l.iterator();
            ArrayList<IObject> r = new ArrayList<IObject>(l.size());
            while (i.hasNext()) {
                IObject io = this.findIObject((IObject)i.next());
                if (io == null) continue;
                r.add(io);
            }
            return r;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    Pixels getPixels(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IPixelsPrx service = this.getPixelsService();
            return service.retrievePixDescription(pixelsID);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the pixels set of the pixels set.");
            return null;
        }
    }

    synchronized byte[] getThumbnail(long pixelsID, int sizeX, int sizeY, long userID) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            RenderingDef def;
            ThumbnailStorePrx service = this.getThumbService();
            this.needDefault(pixelsID, null);
            if (userID >= 0L && (def = this.getRenderingDef(pixelsID, userID)) != null) {
                service.setRenderingDefId(def.getId().getValue());
            }
            return service.getThumbnail(rtypes.rint((int)sizeX), rtypes.rint((int)sizeY));
        }
        catch (Throwable t) {
            if (this.thumbnailService != null) {
                try {
                    this.thumbnailService.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.thumbnailService = null;
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized byte[] getThumbnailByLongestSide(long pixelsID, int maxLength) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            ThumbnailStorePrx service = this.getThumbService();
            this.needDefault(pixelsID, null);
            return service.getThumbnailByLongestSide(rtypes.rint((int)maxLength));
        }
        catch (Throwable t) {
            if (this.thumbnailService != null) {
                try {
                    this.thumbnailService.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.thumbnailService = null;
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized Map getThumbnailSet(List<Long> pixelsID, int maxLength) throws RenderingServiceException, DSOutOfServiceException {
        this.isSessionAlive();
        try {
            ThumbnailStorePrx service = this.getThumbService();
            return service.getThumbnailByLongestSideSet(rtypes.rint((int)maxLength), pixelsID);
        }
        catch (Throwable t) {
            if (this.thumbnailService != null) {
                try {
                    this.thumbnailService.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.thumbnailService = null;
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized RenderingEnginePrx createRenderingEngine(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            RenderingEnginePrx service = this.getRenderingService();
            this.reServices.put(pixelsID, (ServiceInterfacePrx)service);
            service.lookupPixels(pixelsID);
            this.needDefault(pixelsID, service);
            service.load();
            return service;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot start the Rendering Engine.");
            return null;
        }
    }

    IObject findAnnotationLink(Class type, long parentID, long childID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            String table = this.getTableForAnnotationLink(type.getName());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID";
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("parentID", rtypes.rlong((long)parentID));
            if (childID >= 0L) {
                sql = sql + " and link.child.id = :childID";
                p.map.put("childID", rtypes.rlong((long)childID));
            }
            return service.findByQuery(sql, (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parentID + " and child " + "ID: " + childID);
            return null;
        }
    }

    List findAnnotationLinks(String parentType, long parentID, List<Long> children) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            String table = this.getTableForAnnotationLink(parentType);
            if (table == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link");
            sb.append(" left outer join fetch link.details.owner as owner");
            sb.append(" left outer join fetch link.child as child");
            sb.append(" left outer join fetch link.parent as parent");
            ParametersI p = new ParametersI();
            if (parentID > 0L) {
                sb.append(" where link.parent.id = :parentID");
                if (children != null && children.size() > 0) {
                    sb.append(" and link.child.id in (:childIDs)");
                    p.addLongs("childIDs", children);
                }
                p.map.put("parentID", rtypes.rlong((long)parentID));
            } else if (children != null && children.size() > 0) {
                sb.append(" where link.child.id in (:childIDs)");
                p.addLongs("childIDs", children);
            }
            return service.findAllByQuery(sb.toString(), (Parameters)p);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.handleException(t, "Cannot retrieve the annotation links for parent ID: " + parentID);
            return new ArrayList();
        }
    }

    IObject findLink(IObject parent, IObject child) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID and link.child.id = :childID";
            ParametersI param = new ParametersI();
            param.map = new HashMap();
            param.map.put("parentID", parent.getId());
            param.map.put("childID", child.getId());
            return this.getQueryService().findByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId() + " and child " + "ID: " + child.getId());
            return null;
        }
    }

    List findLinks(IObject parent, List children) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            ParametersI param = new ParametersI();
            param.map.put("parentID", parent.getId());
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID";
            if (children != null && children.size() > 0) {
                sql = sql + " and link.child.id in (:childIDs)";
                param.addLongs("childIDs", (Collection)children);
            }
            return this.getQueryService().findAllByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId());
            return new ArrayList();
        }
    }

    List findLinks(Class parentClass, List children, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getTableForLink(parentClass);
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.child.id in (:childIDs)";
            ParametersI param = new ParametersI();
            param.addLongs("childIDs", (Collection)children);
            if (userID >= 0L) {
                sql = sql + " and link.details.owner.id = :userID";
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return this.getQueryService().findAllByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for the specified children");
            return new ArrayList();
        }
    }

    List findLinks(Class parentClass, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String table = this.getTableForLink(parentClass);
            if (table == null) {
                return null;
            }
            ParametersI param = new ParametersI();
            param.map.put("childID", rtypes.rlong((long)childID));
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link ");
            sb.append("left outer join fetch link.child as child ");
            sb.append("left outer join fetch link.parent parent ");
            sb.append("where link.child.id = :id");
            if (childID >= 0L) {
                param.addId(childID);
            }
            if (userID >= 0L) {
                sb.append(" and link.details.owner.id = :userID");
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return this.getQueryService().findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for child ID: " + childID);
            return new ArrayList();
        }
    }

    IObject findIObject(IObject o) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.getQueryService().find(o.getClass().getName(), o.getId().getValue());
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object with object ID: " + o.getId());
            return null;
        }
    }

    IObject findIObject(String klassName, long id) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.getQueryService().find(klassName, id);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object with object ID: " + id);
            return null;
        }
    }

    Map<GroupData, Set> getAvailableGroups(ExperimenterData loggedInUser) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IAdminPrx service = this.getAdminService();
            List groups = service.lookupGroups();
            Iterator i = groups.iterator();
            HashMap<GroupData, Set> pojos = new HashMap<GroupData, Set>();
            List l = loggedInUser.getGroups();
            Iterator k = l.iterator();
            ArrayList<Long> groupIds = new ArrayList<Long>();
            while (k.hasNext()) {
                groupIds.add(((GroupData)k.next()).getId());
            }
            while (i.hasNext()) {
                ExperimenterGroup group = (ExperimenterGroup)i.next();
                long gpId = group.getId().getValue();
                if (this.isSystemGroup(group) || !groupIds.contains(gpId)) continue;
                DataObject pojoGroup = PojoMapper.asDataObject((IObject)group);
                List<Experimenter> experimenters = this.containedExperimenters(gpId);
                pojos.put((GroupData)pojoGroup, PojoMapper.asDataObjects(experimenters));
            }
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the available groups ");
            return new HashMap<GroupData, Set>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List> getArchivedFiles(String path, long pixelsID) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        IQueryPrx service = this.getQueryService();
        List files = null;
        try {
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)pixelsID));
            files = service.findAllByQuery("select ofile from OriginalFile as ofile left join ofile.pixelsFileMaps as pfm left join pfm.child as child where child.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            throw new DSAccessException("Cannot retrieve original file", e);
        }
        HashMap<Integer, List> result = new HashMap<Integer, List>();
        if (files == null || files.size() == 0) {
            return result;
        }
        RawFileStorePrx store = this.getRawFileService();
        Iterator i = files.iterator();
        FileOutputStream stream = null;
        long offset = 0L;
        ArrayList<String> notDownloaded = new ArrayList<String>();
        while (i.hasNext()) {
            OriginalFile of = (OriginalFile)i.next();
            try {
                store.setFileId(of.getId().getValue());
            }
            catch (Exception e) {
                this.handleException(e, "Cannot set the file's id.");
            }
            String fullPath = path + of.getName();
            File f = new File(fullPath);
            try {
                stream = new FileOutputStream(f);
                long size = of.getSize().getValue();
                try {
                    try {
                        offset = 0L;
                        while (offset + 262144L < size) {
                            stream.write(store.read(offset, 262144));
                            offset += 262144L;
                        }
                    }
                    finally {
                        stream.write(store.read(offset, (int)(size - offset)));
                        stream.close();
                    }
                }
                catch (Exception e) {
                    if (stream != null) {
                        stream.close();
                    }
                    if (f != null) {
                        f.delete();
                    }
                    notDownloaded.add(of.getName().getValue());
                }
            }
            catch (IOException e) {
                if (f != null) {
                    f.delete();
                }
                notDownloaded.add(of.getName().getValue());
                throw new DSAccessException("Cannot create file with path " + fullPath, e);
            }
        }
        result.put(files.size(), notDownloaded);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File downloadFile(File file, long fileID, long size) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        RawFileStorePrx store = this.getRawFileService();
        try {
            store.setFileId(fileID);
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot set the file's id.");
        }
        String path = file.getAbsolutePath();
        int offset = 0;
        int length = (int)size;
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                try {
                    offset = 0;
                    while ((long)(offset + 262144) < size) {
                        stream.write(store.read((long)offset, 262144));
                        offset += 262144;
                    }
                }
                finally {
                    stream.write(store.read((long)offset, length - offset));
                    stream.close();
                }
            }
            catch (Exception e) {
                if (stream != null) {
                    stream.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            throw new DSAccessException("Cannot create file  " + path, e);
        }
        return file;
    }

    OriginalFile getOriginalFile(long id) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        OriginalFile of = null;
        try {
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)id));
            of = (OriginalFile)this.getQueryService().findByQuery("select p from OriginalFile as p left outer join fetch p.format where p.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve original file");
        }
        return of;
    }

    List getOriginalFiles(long pixelsID) throws DSAccessException, DSOutOfServiceException {
        this.isSessionAlive();
        List files = null;
        try {
            ParametersI param = new ParametersI();
            param.map.put("childID", rtypes.rlong((long)pixelsID));
            files = this.getQueryService().findAllByQuery("select ofile from OriginalFile as ofile left join ofile.pixelsFileMaps as pfm left join pfm.child as child where child.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve original file");
        }
        return files;
    }

    OriginalFile uploadFile(File file, String format, long originalFileID) throws DSAccessException, DSOutOfServiceException {
        if (file == null) {
            throw new IllegalArgumentException("No file to upload");
        }
        this.isSessionAlive();
        RawFileStorePrx store = this.getRawFileService();
        OriginalFile save = null;
        try {
            OriginalFile oFile;
            if (originalFileID <= 0L) {
                Format f = (Format)this.getQueryService().findByString(Format.class.getName(), "value", format);
                oFile = new OriginalFileI();
                oFile.setName(rtypes.rstring((String)file.getName()));
                oFile.setPath(rtypes.rstring((String)file.getAbsolutePath()));
                oFile.setSize(rtypes.rlong((long)file.length()));
                oFile.setSha1(rtypes.rstring((String)"pending"));
                oFile.setFormat(f);
                save = (OriginalFile)this.saveAndReturnObject((IObject)oFile, null);
                store.setFileId(save.getId().getValue());
            } else {
                oFile = (OriginalFile)this.findIObject(OriginalFile.class.getName(), originalFileID);
                OriginalFileI newFile = new OriginalFileI();
                newFile.setId(rtypes.rlong((long)originalFileID));
                newFile.setName(rtypes.rstring((String)file.getName()));
                newFile.setPath(rtypes.rstring((String)file.getAbsolutePath()));
                newFile.setSize(rtypes.rlong((long)file.length()));
                newFile.setSha1(rtypes.rstring((String)"pending"));
                newFile.setFormat(oFile.getFormat());
                save = (OriginalFile)this.saveAndReturnObject((IObject)newFile, null);
                store.setFileId(save.getId().getValue());
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot set the file's id.");
        }
        byte[] buf = new byte[262144];
        FileInputStream stream = null;
        try {
            int rlen;
            stream = new FileInputStream(file);
            long pos = 0L;
            while ((rlen = stream.read(buf)) > 0) {
                store.write(buf, pos, rlen);
                pos += (long)rlen;
                ByteBuffer bbuf = ByteBuffer.wrap(buf);
                bbuf.limit(rlen);
            }
            stream.close();
        }
        catch (Exception e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new DSAccessException("Cannot upload the file with path " + file.getAbsolutePath(), e);
        }
        return save;
    }

    void changePassword(String password) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            this.getAdminService().changePassword(rtypes.rstring((String)password));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify password. ");
        }
    }

    void updateExperimenter(Experimenter exp) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            this.getAdminService().updateSelf(exp);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the user. ");
        }
    }

    synchronized byte[] getPlane(long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        RawPixelsStorePrx service = this.getPixelsStore();
        try {
            service.setPixelsId(pixelsID, false);
            return service.getPlane(z, c, t);
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the plane (z=" + z + ", t=" + t + ", c=" + c + ") for pixelsID: " + pixelsID);
            return null;
        }
    }

    long getFreeSpace() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.getRepositoryService().getFreeSpaceInKilobytes();
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the free space");
            return -1L;
        }
    }

    long getUsedSpace() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            return this.getRepositoryService().getUsedSpaceInKilobytes();
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the free space");
            return -1L;
        }
    }

    List getImagesDuring(Timestamp startTime, Timestamp endTime, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String sql = "select i from Image as i left outer join fetch i.details.creationEvent as c where i.details.owner.id = :userID and ";
            IQueryPrx service = this.getQueryService();
            ParametersI param = new ParametersI();
            param.map.put("userID", rtypes.rlong((long)userID));
            if (startTime != null && endTime != null) {
                sql = sql + "c.time < :endTime and c.time > :startTime";
                param.add("startTime", (RType)rtypes.rtime((long)startTime.getTime()));
                param.add("endTime", (RType)rtypes.rtime((long)endTime.getTime()));
            } else if (startTime == null && endTime != null) {
                sql = sql + "c.time < :endTime";
                param.add("endTime", (RType)rtypes.rtime((long)endTime.getTime()));
            } else if (startTime != null && endTime == null) {
                sql = sql + "c.time  > :startTime";
                param.add("startTime", (RType)rtypes.rtime((long)startTime.getTime()));
            }
            return service.findAllByQuery(sql, (Parameters)param);
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the images imported during the selected period.");
            return new ArrayList();
        }
    }

    Collection getImages(Parameters map, boolean asDataObject) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IContainerPrx service = this.getPojosService();
            List result = service.getImagesByOptions(map);
            if (asDataObject) {
                return PojoMapper.asDataObjects(result);
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the images imported the specified period.");
            return new HashSet();
        }
    }

    Map resetRenderingSettings(Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        this.isSessionAlive();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            String klass = this.convertPojos(rootNodeType).getName();
            if (klass.equals(Image.class.getName()) || klass.equals(Dataset.class.getName())) {
                success = service.resetDefaultsInSet(klass, nodes);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        HashMap result = new HashMap(2);
        result.put(Boolean.TRUE, success);
        result.put(Boolean.FALSE, failure);
        return result;
    }

    Map setOriginalRenderingSettings(Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        this.isSessionAlive();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            String klass = this.convertPojos(rootNodeType).getName();
            if (klass.equals(Image.class.getName()) || klass.equals(Dataset.class.getName())) {
                success = service.setOriginalSettingsInSet(klass, nodes);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        HashMap result = new HashMap(2);
        result.put(Boolean.TRUE, success);
        result.put(Boolean.FALSE, failure);
        return result;
    }

    Map pasteRenderingSettings(long pixelsID, Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List<Long> success = new ArrayList();
        List<Long> failure = new ArrayList();
        this.isSessionAlive();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            Iterator i = nodes.iterator();
            if (ImageData.class.equals((Object)rootNodeType)) {
                Map m = service.applySettingsToImages(pixelsID, nodes);
                success = (List)m.get(Boolean.TRUE);
                failure = (List)m.get(Boolean.FALSE);
            } else if (DatasetData.class.equals((Object)rootNodeType)) {
                while (i.hasNext()) {
                    Iterator k;
                    long id = (Long)i.next();
                    Map m = service.applySettingsToDataset(pixelsID, id);
                    List l = (List)m.get(Boolean.TRUE);
                    if (l != null && l.size() > 0) {
                        k = l.iterator();
                        while (k.hasNext()) {
                            success.add((Long)k.next());
                        }
                    }
                    if ((l = (List)m.get(Boolean.FALSE)) == null || l.size() <= 0) continue;
                    k = l.iterator();
                    while (k.hasNext()) {
                        failure.add((Long)k.next());
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot paste the rendering settings.");
        }
        HashMap result = new HashMap(2);
        result.put(Boolean.TRUE, success);
        result.put(Boolean.FALSE, failure);
        return result;
    }

    Map getRenderingSettings(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        HashMap<DataObject, RenderingDef> map = new HashMap<DataObject, RenderingDef>();
        this.isSessionAlive();
        try {
            IPixelsPrx service = this.getPixelsService();
            List results = service.retrieveAllRndSettings(pixelsID, userID);
            if (results == null || results.size() == 0) {
                return map;
            }
            for (RenderingDef rndDef : results) {
                Experimenter exp = rndDef.getDetails().getOwner();
                map.put(PojoMapper.asDataObject((IObject)exp), rndDef);
            }
            return map;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings for.");
            return map;
        }
    }

    RenderingDef getRenderingDef(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IPixelsPrx service = this.getPixelsService();
            return service.retrieveRndSettingsFor(pixelsID, userID);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings");
            return null;
        }
    }

    Set loadSpecificAnnotation(Class type, List<String> toInclude, List<String> toExclude, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            return PojoMapper.asDataObjects(service.loadSpecifiedAnnotations(this.convertPojos(type).getName(), toInclude, toExclude, options));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotations");
            return new HashSet();
        }
    }

    long countSpecificAnnotation(Class type, List<String> toInclude, List<String> toExclude, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            RLong value = service.countSpecifiedAnnotations(this.convertPojos(type).getName(), toInclude, toExclude, options);
            if (value == null) {
                return -1L;
            }
            return value.getValue();
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotations");
            return -1L;
        }
    }

    Object performSearch(SearchDataContext context) throws DSOutOfServiceException, DSAccessException {
        List<Class> types = context.getTypes();
        List<Integer> scopes = context.getScope();
        if (types == null || types.size() == 0) {
            return new HashMap();
        }
        if (scopes == null || scopes.size() == 0) {
            return new HashMap();
        }
        this.isSessionAlive();
        try {
            DetailsI d;
            SearchPrx service = this.getSearchService();
            service.setAllowLeadingWildcard(false);
            service.setCaseSentivice(context.isCaseSensitive());
            Timestamp start = context.getStart();
            Timestamp end = context.getEnd();
            if (start != null || end != null) {
                switch (context.getTimeIndex()) {
                    case 0: {
                        service.onlyCreatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                        break;
                    }
                    case 1: {
                        service.onlyModifiedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                        break;
                    }
                    case 2: {
                        service.onlyAnnotatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                    }
                }
            }
            List<ExperimenterData> users = context.getOwners();
            ArrayList<DetailsI> owners = new ArrayList<DetailsI>();
            for (ExperimenterData exp : users) {
                d = new DetailsI();
                d.setOwner(exp.asExperimenter());
                owners.add(d);
            }
            List<String> some = this.prepareTextSearch(context.getSome(), service);
            List<String> must = this.prepareTextSearch(context.getMust(), service);
            List<String> none = this.prepareTextSearch(context.getNone(), service);
            ArrayList<String> supportedTypes = new ArrayList<String>();
            Iterator<Object> i = types.iterator();
            while (i.hasNext()) {
                supportedTypes.add(this.convertPojos((Class)i.next()).getName());
            }
            HashMap<Integer, Object> results = new HashMap<Integer, Object>();
            i = scopes.iterator();
            while (i.hasNext()) {
                results.put((Integer)i.next(), new ArrayList());
            }
            i = scopes.iterator();
            List<String> fSome = null;
            List<String> fMust = null;
            List<String> fNone = null;
            List<String> fSomeSec = null;
            List<String> fMustSec = null;
            List<String> fNoneSec = null;
            service.onlyType(Image.class.getName());
            while (i.hasNext()) {
                Integer key = (Integer)i.next();
                List rType = (List)results.get(key);
                Object size = null;
                if (key == 1) {
                    fSome = this.formatText(some, "tag");
                    fMust = this.formatText(must, "tag");
                    fNone = this.formatText(none, "tag");
                } else if (key == 2) {
                    fSome = this.formatText(some, "name");
                    fMust = this.formatText(must, "name");
                    fNone = this.formatText(none, "name");
                } else if (key == 5) {
                    fSome = this.formatText(some, "description");
                    fMust = this.formatText(must, "description");
                    fNone = this.formatText(none, "description");
                } else if (key == 3) {
                    fSome = this.formatText(some, "file.name");
                    fMust = this.formatText(must, "file.name");
                    fNone = this.formatText(none, "file.name");
                    fSomeSec = this.formatText(some, "file.contents");
                    fMustSec = this.formatText(must, "file.contents");
                    fNoneSec = this.formatText(none, "file.contents");
                } else if (key == 0) {
                    fSome = this.formatText(some, "annotation", "NOT", "tag");
                    fMust = this.formatText(must, "annotation", "NOT", "tag");
                    fNone = this.formatText(none, "annotation", "NOT", "tag");
                } else if (key == 4) {
                    fSome = this.formatText(some, "url");
                    fMust = this.formatText(must, "url");
                    fNone = this.formatText(none, "url");
                }
                Iterator owner = owners.iterator();
                if (fSome == null) continue;
                while (owner.hasNext()) {
                    d = (Details)owner.next();
                    service.onlyOwnedBy((Details)d);
                    service.bySomeMustNone(fSome, fMust, fNone);
                    size = this.handleSearchResult(this.convertTypeForSearch(Image.class), rType, service);
                    if (size instanceof Integer) {
                        results.put(key, size);
                    }
                    service.clearQueries();
                    if (size instanceof Integer || fSomeSec == null) continue;
                    service.bySomeMustNone(fSomeSec, fMustSec, fNoneSec);
                    size = this.handleSearchResult(Image.class.getName(), rType, service);
                    if (size instanceof Integer) {
                        results.put(key, size);
                    }
                    service.clearQueries();
                }
            }
            service.close();
            return results;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot perform the search.");
            return null;
        }
    }

    Set filterBy(Class annotationType, List<String> terms, Timestamp start, Timestamp end, ExperimenterData exp) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            SearchPrx service = this.getSearchService();
            if (start != null && end != null) {
                service.onlyAnnotatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
            }
            if (exp != null) {
                DetailsI d = new DetailsI();
                d.setOwner(exp.asExperimenter());
            }
            List<String> t = this.prepareTextSearch(terms, service);
            service.onlyType(this.convertPojos(annotationType).getName());
            HashSet rType = new HashSet();
            service.bySomeMustNone(t, null, null);
            Object size = this.handleSearchResult(this.convertTypeForSearch(annotationType), rType, service);
            if (size instanceof Integer) {
                new HashSet();
            }
            return rType;
        }
        catch (Exception e) {
            this.handleException(e, "Filtering by annotation not valid");
            return new HashSet();
        }
    }

    Set fetchContainers(Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("id", rtypes.rlong((long)userID));
            String table = this.getTableForClass(type);
            return PojoMapper.asDataObjects(service.findAllByQuery("from " + table + " as p where p.details.owner.id = :id", (Parameters)p));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the containers.");
            return new HashSet();
        }
    }

    Set getAnnotatedObjects(Class type, Set<Long> annotationIds, Set<Long> ownerIds) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            ParametersI param = new ParametersI();
            param.addLongs("ids", annotationIds);
            StringBuilder sb = new StringBuilder();
            if (type.equals(ImageData.class)) {
                sb.append("select img from Image as img ");
                sb.append("left outer join fetch img.annotationLinksCountPerOwner img_a_c ");
                sb.append("left outer join fetch img.annotationLinks ail ");
                sb.append("left outer join fetch img.pixels as pix ");
                sb.append("left outer join fetch pix.pixelsType as pt ");
                sb.append("where ail.child.id in (:ids)");
                if (ownerIds != null && ownerIds.size() > 0) {
                    sb.append(" and img.details.owner.id in (:ownerIds)");
                    param.addLongs("ownerIds", ownerIds);
                }
                return PojoMapper.asDataObjects(service.findAllByQuery(sb.toString(), (Parameters)param));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotated objects");
        }
        return new HashSet();
    }

    Map getDataObjectsTaggedCount(List rootNodeIDs) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            long r;
            Long value;
            List l;
            ParametersI param;
            IQueryPrx service = this.getQueryService();
            StringBuilder sb = new StringBuilder();
            sb.append("select img from Image as img ");
            sb.append("left outer join fetch img.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            Iterator i = rootNodeIDs.iterator();
            HashMap<Long, Long> m = new HashMap<Long, Long>();
            while (i.hasNext()) {
                Long id = (Long)i.next();
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l == null) continue;
                m.put(id, new Long(l.size()));
            }
            sb = new StringBuilder();
            sb.append("select d from Dataset as d ");
            sb.append("left outer join fetch d.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            for (Long id : rootNodeIDs) {
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                value = (Long)m.get(id);
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l != null) {
                    r = l.size();
                    value = value == null ? Long.valueOf(r) : Long.valueOf(value + r);
                }
                m.put(id, value);
            }
            sb = new StringBuilder();
            sb.append("select d from Project as d ");
            sb.append("left outer join fetch d.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            for (Long id : rootNodeIDs) {
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                value = (Long)m.get(id);
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l != null) {
                    r = l.size();
                    value = value == null ? Long.valueOf(r) : Long.valueOf(value + r);
                }
                m.put(id, value);
            }
            return m;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the collection.");
            return new HashMap();
        }
    }

    void removeTagDescription(long tagID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            String type = "ome.model.annotations.TextAnnotation";
            IQueryPrx service = this.getQueryService();
            ParametersI param = new ParametersI();
            param.addLong("uid", userID);
            param.addLong("id", tagID);
            String sql = "select link from AnnotationAnnotationLink as link ";
            sql = sql + "where link.parent.id = :id";
            sql = sql + " and link.child member of " + type;
            sql = sql + " and link.details.owner.id = :uid";
            List l = service.findAllByQuery(sql, (Parameters)param);
            if (l != null) {
                for (AnnotationAnnotationLink link : l) {
                    Annotation child = link.getChild();
                    if (child instanceof TagAnnotation || child instanceof UriAnnotation) continue;
                    this.deleteObject((IObject)link);
                    this.deleteObject((IObject)child);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot remove the tag description.");
        }
    }

    void isSessionAlive() {
        try {
            this.getAdminService().getEventContext();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            int index = 1;
            if (cause instanceof ConnectionLostException) {
                index = 0;
            }
            this.dsFactory.sessionExpiredExit(index);
        }
    }

    void keepSessionAlive() {
        int n = this.services.size() + this.reServices.size();
        ServiceInterfacePrx[] entries = new ServiceInterfacePrx[n];
        Iterator<ServiceInterfacePrx> i = this.services.iterator();
        int index = 0;
        while (i.hasNext()) {
            entries[index] = i.next();
            ++index;
        }
        Iterator<Long> j = this.reServices.keySet().iterator();
        while (j.hasNext()) {
            entries[index] = this.reServices.get(j.next());
            ++index;
        }
        this.entry.keepAllAlive(entries);
    }

    ImageData projectImage(long pixelsID, int startT, int endT, int startZ, int endZ, int stepping, ProjectionType algorithm, List<Integer> channels, String name, String pixType) throws DSOutOfServiceException, DSAccessException {
        try {
            IProjectionPrx service = this.getProjectionService();
            PixelsType type = null;
            if (pixType != null) {
                IQueryPrx svc = this.getQueryService();
                List l = svc.findAll(PixelsType.class.getName(), null);
                for (PixelsType pt : l) {
                    String value = pt.getValue().getValue();
                    if (!value.equals(pixType)) continue;
                    type = pt;
                    break;
                }
            }
            long imageID = service.projectPixels(pixelsID, type, algorithm, startT, endT, channels, stepping, startZ, endZ, name);
            return this.getImage(imageID, new Parameters());
        }
        catch (Exception e) {
            this.handleException(e, "Cannot project the image.");
            return null;
        }
    }

    ImageData getImage(long imageID, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            Iterator i;
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(imageID);
            Set result = this.getContainerImages(ImageData.class, ids, options);
            if (result != null && result.size() == 1 && (i = result.iterator()).hasNext()) {
                return (ImageData)i.next();
            }
            return null;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot project the image.");
            return null;
        }
    }

    RenderingDef createRenderingDef(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            IPixelsPrx svc = this.getPixelsService();
            Pixels pixels = svc.retrievePixDescription(pixelsID);
            if (pixels == null) {
                return null;
            }
            IRenderingSettingsPrx service = this.getRenderingSettingsService();
            return service.createNewRenderingDef(pixels);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create settings for: " + pixelsID);
            return null;
        }
    }

    Set loadPlateWells(long plateID, long userID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            List results = null;
            IQueryPrx service = this.getQueryService();
            StringBuilder sb = new StringBuilder();
            ParametersI param = new ParametersI();
            param.addLong("plateID", plateID);
            sb.append("select well from Well as well ");
            sb.append("left outer join fetch well.wellSamples as ws ");
            sb.append("left outer join fetch ws.image as img ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where well.plate.id = :plateID");
            results = service.findAllByQuery(sb.toString(), (Parameters)param);
            HashSet<WellData> wells = new HashSet<WellData>();
            Iterator i = results.iterator();
            HashMap map = new HashMap();
            while (i.hasNext()) {
                Well well = (Well)i.next();
                WellData wellData = (WellData)PojoMapper.asDataObject((IObject)well);
                wells.add(wellData);
            }
            return wells;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load plate");
            return new HashSet();
        }
    }

    Object loadImageAcquisitionData(long imageID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        ParametersI po = new ParametersI();
        po.acquisitionData();
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(imageID);
        IContainerPrx service = this.getPojosService();
        try {
            List images = service.getImages(Image.class.getName(), ids, (Parameters)po);
            if (images != null && images.size() == 1) {
                return new ImageAcquisitionData((Image)images.get(0));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load image acquisition data.");
        }
        return null;
    }

    Object loadChannelAcquisitionData(long channelID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(channelID);
            List l = service.loadChannelAcquisitionData(ids);
            if (l != null && l.size() == 1) {
                LogicalChannel lc = (LogicalChannel)l.get(0);
                return new ChannelAcquisitionData(lc);
            }
            return null;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load channel acquisition data.");
            return null;
        }
    }

    IObject getEnumeration(Class klass, String value) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IQueryPrx service = this.getQueryService();
            return service.findByString(klass.getName(), "value", value);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the enumeration's value.");
            return null;
        }
    }

    List<EnumerationObject> getEnumerations(String klassName) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            List<EnumerationObject> r = this.enumerations.get(klassName);
            if (r != null) {
                return r;
            }
            IPixelsPrx service = this.getPixelsService();
            List l = service.getAllEnumerations(klassName);
            r = new ArrayList<EnumerationObject>();
            if (l == null) {
                return r;
            }
            Iterator i = l.iterator();
            while (i.hasNext()) {
                r.add(new EnumerationObject(i.next()));
            }
            this.enumerations.put(klassName, r);
            return r;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the enumeration's value.");
            return new ArrayList<EnumerationObject>();
        }
    }

    Collection loadTags(Long id, Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(id);
            Map m = service.loadTagContent(ids, options);
            if (m == null || m.size() == 0) {
                return new ArrayList();
            }
            return PojoMapper.asDataObjects((Collection)m.get(id));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Tags.");
            return new ArrayList();
        }
    }

    Collection loadTagSets(Parameters options) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IMetadataPrx service = this.getMetadataService();
            List list = service.loadTagSets(options);
            ArrayList<TagAnnotationData> result = new ArrayList<TagAnnotationData>();
            if (list == null) {
                return result;
            }
            Iterator i = list.iterator();
            HashMap<Long, TagAnnotationData> sets = new HashMap<Long, TagAnnotationData>();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                TagAnnotationData tagSet;
                IObject object = (IObject)i.next();
                if (object instanceof TagAnnotation) {
                    result.add(new TagAnnotationData((TagAnnotation)object));
                    continue;
                }
                if (!(object instanceof AnnotationAnnotationLink)) continue;
                AnnotationAnnotationLink link = (AnnotationAnnotationLink)object;
                Annotation parent = link.getParent();
                Annotation child = link.getChild();
                Long id = parent.getId().getValue();
                if (sets.get(id) == null) {
                    tagSet = new TagAnnotationData((TagAnnotation)parent);
                    sets.put(id, tagSet);
                    result.add(tagSet);
                    tagSet.setTags(new HashSet());
                } else {
                    tagSet = (TagAnnotationData)sets.get(parent.getId().getValue());
                }
                Set tags = tagSet.getTags();
                tags.add(new TagAnnotationData((TagAnnotation)child));
                ids.add(child.getId().getValue());
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Tags.");
            return new ArrayList();
        }
    }

    List<IObject> loadPlaneInfo(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        IQueryPrx service = this.getQueryService();
        StringBuilder sb = new StringBuilder();
        ParametersI param = new ParametersI();
        sb.append("select info from PlaneInfo as info ");
        sb.append("where pixels.id = :id");
        param.addLong("id", pixelsID);
        try {
            return service.findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the plane info for pixels: " + pixelsID);
            return new ArrayList<IObject>();
        }
    }

    void fillEnumerations() throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        this.getEnumerations(OmeroMetadataService.IMMERSION);
        this.getEnumerations(OmeroMetadataService.CORRECTION);
        this.getEnumerations(OmeroMetadataService.MEDIUM);
        this.getEnumerations(OmeroMetadataService.DETECTOR_TYPE);
        this.getEnumerations(OmeroMetadataService.BINNING);
        this.getEnumerations(OmeroMetadataService.CONTRAST_METHOD);
        this.getEnumerations(OmeroMetadataService.ILLUMINATION_TYPE);
        this.getEnumerations(OmeroMetadataService.PHOTOMETRIC_INTERPRETATION);
        this.getEnumerations(OmeroMetadataService.ACQUISITION_MODE);
        this.getEnumerations(OmeroMetadataService.LASER_MEDIUM);
        this.getEnumerations(OmeroMetadataService.LASER_TYPE);
        this.getEnumerations(OmeroMetadataService.LASER_PULSE);
        this.getEnumerations(OmeroMetadataService.ARC_TYPE);
        this.getEnumerations(OmeroMetadataService.FILAMENT_TYPE);
    }

    List<IObject> removeObject(Class objectType, Long objectID) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IDeletePrx service = this.getDeleteService();
            if (ImageData.class.equals((Object)objectType)) {
                List r = service.checkImageDelete(objectID.longValue(), false);
                if (r == null || r.size() == 0) {
                    service.deleteImage(objectID.longValue(), true);
                    return r;
                }
                return r;
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot delete: " + objectType + " " + objectID);
        }
        return new ArrayList<IObject>();
    }

    Object deleteImage(Image object) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IDeletePrx service = this.getDeleteService();
            service.deleteImage(object.getId().getValue(), true);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot delete the image: " + object.getId());
        }
        return new ArrayList();
    }

    List<IObject> checkImage(Image object) throws DSOutOfServiceException, DSAccessException {
        this.isSessionAlive();
        try {
            IDeletePrx service = this.getDeleteService();
            return service.checkImageDelete(object.getId().getValue(), true);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot delete the image: " + object.getId());
            return new ArrayList<IObject>();
        }
    }

    FileSystemView getFSFileSystemView(String defaultPath) {
        return null;
    }

    Object monitor(String directory, String[] whiteList, DataObject container) {
        return null;
    }

    void removeREService(long pixelsID) {
        this.reServices.remove(pixelsID);
    }

    static {
        SUPPORTED_SPECIAL_CHAR.add(new Character('-'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('+'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('['));
        SUPPORTED_SPECIAL_CHAR.add(new Character(']'));
        SUPPORTED_SPECIAL_CHAR.add(new Character(')'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('('));
        SUPPORTED_SPECIAL_CHAR.add(new Character(':'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('|'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('!'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('{'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('}'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('^'));
        WILD_CARDS = new ArrayList<String>();
        WILD_CARDS.add("*");
        WILD_CARDS.add("?");
        WILD_CARDS.add("~");
    }
}

