/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.filechooser.FileSystemView;
import monitors.MonitorServerPrx;
import org.openmicroscopy.shoola.env.data.FSFile;

public class FSFileSystemView
extends FileSystemView {
    static final String FS_NAME = "omero-fs://";
    private FSFile defaultDirectory;
    private MonitorServerPrx server;

    FSFileSystemView(String defaultPath, MonitorServerPrx server) {
        if (server == null) {
            throw new IllegalArgumentException("No server specified.");
        }
        this.server = server;
        if (defaultPath != null && defaultPath.trim().length() > 0) {
            try {
                String s = FS_NAME + defaultPath;
                this.defaultDirectory = new FSFile(new URI(s));
                this.setDefaultDirectory(this.defaultDirectory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDefaultDirectory(File file) {
        if (file == null) {
            return;
        }
        if (file instanceof FSFile) {
            this.defaultDirectory = (FSFile)file;
        }
    }

    public File getDefaultDirectory() {
        return this.defaultDirectory;
    }

    public File createNewFolder(File containingDir) throws IOException {
        return null;
    }

    public File getParentDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        FSFile file = (FSFile)dir;
        File realFile = new File(file.getPath());
        try {
            String parent = realFile.getParent();
            if (parent != null) {
                URI uri = new URI(FS_NAME + realFile.getParent());
                return new FSFile(uri);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isComputerNode(File dir) {
        return false;
    }

    public boolean isDrive(File dir) {
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return false;
    }

    public boolean isRoot(File f) {
        if (f == null) {
            return false;
        }
        return super.isRoot(f);
    }

    public File[] getRoots() {
        try {
            return new FSFile[]{new FSFile(new URI(FS_NAME))};
        }
        catch (Exception exception) {
            return new FSFile[0];
        }
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        if (dir == null) {
            return null;
        }
        String root = dir.getPath();
        if (dir instanceof FSFile) {
            root = ((FSFile)dir).getPath();
        }
        FSFile[] files = null;
        try {
            String[] paths = this.server.getDirectory(root, "*");
            if (paths == null) {
                return files;
            }
            files = new FSFile[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                files[i] = new FSFile(new URI(FS_NAME + paths[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    public Boolean isTraversable(File f) {
        return false;
    }
}

