/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.KeepClientAlive;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroDataServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroImageServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataServiceImpl;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.ExperimenterData;
import pojos.GroupData;

public class DataServicesFactory {
    private static final String FS_CONFIG_FILE = "fs.config";
    private static DataServicesFactory singleton;
    private Container container;
    private static Registry registry;
    private static OMEROGateway omeroGateway;
    private OmeroDataService ds;
    private OmeroImageService is;
    private OmeroMetadataService ms;
    private ScheduledThreadPoolExecutor executor;
    private Properties fsConfig;

    public static DataServicesFactory getInstance(Container c) throws DSOutOfServiceException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            singleton = new DataServicesFactory(c);
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadConfig(String file) {
        Properties config = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            config.load(fis);
        }
        catch (Exception e) {
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {}
        }
        return config;
    }

    private DataServicesFactory(Container c) throws DSOutOfServiceException {
        registry = c.getRegistry();
        this.container = c;
        OMEROInfo omeroInfo = (OMEROInfo)registry.lookup("/services/OMERODS");
        omeroGateway = new OMEROGateway(omeroInfo.getPort(), this);
        this.ds = new OmeroDataServiceImpl(omeroGateway, registry);
        this.is = new OmeroImageServiceImpl(omeroGateway, registry);
        this.ms = new OmeroMetadataServiceImpl(omeroGateway, registry);
        this.fsConfig = DataServicesFactory.loadConfig(c.resolveConfigFile(FS_CONFIG_FILE));
        DataViewsFactory.initialize(c);
        if (omeroGateway.isUpgradeRequired()) {
            // empty if block
        }
    }

    private float determineCompression(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: 
            case 1: {
                Float value = (Float)registry.lookup("/services/RE/compressionMedium");
                return value.floatValue();
            }
        }
        Float value = (Float)registry.lookup("/services/RE/compressionLow");
        return value.floatValue();
    }

    private boolean isFastConnection(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    void sessionExpiredExit(int index) {
        UserNotifier un = registry.getUserNotifier();
        String message = "The server is no longer running. \nPlease contact your system administrator.";
        if (index == 0) {
            message = "The connection has been lost. \nThe application will exit.";
        }
        un.notifyInfo("Connection Refused", message);
        this.exitApplication();
    }

    public static void isSessionAlive(Registry reg) {
        if (!reg.equals(registry)) {
            throw new IllegalArgumentException("Not allow to access method.");
        }
        omeroGateway.isSessionAlive();
    }

    public OmeroDataService getOS() {
        return this.ds;
    }

    public OmeroImageService getIS() {
        return this.is;
    }

    public OmeroMetadataService getMS() {
        return this.ms;
    }

    public LoginService getLoginService() {
        return (LoginService)registry.lookup("/services/Login");
    }

    public void connect(UserCredentials uc) throws DSOutOfServiceException {
        Map<GroupData, Set> groups;
        if (uc == null) {
            throw new NullPointerException("No user credentials.");
        }
        omeroGateway.setPort(uc.getPort());
        ExperimenterData exp = omeroGateway.login(uc.getUserName(), uc.getPassword(), uc.getHostName(), this.determineCompression(uc.getSpeedLevel()));
        KeepClientAlive kca = new KeepClientAlive(this.container, omeroGateway);
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.scheduleWithFixedDelay(kca, 60L, 60L, TimeUnit.SECONDS);
        String ldap = omeroGateway.lookupLdapAuthExperimenter(exp.getId());
        registry.bind("/user/authentication", ldap);
        boolean fastConnection = this.isFastConnection(uc.getSpeedLevel());
        registry.bind("/current_user/details", exp);
        registry.bind("/connection/speed", fastConnection);
        ArrayList<ExperimenterData> exps = new ArrayList<ExperimenterData>();
        try {
            groups = omeroGateway.getAvailableGroups(exp);
            registry.bind("/userGroup/details", groups);
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator<Object> i = groups.keySet().iterator();
            while (i.hasNext()) {
                Set set = groups.get(i.next());
                for (ExperimenterData e : set) {
                    if (ids.contains(e.getId())) continue;
                    ids.add(e.getId());
                    exps.add(e);
                }
            }
            registry.bind("/users/details", exps);
        }
        catch (DSAccessException e) {
            throw new DSOutOfServiceException("Cannot retrieve groups", e);
        }
        List agents = (List)registry.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            Registry reg = agentInfo.getRegistry();
            reg.bind("/user/authentication", ldap);
            reg.bind("/current_user/details", exp);
            reg.bind("/userGroup/details", groups);
            reg.bind("/users/details", exps);
            reg.bind("/connection/speed", fastConnection);
        }
    }

    public boolean isConnected() {
        return omeroGateway.isConnected();
    }

    public void shutdown() {
        ((OmeroImageServiceImpl)this.is).shutDown();
        omeroGateway.logout();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    public void exitApplication() {
        this.shutdown();
        this.container.exit();
    }

    class ExitTask
    extends TimerTask {
        ExitTask() {
        }

        public void run() {
            System.exit(0);
        }
    }
}

