/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.util.HashMap;
import org.openmicroscopy.shoola.env.cache.CacheService;
import org.openmicroscopy.shoola.env.config.Entry;
import org.openmicroscopy.shoola.env.config.ObjectEntry;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.DataServicesView;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

class RegistryImpl
implements Registry {
    private HashMap<String, Object> entriesMap = new HashMap();
    private EventBus eb;
    private Logger logger;
    private TaskBar tb;
    private UserNotifier un;
    private OmeroImageService is;
    private OmeroMetadataService ms;
    private OmeroDataService os;
    private CacheService cache;

    RegistryImpl() {
    }

    public void bind(String name, Object value) {
        if (name != null) {
            ObjectEntry entry = new ObjectEntry(name);
            entry.setContent(value);
            this.entriesMap.put(name, entry);
        }
    }

    public Object lookup(String name) {
        Entry entry = (Entry)this.entriesMap.get(name);
        Object ret = null;
        if (entry != null) {
            ret = entry.getValue();
        }
        return ret;
    }

    public EventBus getEventBus() {
        return this.eb;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TaskBar getTaskBar() {
        return this.tb;
    }

    public UserNotifier getUserNotifier() {
        return this.un;
    }

    public OmeroImageService getImageService() {
        return this.is;
    }

    public OmeroDataService getDataService() {
        return this.os;
    }

    public OmeroMetadataService getMetadataService() {
        return this.ms;
    }

    public CacheService getCacheService() {
        return this.cache;
    }

    public DataServicesView getDataServicesView(Class view) {
        return DataViewsFactory.makeView(view);
    }

    void addEntry(Entry e) {
        this.entriesMap.put(e.getName(), e);
    }

    void setEventBus(EventBus eb) {
        this.eb = eb;
    }

    void setImageService(OmeroImageService is) {
        this.is = is;
    }

    void setMetadataService(OmeroMetadataService ms) {
        this.ms = ms;
    }

    void setTaskBar(TaskBar tb) {
        this.tb = tb;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    void setUserNotifier(UserNotifier un) {
        this.un = un;
    }

    void setOS(OmeroDataService os) {
        this.os = os;
    }

    void setCacheService(CacheService cache) {
        this.cache = cache;
    }
}

