/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.openmicroscopy.shoola.env.config.RegistryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Parser {
    private static String[] tagsEntry = new String[]{Entry.ENTRY, Entry.STRUCT_ENTRY};
    private boolean validating = false;
    private Document document;
    private String configFile;
    private List<Node> entriesTags;
    private RegistryImpl registry;

    private void rethrow(Exception e) throws ConfigException {
        StringBuffer msg = new StringBuffer("An error occurred while attempting to process ");
        msg.append(this.configFile);
        msg.append(".");
        String explanation = e.getMessage();
        if (explanation != null && explanation.length() != 0) {
            msg.append(" (");
            msg.append(explanation);
            msg.append(")");
        }
        throw new ConfigException(msg.toString(), e);
    }

    private void readConfigEntries() {
        for (int k = 0; k < tagsEntry.length; ++k) {
            NodeList list = this.document.getElementsByTagName(tagsEntry[k]);
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!n.hasChildNodes()) continue;
                this.entriesTags.add(n);
            }
        }
    }

    Parser(String configFile, RegistryImpl registry) {
        this.configFile = configFile;
        this.registry = registry;
        this.entriesTags = new ArrayList<Node>();
    }

    void parse() throws ConfigException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(new File(this.configFile));
            if (this.validating) {
                factory.setValidating(true);
                factory.setNamespaceAware(true);
            }
            this.readConfigEntries();
            for (Node node : this.entriesTags) {
                Entry entry = Entry.createEntryFor(node);
                this.registry.addEntry(entry);
            }
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            this.rethrow(e);
        }
    }
}

