/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class OMEROEntry
extends Entry {
    private static final String PORT_TAG = "port";
    private OMEROInfo value;

    private static OMEROInfo parseTag(Node tag) throws DOMException, ConfigException {
        String port = null;
        NodeList children = tag.getChildNodes();
        int n = children.getLength();
        while (0 < n) {
            Node child;
            if ((child = children.item(--n)).getNodeType() != 1) continue;
            String tagName = child.getNodeName();
            String tagValue = child.getFirstChild().getNodeValue();
            if (PORT_TAG.equals(tagName)) {
                port = tagValue;
                continue;
            }
            throw new ConfigException("Unrecognized tag within the ice-conf entry: " + tagName + ".");
        }
        if (port == null) {
            throw new ConfigException("Missing port tag within omeds-conf entry.");
        }
        return new OMEROInfo(port);
    }

    OMEROEntry() {
    }

    Object getValue() {
        return this.value;
    }

    protected void setContent(Node node) throws ConfigException {
        try {
            if (node.hasChildNodes()) {
                this.value = OMEROEntry.parseTag(node);
            }
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse OMERO entry.", dex);
        }
    }
}

