/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.cache;

import java.io.FileInputStream;
import java.io.InputStream;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.cache.CacheService;
import org.openmicroscopy.shoola.env.cache.CacheServiceImpl;
import org.openmicroscopy.shoola.env.config.Registry;

public class CacheServiceFactory {
    public static final String CACHE_CONFIG_FILE = "ehcache.xml";

    public static CacheService makeNew(Container container) {
        if (container == null) {
            return null;
        }
        Registry reg = container.getRegistry();
        Boolean isCachingOn = (Boolean)reg.lookup("/services/CACHE/on");
        if (!isCachingOn.booleanValue()) {
            return CacheServiceFactory.makeNoOpCache();
        }
        InputStream config = CacheServiceFactory.loadConfig(container.resolveConfigFile(CACHE_CONFIG_FILE));
        if (config == null) {
            return CacheServiceFactory.makeNoOpCache();
        }
        CacheServiceImpl cache = new CacheServiceImpl(config);
        try {
            config.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return cache;
    }

    public static void shutdown(Container container) {
        if (container == null) {
            return;
        }
        Registry reg = container.getRegistry();
        ((CacheServiceImpl)reg.getCacheService()).shutDown();
    }

    private static CacheService makeNoOpCache() {
        return new CacheService(){

            public void addElement(int cacheID, Object key, Object element) {
            }

            public int createCache() {
                return -1;
            }

            public int createCache(int type) {
                return -1;
            }

            public int createCache(int type, int size) {
                return -1;
            }

            public Object getElement(int cacheID, Object key) {
                return null;
            }

            public void removeCache(int cacheID) {
            }

            public void clearCache(int cacheID) {
            }

            public void setCacheEntries(int cacheID, int size) {
            }

            public void clearAllCaches() {
            }
        };
    }

    private static InputStream loadConfig(String file) {
        FileInputStream stream;
        try {
            stream = new FileInputStream(file);
        }
        catch (Exception e) {
            return null;
        }
        return stream;
    }
}

