/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.env.AbnormalExitHandler;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.RootThreadGroup;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.init.Initializer;
import org.openmicroscopy.shoola.env.init.StartupException;

public final class Container {
    public static final String CONFIG_DIR = "config";
    public static final String CONFIG_FILE = "container.xml";
    public static final String DOC_DIR = "docs";
    private static Container singleton;
    private String configFile;
    private String homeDir;
    private Registry registry;
    private Set<Agent> agentsPool;

    private static void runStartupProcedure(String home, String configFile) {
        AbnormalExitHandler.configure();
        Initializer initManager = null;
        try {
            singleton = new Container(home, configFile);
            initManager = new Initializer(singleton);
            initManager.configure();
            initManager.doInit();
        }
        catch (StartupException se) {
            if (initManager != null) {
                initManager.rollback();
            }
            AbnormalExitHandler.terminate(se);
        }
    }

    static Container getInstance() {
        return singleton;
    }

    public static void startup(final String home, final String configFile) {
        if (singleton != null) {
            return;
        }
        RootThreadGroup root = new RootThreadGroup();
        Runnable r = new Runnable(){

            public void run() {
                Container.runStartupProcedure(home, configFile);
            }
        };
        Thread t = new Thread(root, r, "Initializer");
        t.start();
    }

    private Container(String home, String configFile) throws StartupException {
        if (configFile == null || configFile.trim().equals("")) {
            configFile = CONFIG_FILE;
        }
        this.configFile = configFile;
        File f = new File(home == null ? "" : home);
        f = f.getAbsoluteFile();
        this.homeDir = f.getAbsolutePath();
        if (!f.exists() || !f.isDirectory()) {
            throw new StartupException("Can't locate home dir: " + this.homeDir);
        }
        this.agentsPool = new HashSet<Agent>();
        this.registry = RegistryFactory.makeNew();
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getConfigFile() {
        return this.resolveConfigFile(this.configFile);
    }

    public String resolveConfigFile(String fileName) {
        StringBuffer relPath = new StringBuffer(CONFIG_DIR);
        relPath.append(File.separatorChar);
        relPath.append(fileName);
        File f = new File(this.homeDir, relPath.toString());
        return f.getAbsolutePath();
    }

    public String resolveDocFile(String fileName) {
        if (fileName == null) {
            throw new NullPointerException();
        }
        StringBuffer relPath = new StringBuffer(DOC_DIR);
        relPath.append(File.separatorChar);
        relPath.append(fileName);
        File f = new File(this.homeDir, relPath.toString());
        return f.getAbsolutePath();
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public boolean addAgent(Agent a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return this.agentsPool.add(a);
    }

    public void startService() {
        Agent a;
        List agents = (List)Container.singleton.registry.lookup("/agents");
        Iterator i = agents.iterator();
        Environment env = new Environment(this);
        while (i.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)i.next();
            a = agentInfo.getAgent();
            Registry r = agentInfo.getRegistry();
            r.bind("/env", env);
            a.setContext(r);
        }
        for (AgentInfo agentInfo : agents) {
            a = agentInfo.getAgent();
            a.activate();
        }
    }

    public void exit() {
        List agents = (List)Container.singleton.registry.lookup("/agents");
        Iterator i = agents.iterator();
        for (AgentInfo agentInfo : agents) {
            Agent a = agentInfo.getAgent();
            if (!a.canTerminate()) continue;
            a.terminate();
        }
        System.exit(0);
    }

    public static Container startupInTestMode(String home) {
        if (singleton != null) {
            return singleton;
        }
        Initializer initManager = null;
        try {
            singleton = new Container(home, CONFIG_FILE);
            initManager = new Initializer(singleton);
            initManager.configure();
            initManager.doInit();
        }
        catch (StartupException se) {
            if (initManager != null) {
                initManager.rollback();
            }
            singleton = null;
            throw new RuntimeException("Failed to intialize the Container in test mode.", se);
        }
        return singleton;
    }
}

