/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.ui.GroupsRenderer;
import org.openmicroscopy.shoola.agents.util.ui.UserListRenderer;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.GroupData;

public class UserManagerDialog
extends JDialog
implements ActionListener {
    public static final String USER_SWITCH_PROPERTY = "userSwitch";
    public static final String NO_USER_SWITCH_PROPERTY = "noUserSwitch";
    private static final Dimension DEFAULT_SIZE = new Dimension(350, 400);
    private static final String TITLE = "Experimenter selection";
    private static final String TEXT = "Select an experimenter.";
    private static final String CANCEL_DESCRIPTION = "Close the window.";
    private static final String APPLY_DESCRIPTION = "View selected user's data.";
    private static final int CANCEL = 0;
    private static final int APPLY = 1;
    private static final int GROUPS = 2;
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private JButton cancel;
    private JButton apply;
    private JComboBox groups;
    private JList users;
    private ExperimenterData loggedUser;
    private ViewerSorter sorter;
    private Map<GroupData, Object[]> orderedMap;

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void apply() {
        HashMap<Long, ExperimenterData> r = new HashMap<Long, ExperimenterData>(1);
        GroupData g = (GroupData)this.groups.getSelectedItem();
        Object user = this.users.getSelectedValue();
        if (user == null) {
            this.firePropertyChange(NO_USER_SWITCH_PROPERTY, (Object)false, (Object)true);
            return;
        }
        r.put(g.getId(), (ExperimenterData)user);
        this.firePropertyChange(USER_SWITCH_PROPERTY, null, r);
        this.cancel();
    }

    private void setProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
    }

    private void fillList(Object[] data) {
        if (data == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.users.getModel();
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            ExperimenterData d = (ExperimenterData)data[i];
            if (d.getId() == this.loggedUser.getId()) continue;
            model.add(index, d);
            ++index;
        }
    }

    private void attachListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                UserManagerDialog.this.cancel();
            }
        });
        this.cancel.setActionCommand("0");
        this.cancel.addActionListener(this);
        this.apply.setActionCommand("1");
        this.apply.addActionListener(this);
        this.groups.setActionCommand("2");
        this.groups.addActionListener(this);
        this.users.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                UserManagerDialog.this.apply.setEnabled(!lsm.isSelectionEmpty());
            }
        });
    }

    private void initComponents(Map map, Icon userIcon) {
        this.sorter = new ViewerSorter();
        this.orderedMap = new LinkedHashMap<GroupData, Object[]>();
        this.cancel = new JButton("Cancel");
        this.cancel.setToolTipText(UIUtilities.formatToolTipText(CANCEL_DESCRIPTION));
        this.apply = new JButton("Apply");
        this.apply.setEnabled(false);
        this.apply.setToolTipText(UIUtilities.formatToolTipText(APPLY_DESCRIPTION));
        this.getRootPane().setDefaultButton(this.apply);
        GroupData defaultGroup = this.loggedUser.getDefaultGroup();
        long groupID = defaultGroup.getId();
        GroupData[] objects = new GroupData[map.size()];
        int selectedIndex = 0;
        int index = 0;
        GroupData selectedGroup = defaultGroup;
        Iterator i = this.sorter.sort(map.keySet()).iterator();
        while (i.hasNext()) {
            GroupData g;
            objects[index] = g = (GroupData)i.next();
            if (g.getId() == groupID) {
                selectedIndex = index;
                selectedGroup = g;
            }
            Object[] children = this.sorter.sortAsArray((Set)map.get(g));
            this.orderedMap.put(g, children);
            ++index;
        }
        this.groups = new JComboBox<GroupData>(objects);
        this.groups.setRenderer(new GroupsRenderer());
        DefaultListModel model = new DefaultListModel();
        this.users = new JList(model);
        this.fillList(this.orderedMap.get(selectedGroup));
        this.users.setSelectionMode(1);
        this.users.setLayoutOrientation(0);
        this.users.setCellRenderer(new UserListRenderer(userIcon));
        this.attachListeners();
        if (objects.length != 0) {
            this.groups.setSelectedIndex(selectedIndex);
        }
    }

    private JPanel buildContent() {
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, 5.0, -1.0}};
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.setLayout((LayoutManager)new TableLayout((double[][])tl));
        content.add((Component)UIUtilities.setTextFont("Groups"), "0, 0, l, t");
        content.add((Component)this.groups, "1, 0");
        content.add((Component)UIUtilities.setTextFont("Users"), "0, 2, l, t");
        content.add((Component)new JScrollPane(this.users), "1, 2");
        return content;
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.apply);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancel);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        return p;
    }

    private void buildGUI(Icon icon) {
        TitlePanel titlePanel = new TitlePanel(TITLE, TEXT, icon);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)titlePanel), "North");
        c.add((Component)this.buildContent(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public UserManagerDialog(JFrame parent, ExperimenterData loggedUser, Map groups, Icon userIcon, Icon icon) {
        super(parent);
        this.setProperties();
        this.loggedUser = loggedUser;
        this.initComponents(groups, userIcon);
        this.buildGUI(icon);
    }

    public void setDefaultSize() {
        this.setSize(DEFAULT_SIZE);
    }

    public void actionPerformed(ActionEvent e) {
        int id = Integer.parseInt(e.getActionCommand());
        switch (id) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.apply();
                break;
            }
            case 2: {
                DefaultListModel model = (DefaultListModel)this.users.getModel();
                model.clear();
                this.fillList(this.orderedMap.get(this.groups.getSelectedItem()));
            }
        }
    }
}

