/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.finder;

import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.agents.util.finder.Finder;
import org.openmicroscopy.shoola.agents.util.finder.QuickFinder;
import org.openmicroscopy.shoola.env.config.Registry;
import pojos.DataObject;

public class FinderFactory {
    private static final FinderFactory singleton = new FinderFactory();
    private Registry registry;
    private Finder finder;

    public static AdvancedFinder getAdvancedFinder(Registry ctx) {
        return FinderFactory.getAdvancedFinder(ctx, null);
    }

    public static AdvancedFinder getAdvancedFinder(Registry ctx, DataObject refObject) {
        if (FinderFactory.singleton.registry == null) {
            FinderFactory.singleton.registry = ctx;
        }
        return (AdvancedFinder)singleton.createFinder(refObject);
    }

    public static QuickFinder getQuickFinder(Registry ctx) {
        return FinderFactory.getQuickFinder(ctx, null);
    }

    public static QuickFinder getQuickFinder(Registry ctx, DataObject refObject) {
        if (FinderFactory.singleton.registry == null) {
            FinderFactory.singleton.registry = ctx;
        }
        return (QuickFinder)singleton.createQuickFinder(refObject);
    }

    public static Registry getRegistry() {
        return FinderFactory.singleton.registry;
    }

    public static JFrame getRefFrame() {
        return FinderFactory.singleton.registry.getTaskBar().getFrame();
    }

    private FinderFactory() {
    }

    private Finder createFinder(DataObject refObject) {
        if (this.finder != null) {
            return this.finder;
        }
        this.finder = new AdvancedFinder();
        return this.finder;
    }

    private Finder createQuickFinder(DataObject refObject) {
        return new QuickFinder();
    }
}

